/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.skyrenderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.settings.CloudOption;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.client.world.DimensionRenderInfo;
import net.minecraft.fluid.FluidState;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ICloudRenderHandler;
import net.minecraftforge.client.ISkyRenderHandler;
import net.minecraftforge.client.IWeatherParticleRenderHandler;
import net.minecraftforge.client.IWeatherRenderHandler;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.mrscauthd.boss_tools.ModInnet;

@Mod.EventBusSubscriber(modid="boss_tools", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEventBusVenus {
    private static final float[] rainSizeX = new float[1024];
    private static final float[] rainSizeZ = new float[1024];
    private static int rainSoundTime;
    private static int cloudsCheckX;
    private static int cloudsCheckY;
    private static int cloudsCheckZ;
    private static Vector3d cloudsCheckColor;
    private static boolean cloudsNeedUpdate;
    private static VertexBuffer cloudsVBO;
    private static CloudOption cloudOption;
    private static final ResourceLocation DIM_RENDER_INFO;
    private static final ResourceLocation CLOUD_TEXTURE;
    private static final ResourceLocation RAIN_TEXTURE;
    private static final ResourceLocation SUN_TEXTURE;
    private static final ResourceLocation EARTH_TEXTURE;

    public static int getCombinedLight(IBlockDisplayReader lightReaderIn, BlockPos blockPosIn) {
        return WorldRenderer.func_228420_a_((IBlockDisplayReader)lightReaderIn, (BlockState)lightReaderIn.func_180495_p(blockPosIn), (BlockPos)blockPosIn);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void clientSetup(FMLClientSetupEvent event) {
        DimensionRenderInfo.field_239208_a_.put((Object)DIM_RENDER_INFO, (Object)new DimensionRenderInfo(128.0f, false, DimensionRenderInfo.FogType.NORMAL, false, false){

            public Vector3d func_230494_a_(Vector3d color, float sunHeight) {
                return new Vector3d(0.647058823529, 0.450980392157, 0.254901960784);
            }

            public boolean func_230493_a_(int posX, int posY) {
                return true;
            }

            public IWeatherRenderHandler getWeatherRenderHandler() {
                return new IWeatherRenderHandler(){

                    public void render(int ticks, float partialTicks, ClientWorld world, Minecraft mc, LightTexture lightmapIn, double xIn, double yIn, double zIn) {
                        for (int i = 0; i < 32; ++i) {
                            for (int j = 0; j < 32; ++j) {
                                float f = j - 16;
                                float f1 = i - 16;
                                float f2 = MathHelper.func_76129_c((float)(f * f + f1 * f1));
                                rainSizeX[i << 5 | j] = -f1 / f2;
                                rainSizeZ[i << 5 | j] = f / f2;
                            }
                        }
                        float f = Minecraft.func_71410_x().field_71441_e.func_72867_j(partialTicks);
                        if (!(f <= 0.0f)) {
                            lightmapIn.func_205109_c();
                            int i = MathHelper.func_76128_c((double)xIn);
                            int j = MathHelper.func_76128_c((double)yIn);
                            int k = MathHelper.func_76128_c((double)zIn);
                            Tessellator tessellator = Tessellator.func_178181_a();
                            BufferBuilder bufferbuilder = tessellator.func_178180_c();
                            RenderSystem.enableAlphaTest();
                            RenderSystem.disableCull();
                            RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
                            RenderSystem.enableBlend();
                            RenderSystem.defaultBlendFunc();
                            RenderSystem.defaultAlphaFunc();
                            RenderSystem.enableDepthTest();
                            int l = 5;
                            if (Minecraft.func_71375_t()) {
                                l = 10;
                            }
                            RenderSystem.depthMask((boolean)Minecraft.func_238218_y_());
                            int i1 = -1;
                            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
                            for (int j1 = k - l; j1 <= k + l; ++j1) {
                                for (int k1 = i - l; k1 <= i + l; ++k1) {
                                    int l1 = (j1 - k + 16) * 32 + k1 - i + 16;
                                    double d0 = (double)rainSizeX[l1] * 0.5;
                                    double d1 = (double)rainSizeZ[l1] * 0.5;
                                    blockpos$mutable.func_181079_c(k1, 0, j1);
                                    Biome biome = world.func_226691_t_((BlockPos)blockpos$mutable);
                                    if (biome.func_201851_b() == Biome.RainType.NONE) continue;
                                    int i2 = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, (BlockPos)blockpos$mutable).func_177956_o();
                                    int j2 = j - l;
                                    int k2 = j + l;
                                    if (j2 < i2) {
                                        j2 = i2;
                                    }
                                    if (k2 < i2) {
                                        k2 = i2;
                                    }
                                    int l2 = i2;
                                    if (i2 < j) {
                                        l2 = j;
                                    }
                                    if (j2 == k2) continue;
                                    Random random = new Random(k1 * k1 * 3121 + k1 * 45238971 ^ j1 * j1 * 418711 + j1 * 13761);
                                    blockpos$mutable.func_181079_c(k1, j2, j1);
                                    if (i1 != 0) {
                                        if (i1 >= 0) {
                                            tessellator.func_78381_a();
                                        }
                                        i1 = 0;
                                        mc.func_110434_K().func_110577_a(RAIN_TEXTURE);
                                        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                                    }
                                    int i3 = ticks + k1 * k1 * 3121 + k1 * 45238971 + j1 * j1 * 418711 + j1 * 13761 & 0x1F;
                                    float f3 = -((float)i3 + partialTicks) / 32.0f * (3.0f + random.nextFloat());
                                    double d2 = (double)((float)k1 + 0.5f) - xIn;
                                    double d4 = (double)((float)j1 + 0.5f) - zIn;
                                    float f4 = MathHelper.func_76133_a((double)(d2 * d2 + d4 * d4)) / (float)l;
                                    float f5 = ((1.0f - f4 * f4) * 0.5f + 0.5f) * f;
                                    blockpos$mutable.func_181079_c(k1, l2, j1);
                                    int j3 = ClientEventBusVenus.getCombinedLight((IBlockDisplayReader)world, (BlockPos)blockpos$mutable);
                                    bufferbuilder.func_225582_a_((double)k1 - xIn - d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn - d1 + 0.5).func_225583_a_(0.0f, (float)j2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                                    bufferbuilder.func_225582_a_((double)k1 - xIn + d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn + d1 + 0.5).func_225583_a_(1.0f, (float)j2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                                    bufferbuilder.func_225582_a_((double)k1 - xIn + d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn + d1 + 0.5).func_225583_a_(1.0f, (float)k2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                                    bufferbuilder.func_225582_a_((double)k1 - xIn - d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn - d1 + 0.5).func_225583_a_(0.0f, (float)k2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                                }
                            }
                            if (i1 >= 0) {
                                tessellator.func_78381_a();
                            }
                            RenderSystem.enableCull();
                            RenderSystem.disableBlend();
                            RenderSystem.defaultAlphaFunc();
                            RenderSystem.disableAlphaTest();
                            lightmapIn.func_205108_b();
                        }
                    }
                };
            }

            public IWeatherParticleRenderHandler getWeatherParticleRenderHandler() {
                return new IWeatherParticleRenderHandler(){

                    public void render(int ticks, ClientWorld world, Minecraft mc, ActiveRenderInfo activeRenderInfoIn) {
                        float f = mc.field_71441_e.func_72867_j(1.0f) / (Minecraft.func_71375_t() ? 1.0f : 2.0f);
                        if (!(f <= 0.0f)) {
                            Random random = new Random((long)ticks * 312987231L);
                            ClientWorld iworldreader = mc.field_71441_e;
                            BlockPos blockpos = new BlockPos(activeRenderInfoIn.func_216785_c());
                            BlockPos blockpos1 = null;
                            int i = (int)(100.0f * f * f) / (mc.field_71474_y.field_74362_aa == ParticleStatus.DECREASED ? 2 : 1);
                            for (int j = 0; j < i; ++j) {
                                int k = random.nextInt(21) - 10;
                                int l = random.nextInt(21) - 10;
                                BlockPos blockpos2 = iworldreader.func_205770_a(Heightmap.Type.MOTION_BLOCKING, blockpos.func_177982_a(k, 0, l)).func_177977_b();
                                Biome biome = iworldreader.func_226691_t_(blockpos2);
                                if (blockpos2.func_177956_o() <= 0 || blockpos2.func_177956_o() > blockpos.func_177956_o() + 10 || blockpos2.func_177956_o() < blockpos.func_177956_o() - 10 || biome.func_201851_b() != Biome.RainType.RAIN || !(biome.func_225486_c(blockpos2) >= 0.15f)) continue;
                                blockpos1 = blockpos2;
                                if (mc.field_71474_y.field_74362_aa == ParticleStatus.MINIMAL) break;
                                double d0 = random.nextDouble();
                                double d1 = random.nextDouble();
                                BlockState blockstate = iworldreader.func_180495_p(blockpos2);
                                FluidState fluidstate = iworldreader.func_204610_c(blockpos2);
                                VoxelShape voxelshape = blockstate.func_196952_d((IBlockReader)iworldreader, blockpos2);
                                double d2 = voxelshape.func_197760_b(Direction.Axis.Y, d0, d1);
                                double d3 = fluidstate.func_215679_a((IBlockReader)iworldreader, blockpos2);
                                double d4 = Math.max(d2, d3);
                                BasicParticleType iparticledata = !fluidstate.func_206884_a((ITag)FluidTags.field_206960_b) && !blockstate.func_203425_a(Blocks.field_196814_hQ) && !CampfireBlock.func_226915_i_((BlockState)blockstate) ? (IParticleData)ModInnet.VENUS_RAIN_PARTICLE.get() : ParticleTypes.field_197601_L;
                                mc.field_71441_e.func_195594_a((IParticleData)iparticledata, (double)blockpos2.func_177958_n() + d0, (double)blockpos2.func_177956_o() + d4, (double)blockpos2.func_177952_p() + d1, 0.0, 0.0, 0.0);
                            }
                            if (blockpos1 != null && random.nextInt(3) < rainSoundTime++) {
                                rainSoundTime = 0;
                                if (blockpos1.func_177956_o() > blockpos.func_177956_o() + 1 && iworldreader.func_205770_a(Heightmap.Type.MOTION_BLOCKING, blockpos).func_177956_o() > MathHelper.func_76141_d((float)blockpos.func_177956_o())) {
                                    mc.field_71441_e.func_184156_a(blockpos1, SoundEvents.field_187919_gs, SoundCategory.WEATHER, 0.1f, 0.5f, false);
                                } else {
                                    mc.field_71441_e.func_184156_a(blockpos1, SoundEvents.field_187918_gr, SoundCategory.WEATHER, 0.2f, 1.0f, false);
                                }
                            }
                        }
                    }
                };
            }

            public ICloudRenderHandler getCloudRenderHandler() {
                return new ICloudRenderHandler(){

                    public void render(int ticks, float partialTicks, MatrixStack matrixStack, ClientWorld world, Minecraft mc, double viewEntityX, double viewEntityY, double viewEntityZ) {
                        float f = world.func_239132_a_().func_239213_a_();
                        if (!Float.isNaN(f)) {
                            RenderSystem.disableCull();
                            RenderSystem.enableBlend();
                            RenderSystem.enableAlphaTest();
                            RenderSystem.enableDepthTest();
                            RenderSystem.defaultAlphaFunc();
                            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                            RenderSystem.enableFog();
                            RenderSystem.depthMask((boolean)true);
                            float f1 = 12.0f;
                            float f2 = 4.0f;
                            double d0 = 2.0E-4;
                            double d1 = ((float)ticks + partialTicks) * 0.03f;
                            double d2 = (viewEntityX + d1) / 12.0;
                            double d3 = f - (float)viewEntityY + 0.33f;
                            double d4 = viewEntityZ / 12.0 + (double)0.33f;
                            d2 -= (double)(MathHelper.func_76128_c((double)(d2 / 2048.0)) * 2048);
                            d4 -= (double)(MathHelper.func_76128_c((double)(d4 / 2048.0)) * 2048);
                            float f3 = (float)(d2 - (double)MathHelper.func_76128_c((double)d2));
                            float f4 = (float)(d3 / 4.0 - (double)MathHelper.func_76128_c((double)(d3 / 4.0))) * 4.0f;
                            float f5 = (float)(d4 - (double)MathHelper.func_76128_c((double)d4));
                            Vector3d vector3d = world.func_228328_h_(partialTicks);
                            int i = (int)Math.floor(d2);
                            int j = (int)Math.floor(d3 / 4.0);
                            int k = (int)Math.floor(d4);
                            if (i != cloudsCheckX || j != cloudsCheckY || k != cloudsCheckZ || Minecraft.func_71410_x().field_71474_y.func_216842_e() != cloudOption || cloudsCheckColor.func_72436_e(vector3d) > 2.0E-4) {
                                cloudsCheckX = i;
                                cloudsCheckY = j;
                                cloudsCheckZ = k;
                                cloudsCheckColor = vector3d;
                                cloudOption = Minecraft.func_71410_x().field_71474_y.func_216842_e();
                                cloudsNeedUpdate = true;
                            }
                            if (cloudsNeedUpdate) {
                                cloudsNeedUpdate = false;
                                BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
                                if (cloudsVBO != null) {
                                    cloudsVBO.close();
                                }
                                cloudsVBO = new VertexBuffer(DefaultVertexFormats.field_181712_l);
                                this.drawClouds(bufferbuilder, d2, d3, d4, vector3d);
                                bufferbuilder.func_178977_d();
                                cloudsVBO.func_227875_a_(bufferbuilder);
                            }
                            mc.func_110434_K().func_110577_a(CLOUD_TEXTURE);
                            matrixStack.func_227860_a_();
                            matrixStack.func_227862_a_(12.0f, 1.0f, 12.0f);
                            matrixStack.func_227861_a_((double)(-f3), (double)f4, (double)(-f5));
                            if (cloudsVBO != null) {
                                int i1;
                                cloudsVBO.func_177359_a();
                                DefaultVertexFormats.field_181712_l.func_227892_a_(0L);
                                for (int l = i1 = cloudOption == CloudOption.FANCY ? 0 : 1; l < 2; ++l) {
                                    if (l == 0) {
                                        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                                    } else {
                                        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                                    }
                                    cloudsVBO.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
                                }
                                VertexBuffer.func_177361_b();
                                DefaultVertexFormats.field_181712_l.func_227895_d_();
                            }
                            matrixStack.func_227865_b_();
                            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            RenderSystem.disableAlphaTest();
                            RenderSystem.enableCull();
                            RenderSystem.disableBlend();
                            RenderSystem.disableFog();
                        }
                    }

                    private void drawClouds(BufferBuilder bufferIn, double cloudsX, double cloudsY, double cloudsZ, Vector3d cloudsColor) {
                        float f = 4.0f;
                        float f1 = 0.00390625f;
                        int i = 8;
                        int j = 4;
                        float f2 = 9.765625E-4f;
                        float f3 = (float)MathHelper.func_76128_c((double)cloudsX) * 0.00390625f;
                        float f4 = (float)MathHelper.func_76128_c((double)cloudsZ) * 0.00390625f;
                        float f5 = (float)cloudsColor.field_72450_a;
                        float f6 = (float)cloudsColor.field_72448_b;
                        float f7 = (float)cloudsColor.field_72449_c;
                        float f8 = f5 * 0.9f;
                        float f9 = f6 * 0.9f;
                        float f10 = f7 * 0.9f;
                        float f11 = f5 * 0.7f;
                        float f12 = f6 * 0.7f;
                        float f13 = f7 * 0.7f;
                        float f14 = f5 * 0.8f;
                        float f15 = f6 * 0.8f;
                        float f16 = f7 * 0.8f;
                        bufferIn.func_181668_a(7, DefaultVertexFormats.field_181712_l);
                        float f17 = (float)Math.floor(cloudsY / 4.0) * 4.0f;
                        if (cloudOption == CloudOption.FANCY) {
                            for (int k = -3; k <= 4; ++k) {
                                for (int l = -3; l <= 4; ++l) {
                                    float f18 = k * 8;
                                    float f19 = l * 8;
                                    if (f17 > -5.0f) {
                                        bufferIn.func_225582_a_((double)(f18 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + 8.0f)).func_225583_a_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).func_227885_a_(f11, f12, f13, 0.8f).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                                        bufferIn.func_225582_a_((double)(f18 + 8.0f), (double)(f17 + 0.0f), (double)(f19 + 8.0f)).func_225583_a_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).func_227885_a_(f11, f12, f13, 0.8f).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                                        bufferIn.func_225582_a_((double)(f18 + 8.0f), (double)(f17 + 0.0f), (double)(f19 + 0.0f)).func_225583_a_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).func_227885_a_(f11, f12, f13, 0.8f).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                                        bufferIn.func_225582_a_((double)(f18 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + 0.0f)).func_225583_a_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).func_227885_a_(f11, f12, f13, 0.8f).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                                    }
                                    if (f17 <= 5.0f) {
                                        bufferIn.func_225582_a_((double)(f18 + 0.0f), (double)(f17 + 4.0f - 9.765625E-4f), (double)(f19 + 8.0f)).func_225583_a_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).func_227885_a_(f5, f6, f7, 0.8f).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
                                        bufferIn.func_225582_a_((double)(f18 + 8.0f), (double)(f17 + 4.0f - 9.765625E-4f), (double)(f19 + 8.0f)).func_225583_a_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).func_227885_a_(f5, f6, f7, 0.8f).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
                                        bufferIn.func_225582_a_((double)(f18 + 8.0f), (double)(f17 + 4.0f - 9.765625E-4f), (double)(f19 + 0.0f)).func_225583_a_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).func_227885_a_(f5, f6, f7, 0.8f).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
                                        bufferIn.func_225582_a_((double)(f18 + 0.0f), (double)(f17 + 4.0f - 9.765625E-4f), (double)(f19 + 0.0f)).func_225583_a_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).func_227885_a_(f5, f6, f7, 0.8f).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
                                    }
                                    if (k > -1) {
                                        for (int i1 = 0; i1 < 8; ++i1) {
                                            bufferIn.func_225582_a_((double)(f18 + (float)i1 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + 8.0f)).func_225583_a_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).func_227885_a_(f8, f9, f10, 0.8f).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
                                            bufferIn.func_225582_a_((double)(f18 + (float)i1 + 0.0f), (double)(f17 + 4.0f), (double)(f19 + 8.0f)).func_225583_a_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).func_227885_a_(f8, f9, f10, 0.8f).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
                                            bufferIn.func_225582_a_((double)(f18 + (float)i1 + 0.0f), (double)(f17 + 4.0f), (double)(f19 + 0.0f)).func_225583_a_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).func_227885_a_(f8, f9, f10, 0.8f).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
                                            bufferIn.func_225582_a_((double)(f18 + (float)i1 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + 0.0f)).func_225583_a_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).func_227885_a_(f8, f9, f10, 0.8f).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
                                        }
                                    }
                                    if (k <= 1) {
                                        for (int j2 = 0; j2 < 8; ++j2) {
                                            bufferIn.func_225582_a_((double)(f18 + (float)j2 + 1.0f - 9.765625E-4f), (double)(f17 + 0.0f), (double)(f19 + 8.0f)).func_225583_a_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).func_227885_a_(f8, f9, f10, 0.8f).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
                                            bufferIn.func_225582_a_((double)(f18 + (float)j2 + 1.0f - 9.765625E-4f), (double)(f17 + 4.0f), (double)(f19 + 8.0f)).func_225583_a_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).func_227885_a_(f8, f9, f10, 0.8f).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
                                            bufferIn.func_225582_a_((double)(f18 + (float)j2 + 1.0f - 9.765625E-4f), (double)(f17 + 4.0f), (double)(f19 + 0.0f)).func_225583_a_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).func_227885_a_(f8, f9, f10, 0.8f).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
                                            bufferIn.func_225582_a_((double)(f18 + (float)j2 + 1.0f - 9.765625E-4f), (double)(f17 + 0.0f), (double)(f19 + 0.0f)).func_225583_a_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).func_227885_a_(f8, f9, f10, 0.8f).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
                                        }
                                    }
                                    if (l > -1) {
                                        for (int k2 = 0; k2 < 8; ++k2) {
                                            bufferIn.func_225582_a_((double)(f18 + 0.0f), (double)(f17 + 4.0f), (double)(f19 + (float)k2 + 0.0f)).func_225583_a_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).func_227885_a_(f14, f15, f16, 0.8f).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
                                            bufferIn.func_225582_a_((double)(f18 + 8.0f), (double)(f17 + 4.0f), (double)(f19 + (float)k2 + 0.0f)).func_225583_a_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).func_227885_a_(f14, f15, f16, 0.8f).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
                                            bufferIn.func_225582_a_((double)(f18 + 8.0f), (double)(f17 + 0.0f), (double)(f19 + (float)k2 + 0.0f)).func_225583_a_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).func_227885_a_(f14, f15, f16, 0.8f).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
                                            bufferIn.func_225582_a_((double)(f18 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + (float)k2 + 0.0f)).func_225583_a_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).func_227885_a_(f14, f15, f16, 0.8f).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
                                        }
                                    }
                                    if (l > 1) continue;
                                    for (int l2 = 0; l2 < 8; ++l2) {
                                        bufferIn.func_225582_a_((double)(f18 + 0.0f), (double)(f17 + 4.0f), (double)(f19 + (float)l2 + 1.0f - 9.765625E-4f)).func_225583_a_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).func_227885_a_(f14, f15, f16, 0.8f).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
                                        bufferIn.func_225582_a_((double)(f18 + 8.0f), (double)(f17 + 4.0f), (double)(f19 + (float)l2 + 1.0f - 9.765625E-4f)).func_225583_a_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).func_227885_a_(f14, f15, f16, 0.8f).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
                                        bufferIn.func_225582_a_((double)(f18 + 8.0f), (double)(f17 + 0.0f), (double)(f19 + (float)l2 + 1.0f - 9.765625E-4f)).func_225583_a_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).func_227885_a_(f14, f15, f16, 0.8f).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
                                        bufferIn.func_225582_a_((double)(f18 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + (float)l2 + 1.0f - 9.765625E-4f)).func_225583_a_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).func_227885_a_(f14, f15, f16, 0.8f).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
                                    }
                                }
                            }
                        } else {
                            boolean j1 = true;
                            int k1 = 32;
                            for (int l1 = -32; l1 < 32; l1 += 32) {
                                for (int i2 = -32; i2 < 32; i2 += 32) {
                                    bufferIn.func_225582_a_((double)(l1 + 0), (double)f17, (double)(i2 + 32)).func_225583_a_((float)(l1 + 0) * 0.00390625f + f3, (float)(i2 + 32) * 0.00390625f + f4).func_227885_a_(f5, f6, f7, 0.8f).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                                    bufferIn.func_225582_a_((double)(l1 + 32), (double)f17, (double)(i2 + 32)).func_225583_a_((float)(l1 + 32) * 0.00390625f + f3, (float)(i2 + 32) * 0.00390625f + f4).func_227885_a_(f5, f6, f7, 0.8f).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                                    bufferIn.func_225582_a_((double)(l1 + 32), (double)f17, (double)(i2 + 0)).func_225583_a_((float)(l1 + 32) * 0.00390625f + f3, (float)(i2 + 0) * 0.00390625f + f4).func_227885_a_(f5, f6, f7, 0.8f).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                                    bufferIn.func_225582_a_((double)(l1 + 0), (double)f17, (double)(i2 + 0)).func_225583_a_((float)(l1 + 0) * 0.00390625f + f3, (float)(i2 + 0) * 0.00390625f + f4).func_227885_a_(f5, f6, f7, 0.8f).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                                }
                            }
                        }
                    }
                };
            }

            public ISkyRenderHandler getSkyRenderHandler() {
                return new ISkyRenderHandler(){

                    public void render(int ticks, float partialTicks, MatrixStack matrixStack, ClientWorld world, Minecraft mc) {
                        RenderSystem.disableTexture();
                        Vector3d vector3d = world.func_228318_a_(mc.field_71460_t.func_215316_n().func_216780_d(), partialTicks);
                        float f = (float)vector3d.field_72450_a;
                        float f1 = (float)vector3d.field_72448_b;
                        float f2 = (float)vector3d.field_72449_c;
                        FogRenderer.func_228373_b_();
                        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
                        RenderSystem.depthMask((boolean)false);
                        RenderSystem.enableFog();
                        RenderSystem.color3f((float)0.81960785f, (float)0.54509807f, (float)0.32156864f);
                        mc.field_71438_f.field_175012_t.func_177359_a();
                        mc.field_71438_f.field_175014_r.func_227892_a_(0L);
                        mc.field_71438_f.field_175012_t.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
                        VertexBuffer.func_177361_b();
                        mc.field_71438_f.field_175014_r.func_227895_d_();
                        Matrix4f matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
                        RenderSystem.enableAlphaTest();
                        RenderSystem.enableTexture();
                        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        RenderSystem.disableTexture();
                        RenderSystem.disableFog();
                        RenderSystem.disableAlphaTest();
                        RenderSystem.enableBlend();
                        RenderSystem.defaultBlendFunc();
                        float[] afloat = world.func_239132_a_().func_230492_a_(world.func_242415_f(partialTicks), partialTicks);
                        if (afloat != null) {
                            RenderSystem.disableTexture();
                            RenderSystem.shadeModel((int)7425);
                            matrixStack.func_227860_a_();
                            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                            float f3 = MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f;
                            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f3));
                            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
                            float f4 = afloat[0];
                            float f5 = afloat[1];
                            float f6 = afloat[2];
                            Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
                            bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
                            bufferbuilder.func_227888_a_(matrix4f, 0.0f, 100.0f, 0.0f).func_227885_a_(f4, f5, f6, afloat[3]).func_181675_d();
                            for (int j = 0; j <= 16; ++j) {
                                float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                                float f8 = MathHelper.func_76126_a((float)f7);
                                float f9 = MathHelper.func_76134_b((float)f7);
                                bufferbuilder.func_227888_a_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).func_227885_a_(afloat[0], afloat[1], afloat[2], 0.0f).func_181675_d();
                            }
                            bufferbuilder.func_178977_d();
                            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
                            matrixStack.func_227865_b_();
                            RenderSystem.shadeModel((int)7424);
                        }
                        RenderSystem.enableTexture();
                        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                        matrixStack.func_227860_a_();
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(world.func_242415_f(partialTicks) * 360.0f));
                        matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
                        float f12 = 20.0f;
                        mc.func_110434_K().func_110577_a(SUN_TEXTURE);
                        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                        bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, -f12).func_225583_a_(0.0f, 0.0f).func_181675_d();
                        bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, -f12).func_225583_a_(1.0f, 0.0f).func_181675_d();
                        bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, f12).func_225583_a_(1.0f, 1.0f).func_181675_d();
                        bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, f12).func_225583_a_(0.0f, 1.0f).func_181675_d();
                        bufferbuilder.func_178977_d();
                        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
                        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-130.0f));
                        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(210.0f));
                        mc.func_110434_K().func_110577_a(EARTH_TEXTURE);
                        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                        bufferbuilder.func_227888_a_(matrix4f1, -2.0f, -100.0f, 2.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
                        bufferbuilder.func_227888_a_(matrix4f1, 2.0f, -100.0f, 2.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
                        bufferbuilder.func_227888_a_(matrix4f1, 2.0f, -100.0f, -2.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
                        bufferbuilder.func_227888_a_(matrix4f1, -2.0f, -100.0f, -2.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
                        bufferbuilder.func_178977_d();
                        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
                        RenderSystem.disableTexture();
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        mc.field_71438_f.field_175013_s.func_177359_a();
                        mc.field_71438_f.field_175014_r.func_227892_a_(0L);
                        mc.field_71438_f.field_175013_s.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
                        VertexBuffer.func_177361_b();
                        mc.field_71438_f.field_175014_r.func_227895_d_();
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        RenderSystem.disableBlend();
                        RenderSystem.enableAlphaTest();
                        RenderSystem.enableFog();
                        matrixStack.func_227865_b_();
                        RenderSystem.disableTexture();
                        RenderSystem.color3f((float)0.0f, (float)0.0f, (float)0.0f);
                        double d0 = mc.field_71439_g.func_174824_e((float)partialTicks).field_72448_b - world.func_72912_H().func_239159_f_();
                        if (d0 < 0.0) {
                            matrixStack.func_227860_a_();
                            matrixStack.func_227861_a_(0.0, 12.0, 0.0);
                            mc.field_71438_f.field_175011_u.func_177359_a();
                            mc.field_71438_f.field_175014_r.func_227892_a_(0L);
                            mc.field_71438_f.field_175011_u.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
                            VertexBuffer.func_177361_b();
                            mc.field_71438_f.field_175014_r.func_227895_d_();
                            matrixStack.func_227865_b_();
                        }
                        if (world.func_239132_a_().func_239216_b_()) {
                            RenderSystem.color3f((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f));
                        } else {
                            RenderSystem.color3f((float)f, (float)f1, (float)f2);
                        }
                        RenderSystem.enableTexture();
                        RenderSystem.depthMask((boolean)true);
                        RenderSystem.disableFog();
                    }
                };
            }
        });
    }

    static {
        cloudsCheckX = Integer.MIN_VALUE;
        cloudsCheckY = Integer.MIN_VALUE;
        cloudsCheckZ = Integer.MIN_VALUE;
        cloudsCheckColor = Vector3d.field_186680_a;
        cloudsNeedUpdate = true;
        DIM_RENDER_INFO = new ResourceLocation("boss_tools", "venus");
        CLOUD_TEXTURE = new ResourceLocation("boss_tools", "textures/sky/clouds.png");
        RAIN_TEXTURE = new ResourceLocation("boss_tools", "textures/sky/rain.png");
        SUN_TEXTURE = new ResourceLocation("boss_tools", "textures/sky/sun.png");
        EARTH_TEXTURE = new ResourceLocation("boss_tools", "textures/sky/earth.png");
    }
}

