/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.skyrenderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.settings.GraphicsFanciness;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.client.world.DimensionRenderInfo;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ICloudRenderHandler;
import net.minecraftforge.client.ISkyRenderHandler;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="boss_tools", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEventBusVenusOrbit {
    @Nullable
    public static VertexBuffer starVBO;
    public static final VertexFormat skyVertexFormat;
    private static final ResourceLocation DIM_RENDER_INFO;
    private static final ResourceLocation VENUS_TEXTURE;
    private static final ResourceLocation SUN_TEXTURE;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void clientSetup(FMLClientSetupEvent event) {
        DimensionRenderInfo.field_239208_a_.put((Object)DIM_RENDER_INFO, (Object)new DimensionRenderInfo(128.0f, false, DimensionRenderInfo.FogType.NORMAL, false, false){

            public Vector3d func_230494_a_(Vector3d fogColor, float partialTicks) {
                return fogColor;
            }

            public boolean func_230493_a_(int posX, int posY) {
                return false;
            }

            public ICloudRenderHandler getCloudRenderHandler() {
                return new ICloudRenderHandler(){

                    public void render(int ticks, float partialTicks, MatrixStack matrixStack, ClientWorld world, Minecraft mc, double viewEntityX, double viewEntityY, double viewEntityZ) {
                    }
                };
            }

            public ISkyRenderHandler getSkyRenderHandler() {
                return new ISkyRenderHandler(){

                    public void render(int ticks, float partialTicks, MatrixStack matrixStack, ClientWorld world, Minecraft mc) {
                        RenderSystem.disableTexture();
                        Vector3d vector3d = world.func_228318_a_(mc.field_71460_t.func_215316_n().func_216780_d(), partialTicks);
                        float f = (float)vector3d.field_72450_a;
                        float f1 = (float)vector3d.field_72448_b;
                        float f2 = (float)vector3d.field_72449_c;
                        FogRenderer.func_228373_b_();
                        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
                        RenderSystem.depthMask((boolean)false);
                        RenderSystem.enableFog();
                        RenderSystem.color3f((float)f, (float)f1, (float)f2);
                        mc.field_71438_f.field_175012_t.func_177359_a();
                        mc.field_71438_f.field_175014_r.func_227892_a_(0L);
                        mc.field_71438_f.field_175012_t.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
                        VertexBuffer.func_177361_b();
                        mc.field_71438_f.field_175014_r.func_227895_d_();
                        Matrix4f matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
                        RenderSystem.enableAlphaTest();
                        RenderSystem.enableTexture();
                        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        this.generateStars();
                        RenderSystem.disableTexture();
                        RenderSystem.disableFog();
                        RenderSystem.disableAlphaTest();
                        RenderSystem.enableBlend();
                        RenderSystem.defaultBlendFunc();
                        float[] afloat = world.func_239132_a_().func_230492_a_(world.func_242415_f(partialTicks), partialTicks);
                        if (afloat != null) {
                            RenderSystem.disableTexture();
                            RenderSystem.shadeModel((int)7425);
                            matrixStack.func_227860_a_();
                            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                            float f3 = MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f;
                            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f3));
                            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
                            float f4 = afloat[0];
                            float f5 = afloat[1];
                            float f6 = afloat[2];
                            Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
                            bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
                            bufferbuilder.func_227888_a_(matrix4f, 0.0f, 100.0f, 0.0f).func_227885_a_(f4, f5, f6, afloat[3]).func_181675_d();
                            for (int j = 0; j <= 16; ++j) {
                                float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                                float f8 = MathHelper.func_76126_a((float)f7);
                                float f9 = MathHelper.func_76134_b((float)f7);
                                bufferbuilder.func_227888_a_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).func_227885_a_(afloat[0], afloat[1], afloat[2], 0.0f).func_181675_d();
                            }
                            bufferbuilder.func_178977_d();
                            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
                            matrixStack.func_227865_b_();
                            RenderSystem.shadeModel((int)7424);
                        }
                        RenderSystem.enableTexture();
                        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                        matrixStack.func_227860_a_();
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(0.0f));
                        matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
                        RenderSystem.enableDepthTest();
                        RenderSystem.depthMask((boolean)true);
                        float var20 = -3000.0f + (float)Minecraft.func_71410_x().field_71439_g.func_226278_cu_() * 6.0f;
                        float scale = 100.0f * (0.3f - var20 / 10000.0f);
                        scale = Math.max(scale, 4.0f);
                        mc.func_110434_K().func_110577_a(VENUS_TEXTURE);
                        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                        bufferbuilder.func_227888_a_(matrix4f1, -scale, -180.0f, scale).func_225583_a_(0.0f, 0.0f).func_181675_d();
                        bufferbuilder.func_227888_a_(matrix4f1, scale, -180.0f, scale).func_225583_a_(1.0f, 0.0f).func_181675_d();
                        bufferbuilder.func_227888_a_(matrix4f1, scale, -180.0f, -scale).func_225583_a_(1.0f, 1.0f).func_181675_d();
                        bufferbuilder.func_227888_a_(matrix4f1, -scale, -180.0f, -scale).func_225583_a_(0.0f, 1.0f).func_181675_d();
                        bufferbuilder.func_178977_d();
                        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
                        RenderSystem.depthMask((boolean)false);
                        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(world.func_242415_f(partialTicks) * 360.0f));
                        matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
                        float f12 = 70.0f;
                        mc.func_110434_K().func_110577_a(SUN_TEXTURE);
                        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                        bufferbuilder.func_227888_a_(matrix4f1, -f12, 200.0f, -f12).func_225583_a_(0.0f, 0.0f).func_181675_d();
                        bufferbuilder.func_227888_a_(matrix4f1, f12, 200.0f, -f12).func_225583_a_(1.0f, 0.0f).func_181675_d();
                        bufferbuilder.func_227888_a_(matrix4f1, f12, 200.0f, f12).func_225583_a_(1.0f, 1.0f).func_181675_d();
                        bufferbuilder.func_227888_a_(matrix4f1, -f12, 200.0f, f12).func_225583_a_(0.0f, 1.0f).func_181675_d();
                        bufferbuilder.func_178977_d();
                        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
                        RenderSystem.disableTexture();
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        starVBO.func_177359_a();
                        mc.field_71438_f.field_175014_r.func_227892_a_(0L);
                        starVBO.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
                        VertexBuffer.func_177361_b();
                        mc.field_71438_f.field_175014_r.func_227895_d_();
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        RenderSystem.disableBlend();
                        RenderSystem.enableAlphaTest();
                        RenderSystem.enableFog();
                        matrixStack.func_227865_b_();
                        RenderSystem.disableTexture();
                        RenderSystem.color3f((float)0.0f, (float)0.0f, (float)0.0f);
                        if (world.func_239132_a_().func_239216_b_()) {
                            RenderSystem.color3f((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f));
                        } else {
                            RenderSystem.color3f((float)f, (float)f1, (float)f2);
                        }
                        RenderSystem.enableTexture();
                        RenderSystem.depthMask((boolean)true);
                        RenderSystem.disableFog();
                    }
                };
            }

            private void generateStars() {
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                if (starVBO != null) {
                    starVBO.close();
                }
                starVBO = new VertexBuffer(skyVertexFormat);
                this.renderStars(bufferbuilder);
                bufferbuilder.func_178977_d();
                starVBO.func_227875_a_(bufferbuilder);
            }

            private void renderStars(BufferBuilder bufferBuilderIn) {
                Random random = new Random(10842L);
                bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                int stars = 0;
                stars = Minecraft.func_71410_x().field_71474_y.field_238330_f_ == GraphicsFanciness.FANCY || Minecraft.func_71410_x().field_71474_y.field_238330_f_ == GraphicsFanciness.FABULOUS ? 13000 : 6000;
                for (int i = 0; i < stars; ++i) {
                    double d0 = random.nextFloat() * 2.0f - 1.0f;
                    double d1 = random.nextFloat() * 2.0f - 1.0f;
                    double d2 = random.nextFloat() * 2.0f - 1.0f;
                    double d3 = 0.15f + random.nextFloat() * 0.1f;
                    double d4 = d0 * d0 + d1 * d1 + d2 * d2;
                    if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
                    d4 = 1.0 / Math.sqrt(d4);
                    double d5 = (d0 *= d4) * 200.0;
                    double d6 = (d1 *= d4) * 200.0;
                    double d7 = (d2 *= d4) * 200.0;
                    double d8 = Math.atan2(d0, d2);
                    double d9 = Math.sin(d8);
                    double d10 = Math.cos(d8);
                    double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
                    double d12 = Math.sin(d11);
                    double d13 = Math.cos(d11);
                    double d14 = random.nextDouble() * Math.PI * 2.0;
                    double d15 = Math.sin(d14);
                    double d16 = Math.cos(d14);
                    for (int j = 0; j < 4; ++j) {
                        double d17 = 0.0;
                        double d18 = (double)((j & 2) - 1) * d3;
                        double d19 = (double)((j + 1 & 2) - 1) * d3;
                        double d20 = 0.0;
                        double d21 = d18 * d16 - d19 * d15;
                        double d22 = d19 * d16 + d18 * d15;
                        double d23 = d21 * d12 + 0.0 * d13;
                        double d24 = 0.0 * d12 - d21 * d13;
                        double d25 = d24 * d9 - d22 * d10;
                        double d26 = d22 * d9 + d24 * d10;
                        bufferBuilderIn.func_225582_a_(d5 + d25, d6 + d23, d7 + d26).func_181675_d();
                    }
                }
            }
        });
    }

    static {
        skyVertexFormat = DefaultVertexFormats.field_181705_e;
        DIM_RENDER_INFO = new ResourceLocation("boss_tools", "venus_orbit");
        VENUS_TEXTURE = new ResourceLocation("boss_tools", "textures/sky/venus.png");
        SUN_TEXTURE = new ResourceLocation("boss_tools", "textures/sky/no_a_sun.png");
    }
}

