/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel;

import com.legacy.structure_gel.StructureGelMod;
import com.legacy.structure_gel.biome_dictionary.BiomeDictionary;
import com.legacy.structure_gel.biome_dictionary.BiomeType;
import com.legacy.structure_gel.blocks.AxisStructureGelBlock;
import com.legacy.structure_gel.blocks.IStructureGel;
import com.legacy.structure_gel.blocks.StructureGelBlock;
import com.legacy.structure_gel.items.StructureGelItem;
import com.legacy.structure_gel.util.RegistryHelper;
import com.legacy.structure_gel.worldgen.jigsaw.GelJigsawPiece;
import com.legacy.structure_gel.worldgen.jigsaw.GelStructurePiece;
import com.legacy.structure_gel.worldgen.processors.RandomBlockSwapProcessor;
import com.legacy.structure_gel.worldgen.processors.RandomStateSwapProcessor;
import com.legacy.structure_gel.worldgen.processors.RandomTagSwapProcessor;
import com.legacy.structure_gel.worldgen.processors.RemoveGelStructureProcessor;
import com.mojang.serialization.Codec;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class SGRegistry {
    public static void registerBiomeDictionary(RegistryEvent.Register<BiomeType> event) {
        BiomeDictionary.init();
    }

    public static class StructurePieceTypes {
        public static IStructurePieceType GEL_JIGSAW;
    }

    public static class JigsawDeserializers {
        public static IJigsawDeserializer<GelJigsawPiece> GEL_SINGLE_POOL_ELEMENT;

        protected static <P extends JigsawPiece> IJigsawDeserializer<P> register(String key, Codec<P> codec) {
            return (IJigsawDeserializer)Registry.func_218322_a((Registry)Registry.field_218365_F, (ResourceLocation)StructureGelMod.locate(key), () -> codec);
        }
    }

    public static class Processors {
        public static IStructureProcessorType<RemoveGelStructureProcessor> REMOVE_FILLER;
        public static IStructureProcessorType<RandomBlockSwapProcessor> REPLACE_BLOCK;
        public static IStructureProcessorType<RandomTagSwapProcessor> REPLACE_TAG;
        public static IStructureProcessorType<RandomStateSwapProcessor> REPLACE_STATE;

        protected static <P extends StructureProcessor> IStructureProcessorType<P> register(String key, Codec<P> codec) {
            return (IStructureProcessorType)Registry.func_218322_a((Registry)Registry.field_218364_E, (ResourceLocation)StructureGelMod.locate(key), () -> codec);
        }
    }

    public static class StructureRegistry {
        public static void onRegistry(RegistryEvent.Register<Structure<?>> event) {
            StructureRegistry.registerProcessors();
            StructureRegistry.registerDeserializers();
            StructureRegistry.registerStructurePieces();
        }

        private static void registerProcessors() {
            Processors.REMOVE_FILLER = Processors.register("remove_filler", RemoveGelStructureProcessor.CODEC);
            Processors.REPLACE_BLOCK = Processors.register("replace_block", RandomBlockSwapProcessor.CODEC);
            Processors.REPLACE_TAG = Processors.register("replace_tag", RandomTagSwapProcessor.CODEC);
            Processors.REPLACE_STATE = Processors.register("replace_state", RandomStateSwapProcessor.CODEC);
        }

        private static void registerDeserializers() {
            JigsawDeserializers.GEL_SINGLE_POOL_ELEMENT = JigsawDeserializers.register("gel_single_pool_element", GelJigsawPiece.CODEC);
        }

        private static void registerStructurePieces() {
            StructurePieceTypes.GEL_JIGSAW = RegistryHelper.registerStructurePiece(StructureGelMod.locate("gel_jigsaw"), GelStructurePiece::new);
        }
    }

    public static class GelItems {
        public static void onRegistry(RegistryEvent.Register<Item> event) {
            GelBlocks.BLOCKS.forEach(b -> RegistryHelper.register(event.getRegistry(), b.getRegistryName(), new StructureGelItem((StructureGelBlock)b)));
        }
    }

    public static class GelBlocks {
        public static Set<Block> BLOCKS = new LinkedHashSet<Block>();
        public static StructureGelBlock RED_GEL;
        public static StructureGelBlock BLUE_GEL;
        public static StructureGelBlock GREEN_GEL;
        public static StructureGelBlock CYAN_GEL;
        public static StructureGelBlock ORANGE_GEL;
        public static StructureGelBlock YELLOW_GEL;

        public static void onRegistry(RegistryEvent.Register<Block> event) {
            IForgeRegistry registry = event.getRegistry();
            RED_GEL = GelBlocks.registerBlock((IForgeRegistry<Block>)registry, "red_gel", new StructureGelBlock(new IStructureGel.IBehavior[0]));
            BLUE_GEL = GelBlocks.registerBlock((IForgeRegistry<Block>)registry, "blue_gel", new StructureGelBlock(IStructureGel.Behavior.PHOTOSENSITIVE));
            GREEN_GEL = GelBlocks.registerBlock((IForgeRegistry<Block>)registry, "green_gel", new StructureGelBlock(IStructureGel.Behavior.DIAGONAL_SPREAD));
            CYAN_GEL = GelBlocks.registerBlock((IForgeRegistry<Block>)registry, "cyan_gel", new StructureGelBlock(IStructureGel.Behavior.PHOTOSENSITIVE, IStructureGel.Behavior.DIAGONAL_SPREAD));
            ORANGE_GEL = GelBlocks.registerBlock((IForgeRegistry<Block>)registry, "orange_gel", new StructureGelBlock(IStructureGel.Behavior.DYNAMIC_SPREAD_DIST));
            YELLOW_GEL = GelBlocks.registerBlock((IForgeRegistry<Block>)registry, "yellow_gel", new AxisStructureGelBlock(IStructureGel.Behavior.AXIS_SPREAD));
        }

        private static <T extends Block> T registerBlock(IForgeRegistry<Block> registry, String key, T object) {
            BLOCKS.add(object);
            return RegistryHelper.register(registry, StructureGelMod.locate(key), object);
        }
    }
}

