/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.worldgen.jigsaw;

import com.legacy.structure_gel.util.Internal;
import com.legacy.structure_gel.worldgen.jigsaw.GelStructurePiece;
import com.legacy.structure_gel.worldgen.structure.GelStructure;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;

public abstract class GelJigsawStructure
extends GelStructure<VillageConfig> {
    public final int deltaY;
    public final boolean flag1;
    public final boolean placesOnSurface;

    public GelJigsawStructure(Codec<VillageConfig> codec, int deltaY, boolean flag1, boolean placesOnSurface) {
        super(codec);
        this.deltaY = deltaY;
        this.flag1 = flag1;
        this.placesOnSurface = placesOnSurface;
    }

    public JigsawManager.IPieceFactory getPieceType() {
        return GelStructurePiece::new;
    }

    @Internal
    public AbstractVillagePiece getPiece(TemplateManager templateManager, JigsawPiece jigsawPiece, BlockPos pos, int groundLevelDelta, Rotation rotation, MutableBoundingBox bounds) {
        return this.getPieceType().create(templateManager, jigsawPiece, pos, groundLevelDelta, rotation, bounds);
    }

    public void handleStartFactory(Start start, DynamicRegistries dynamicRegistries, ChunkGenerator chunkGen, TemplateManager templateManager, int chunkX, int chunkZ, Biome biome, VillageConfig config) {
        BlockPos blockpos = new BlockPos(chunkX * 16 + 8, start.jigsawStructure.deltaY, chunkZ * 16 + 8);
        JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistries, (VillageConfig)config, start.jigsawStructure::getPiece, (ChunkGenerator)chunkGen, (TemplateManager)templateManager, (BlockPos)blockpos, start.func_186161_c(), (Random)start.getRand(), (boolean)start.jigsawStructure.flag1, (boolean)start.jigsawStructure.placesOnSurface);
        start.func_202500_a();
    }

    @Internal
    public Structure.IStartFactory<VillageConfig> func_214557_a() {
        return (structure, chunkX, chunkZ, bounds, references, seed) -> new Start(this, chunkX, chunkZ, bounds, references, seed);
    }

    public static class Start
    extends StructureStart<VillageConfig> {
        public final GelJigsawStructure jigsawStructure;

        public Start(GelJigsawStructure jigsawStructure, int chunkX, int chunkZ, MutableBoundingBox bounds, int references, long seed) {
            super((Structure)jigsawStructure, chunkX, chunkZ, bounds, references, seed);
            this.jigsawStructure = jigsawStructure;
        }

        public void generatePieces(DynamicRegistries dynamicRegistries, ChunkGenerator chunkGen, TemplateManager templateManager, int chunkX, int chunkZ, Biome biome, VillageConfig config) {
            this.jigsawStructure.handleStartFactory(this, dynamicRegistries, chunkGen, templateManager, chunkX, chunkZ, biome, config);
        }

        public List<StructurePiece> func_186161_c() {
            return this.field_75075_a;
        }

        public Random getRand() {
            return this.field_214631_d;
        }

        public MutableBoundingBox getBounds() {
            return this.field_75074_b;
        }

        public void func_202500_a() {
            super.func_202500_a();
        }

        public BlockPos func_204294_a() {
            return new BlockPos((this.func_143019_e() << 4) + 8, 0, (this.func_143018_f() << 4) + 8);
        }
    }
}

