/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.block;

import com.mrcrayfish.vehicle.block.BlockRotatedObject;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.init.ModSounds;
import com.mrcrayfish.vehicle.tileentity.BoostTileEntity;
import com.mrcrayfish.vehicle.util.Bounds;
import com.mrcrayfish.vehicle.util.StateHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockSteepBoostRamp
extends BlockRotatedObject {
    public static final BooleanProperty LEFT = BooleanProperty.func_177716_a((String)"left");
    public static final BooleanProperty RIGHT = BooleanProperty.func_177716_a((String)"right");
    private static final AxisAlignedBB COLLISION_BASE = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    private static final AxisAlignedBB[] COLLISION_ONE = new Bounds(1, 1, 0, 16, 2, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_TWO = new Bounds(2, 2, 0, 16, 3, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_THREE = new Bounds(3, 3, 0, 16, 4, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_FOUR = new Bounds(4, 4, 0, 16, 5, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_FIVE = new Bounds(5, 5, 0, 16, 6, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_SIX = new Bounds(6, 6, 0, 16, 7, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_SEVEN = new Bounds(7, 7, 0, 16, 8, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_EIGHT = new Bounds(8, 9, 0, 16, 9, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_NINE = new Bounds(9, 10, 0, 16, 10, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_TEN = new Bounds(10, 11, 0, 16, 11, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_ELEVEN = new Bounds(11, 12, 0, 16, 12, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_TWELVE = new Bounds(12, 13, 0, 16, 13, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_THIRTEEN = new Bounds(13, 14, 0, 16, 14, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_FOURTEEN = new Bounds(14, 15, 0, 16, 15, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_FIFTEEN = new Bounds(15, 15, 0, 16, 16, 16).getRotatedBounds();

    public BlockSteepBoostRamp() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(1.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader reader, List<ITextComponent> list, ITooltipFlag advanced) {
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        Direction facing;
        if (entity instanceof PoweredVehicleEntity && entity.func_184179_bs() != null && (facing = (Direction)state.func_177229_b((Property)DIRECTION)) == entity.func_174811_aO()) {
            PoweredVehicleEntity poweredVehicle;
            float speedMultiplier = 0.0f;
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof BoostTileEntity) {
                speedMultiplier = ((BoostTileEntity)tileEntity).getSpeedMultiplier();
            }
            if (!(poweredVehicle = (PoweredVehicleEntity)entity).isBoosting()) {
                world.func_184133_a(null, pos, (SoundEvent)ModSounds.BOOST_PAD.get(), SoundCategory.BLOCKS, 2.0f, 0.5f);
            }
            poweredVehicle.setBoosting(true);
            poweredVehicle.setLaunching(3);
            poweredVehicle.currentSpeed = poweredVehicle.getActualMaxSpeed();
            poweredVehicle.speedMultiplier = speedMultiplier;
            Vector3d motion = poweredVehicle.func_213322_ci();
            poweredVehicle.func_213317_d(new Vector3d(motion.field_72450_a, (double)(poweredVehicle.currentSpeed / 20.0f) + 0.1, motion.field_72449_c));
        }
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighbourState, IWorld world, BlockPos pos, BlockPos neighbourPos) {
        return this.getRampState(state, world, pos, (Direction)state.func_177229_b((Property)DIRECTION));
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getRampState(this.func_176223_P(), (IWorld)context.func_195991_k(), context.func_195995_a(), context.func_195992_f());
    }

    private BlockState getRampState(BlockState state, IWorld world, BlockPos pos, Direction facing) {
        state = (BlockState)state.func_206870_a((Property)LEFT, (Comparable)Boolean.valueOf(false));
        state = (BlockState)state.func_206870_a((Property)RIGHT, (Comparable)Boolean.valueOf(false));
        if (StateHelper.getBlock((IWorldReader)world, pos, facing, StateHelper.RelativeDirection.LEFT) == this && StateHelper.getRotation((IWorldReader)world, pos, facing, StateHelper.RelativeDirection.LEFT) == StateHelper.RelativeDirection.DOWN) {
            state = (BlockState)state.func_206870_a((Property)RIGHT, (Comparable)Boolean.valueOf(true));
        }
        if (StateHelper.getBlock((IWorldReader)world, pos, facing, StateHelper.RelativeDirection.RIGHT) == this && StateHelper.getRotation((IWorldReader)world, pos, facing, StateHelper.RelativeDirection.RIGHT) == StateHelper.RelativeDirection.DOWN) {
            state = (BlockState)state.func_206870_a((Property)LEFT, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{LEFT});
        builder.func_206894_a(new Property[]{RIGHT});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new BoostTileEntity(1.0f);
    }
}

