/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.obfuscate.client.event.PlayerModelEvent;
import com.mrcrayfish.obfuscate.client.event.RenderItemEvent;
import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.client.EntityRayTracer;
import com.mrcrayfish.vehicle.client.RayTraceFunction;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.client.render.Axis;
import com.mrcrayfish.vehicle.client.render.VehicleRenderRegistry;
import com.mrcrayfish.vehicle.common.Seat;
import com.mrcrayfish.vehicle.entity.LandVehicleEntity;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.init.ModDataKeys;
import com.mrcrayfish.vehicle.init.ModSounds;
import com.mrcrayfish.vehicle.item.SprayCanItem;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageCycleSeats;
import com.mrcrayfish.vehicle.network.message.MessageHitchTrailer;
import com.mrcrayfish.vehicle.proxy.ClientProxy;
import com.mrcrayfish.vehicle.util.RenderUtil;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientEvents {
    private int lastSlot = -1;
    private PointOfView originalPointOfView = null;
    private double fuelingHandOffset;
    private int tickCounter;
    private boolean fueling;
    private double offsetPrev;
    private double offsetPrevPrev;
    private boolean shouldRenderNozzle;

    @SubscribeEvent
    public void onEntityMount(EntityMountEvent event) {
        if (((Boolean)Config.CLIENT.autoPerspective.get()).booleanValue() && event.getWorldObj().field_72995_K && event.getEntityMounting().equals((Object)Minecraft.func_71410_x().field_71439_g)) {
            if (event.isMounting()) {
                Entity entity = event.getEntityBeingMounted();
                if (entity instanceof VehicleEntity) {
                    this.originalPointOfView = Minecraft.func_71410_x().field_71474_y.func_243230_g();
                    Minecraft.func_71410_x().field_71474_y.func_243229_a(PointOfView.THIRD_PERSON_BACK);
                }
            } else if (this.originalPointOfView != null) {
                Minecraft.func_71410_x().field_71474_y.func_243229_a(this.originalPointOfView);
                this.originalPointOfView = null;
            }
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        Entity entity;
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (((Boolean)Config.CLIENT.autoPerspective.get()).booleanValue() && (entity = Minecraft.func_71410_x().field_71439_g.func_184187_bx()) instanceof VehicleEntity && Minecraft.func_71410_x().field_71474_y.field_151457_aa.func_151470_d()) {
            this.originalPointOfView = null;
        }
        if (ClientProxy.KEY_CYCLE_SEATS.func_151468_f() && event.getAction() == 1 && Minecraft.func_71410_x().field_71439_g.func_184187_bx() instanceof VehicleEntity) {
            PacketHandler.instance.sendToServer((Object)new MessageCycleSeats());
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        Entity entity;
        ClientPlayerEntity player;
        Minecraft mc;
        if (((Boolean)Config.CLIENT.enabledSpeedometer.get()).booleanValue() && event.phase == TickEvent.Phase.END && (mc = Minecraft.func_71410_x()).func_195544_aj() && !mc.field_71474_y.field_74319_N && (player = mc.field_71439_g) != null && (entity = player.func_184187_bx()) instanceof PoweredVehicleEntity) {
            MatrixStack matrixStack = new MatrixStack();
            PoweredVehicleEntity vehicle = (PoweredVehicleEntity)entity;
            String speed = new DecimalFormat("0.0").format(vehicle.getKilometersPreHour());
            mc.field_71466_p.func_238405_a_(matrixStack, TextFormatting.BOLD + "BPS: " + TextFormatting.YELLOW + speed, 10.0f, 10.0f, Color.WHITE.getRGB());
            if (vehicle.requiresFuel()) {
                DecimalFormat format = new DecimalFormat("0.0");
                String fuel = format.format(vehicle.getCurrentFuel()) + "/" + format.format(vehicle.getFuelCapacity());
                mc.field_71466_p.func_238405_a_(matrixStack, TextFormatting.BOLD + "Fuel: " + TextFormatting.YELLOW + fuel, 10.0f, 25.0f, Color.WHITE.getRGB());
            }
        }
    }

    @SubscribeEvent
    public void onFovUpdate(FOVUpdateEvent event) {
        Entity ridingEntity = Minecraft.func_71410_x().field_71439_g.func_184187_bx();
        if (ridingEntity instanceof VehicleEntity) {
            event.setNewfov(1.0f);
        }
    }

    @SubscribeEvent
    public void onPreRender(PlayerModelEvent.Render.Pre event) {
        PlayerEntity player = event.getPlayer();
        Entity ridingEntity = player.func_184187_bx();
        if (ridingEntity instanceof VehicleEntity) {
            int index;
            LandVehicleEntity landVehicle;
            VehicleEntity vehicle = (VehicleEntity)ridingEntity;
            AbstractRenderVehicle<?> render = VehicleRenderRegistry.getRender((EntityType<? extends VehicleEntity>)vehicle.func_200600_R());
            if (render != null) {
                render.applyPlayerRender(vehicle, player, event.getPartialTicks(), event.getMatrixStack(), event.getBuilder());
            }
            if (vehicle instanceof LandVehicleEntity && (landVehicle = (LandVehicleEntity)vehicle).canWheelie() && (index = vehicle.getSeatTracker().getSeatIndex(player.func_110124_au())) != -1) {
                VehicleProperties properties = landVehicle.getProperties();
                if (properties.getRearAxelVec() == null) {
                    return;
                }
                Seat seat = properties.getSeats().get(index);
                Vector3d seatVec = seat.getPosition().func_72441_c(0.0, (double)(properties.getAxleOffset() + properties.getWheelOffset()), 0.0).func_186678_a(properties.getBodyPosition().getScale()).func_186678_a(0.0625);
                double vehicleScale = properties.getBodyPosition().getScale();
                double playerScale = 1.0666666666666667;
                double offsetX = -(seatVec.field_72450_a * playerScale);
                double offsetY = (seatVec.field_72448_b + player.func_70033_W()) * playerScale + 1.5 - (double)properties.getWheelOffset() * 0.0625 * vehicleScale;
                double offsetZ = seatVec.field_72449_c * playerScale - properties.getRearAxelVec().field_72449_c * 0.0625 * vehicleScale;
                MatrixStack matrixStack = event.getMatrixStack();
                matrixStack.func_227861_a_(offsetX, offsetY, offsetZ);
                float wheelieProgress = MathHelper.func_219799_g((float)event.getPartialTicks(), (float)landVehicle.prevWheelieCount, (float)landVehicle.wheelieCount) / 4.0f;
                wheelieProgress = (float)(1.0 - Math.pow(1.0 - (double)wheelieProgress, 2.0));
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-30.0f * wheelieProgress));
                matrixStack.func_227861_a_(-offsetX, -offsetY, -offsetZ);
            }
        }
    }

    @SubscribeEvent
    public void onSetupAngles(PlayerModelEvent.SetupAngles.Post event) {
        VehicleEntity vehicle;
        AbstractRenderVehicle<?> render;
        PlayerEntity player = event.getPlayer();
        if (player.equals((Object)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON) {
            return;
        }
        Entity ridingEntity = player.func_184187_bx();
        PlayerModel model = event.getModelPlayer();
        if (((Optional)SyncedPlayerData.instance().get(player, ModDataKeys.GAS_PUMP)).isPresent()) {
            boolean rightHanded;
            boolean bl = rightHanded = player.func_184591_cq() == HandSide.RIGHT;
            if (rightHanded) {
                model.field_178723_h.field_78795_f = (float)Math.toRadians(-20.0);
                model.field_178723_h.field_78796_g = (float)Math.toRadians(0.0);
                model.field_178723_h.field_78808_h = (float)Math.toRadians(0.0);
            } else {
                model.field_178724_i.field_78795_f = (float)Math.toRadians(-20.0);
                model.field_178724_i.field_78796_g = (float)Math.toRadians(0.0);
                model.field_178724_i.field_78808_h = (float)Math.toRadians(0.0);
            }
            return;
        }
        if (player.func_184187_bx() != null) {
            ItemStack leftItem;
            boolean rightHanded = player.func_184591_cq() == HandSide.RIGHT;
            ItemStack rightItem = rightHanded ? player.func_184614_ca() : player.func_184592_cb();
            ItemStack itemStack = leftItem = rightHanded ? player.func_184592_cb() : player.func_184614_ca();
            if (!rightItem.func_190926_b() && rightItem.func_77973_b() instanceof SprayCanItem) {
                ClientEvents.copyModelAngles(model.field_78116_c, model.field_178723_h);
                model.field_178723_h.field_78795_f = (float)((double)model.field_178723_h.field_78795_f + Math.toRadians(-80.0));
            }
            if (!leftItem.func_190926_b() && leftItem.func_77973_b() instanceof SprayCanItem) {
                model.field_178724_i.func_217177_a(model.field_78116_c);
                model.field_178724_i.field_78795_f = (float)((double)model.field_178724_i.field_78795_f + Math.toRadians(-80.0));
            }
        }
        if (ridingEntity != null && ridingEntity instanceof VehicleEntity && (render = VehicleRenderRegistry.getRender((EntityType<? extends VehicleEntity>)(vehicle = (VehicleEntity)ridingEntity).func_200600_R())) != null) {
            render.applyPlayerModel(vehicle, player, (PlayerModel<AbstractClientPlayerEntity>)model, event.getPartialTicks());
            return;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void copyModelAngles(ModelRenderer source, ModelRenderer dest) {
        dest.field_78795_f = source.field_78795_f;
        dest.field_78796_g = source.field_78796_g;
        dest.field_78808_h = source.field_78808_h;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (event.phase == TickEvent.Phase.END && player != null) {
            int slot;
            if (((Boolean)Config.CLIENT.reloadVehiclePropertiesEachTick.get()).booleanValue()) {
                VehicleProperties.register();
            }
            if (this.lastSlot != (slot = player.field_71071_by.field_70461_c)) {
                this.lastSlot = slot;
                if (!player.field_71071_by.func_70448_g().func_190926_b() && player.field_71071_by.func_70448_g().func_77973_b() instanceof SprayCanItem) {
                    SprayCanItem sprayCan = (SprayCanItem)player.field_71071_by.func_70448_g().func_77973_b();
                    float pitch = 0.85f + 0.15f * sprayCan.getRemainingSprays(player.field_71071_by.func_70448_g());
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)((SoundEvent)ModSounds.SPRAY_CAN_SHAKE.get()), (float)pitch, (float)0.75f));
                }
            }
            if (player.func_184187_bx() == null) {
                this.originalPointOfView = null;
            }
            ++this.tickCounter;
            EntityRayTracer.RayTraceResultRotated result = EntityRayTracer.instance().getContinuousInteraction();
            if (result != null && result.equalsContinuousInteraction(RayTraceFunction.FUNCTION_FUELING)) {
                if (!this.fueling) {
                    this.tickCounter = 0;
                    this.fueling = true;
                }
            } else {
                this.fueling = false;
            }
        }
    }

    @SubscribeEvent
    public void onRenderHand(RenderHandEvent event) {
        MatrixStack matrixStack = event.getMatrixStack();
        if (event.getHand() == Hand.OFF_HAND && this.fuelingHandOffset > -1.0) {
            matrixStack.func_227863_a_(Axis.POSITIVE_X.func_229187_a_(25.0f));
            matrixStack.func_227861_a_(0.0, -0.35 - this.fuelingHandOffset, 0.2);
        }
        if (event.getItemStack().func_190926_b() || event.getItemStack().func_77973_b() instanceof SprayCanItem) {
            // empty if block
        }
        this.fuelingHandOffset = -1.0;
        EntityRayTracer.RayTraceResultRotated result = EntityRayTracer.instance().getContinuousInteraction();
        if (result != null && result.equalsContinuousInteraction(RayTraceFunction.FUNCTION_FUELING) && event.getHand() == EntityRayTracer.instance().getContinuousInteractionHand()) {
            double offset = Math.sin((double)((float)this.tickCounter + Minecraft.func_71410_x().func_184121_ak()) * 0.4) * 0.01;
            if (this.offsetPrev > this.offsetPrevPrev && this.offsetPrev > offset) {
                Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.LIQUID_GLUG.get(), 0.3f, 1.0f);
            }
            this.offsetPrevPrev = this.offsetPrev;
            this.offsetPrev = offset;
            matrixStack.func_227861_a_(0.0, 0.35 + offset, -0.2);
            matrixStack.func_227863_a_(Axis.POSITIVE_X.func_229187_a_(-25.0f));
            if (event.getHand() == Hand.MAIN_HAND) {
                this.fuelingHandOffset = offset;
            }
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (((Optional)SyncedPlayerData.instance().get((PlayerEntity)player, ModDataKeys.GAS_PUMP)).isPresent()) {
            if (event.getSwingProgress() > 0.0f) {
                this.shouldRenderNozzle = true;
            }
            if (event.getHand() == Hand.MAIN_HAND && this.shouldRenderNozzle) {
                if (event.getSwingProgress() > 0.0f && (double)event.getSwingProgress() <= 0.25) {
                    return;
                }
                matrixStack.func_227860_a_();
                boolean mainHand = event.getHand() == Hand.MAIN_HAND;
                HandSide handSide = mainHand ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
                int handOffset = handSide == HandSide.RIGHT ? 1 : -1;
                matrixStack.func_227861_a_((double)handOffset * 0.65, -0.27, -0.72);
                matrixStack.func_227863_a_(Axis.POSITIVE_X.func_229187_a_(45.0f));
                IRenderTypeBuffer.Impl renderTypeBuffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
                int light = Minecraft.func_71410_x().func_175598_ae().func_229085_a_((Entity)player, event.getPartialTicks());
                RenderUtil.renderColoredModel(SpecialModels.NOZZLE.getModel(), ItemCameraTransforms.TransformType.NONE, false, matrixStack, (IRenderTypeBuffer)renderTypeBuffer, -1, light, OverlayTexture.field_229196_a_);
                matrixStack.func_227865_b_();
                event.setCanceled(true);
            }
        } else {
            this.shouldRenderNozzle = false;
        }
    }

    @SubscribeEvent
    public void onRenderThirdPerson(RenderItemEvent.Held.Pre event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof PlayerEntity && ((Optional)SyncedPlayerData.instance().get((PlayerEntity)entity, ModDataKeys.GAS_PUMP)).isPresent()) {
            event.setCanceled(true);
            return;
        }
        if (event.getItem().func_190926_b() || event.getItem().func_77973_b() instanceof SprayCanItem) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onModelRenderPost(PlayerModelEvent.Render.Post event) {
        MatrixStack matrixStack = event.getMatrixStack();
        PlayerEntity entity = event.getPlayer();
        if (((Optional)SyncedPlayerData.instance().get(entity, ModDataKeys.GAS_PUMP)).isPresent()) {
            matrixStack.func_227860_a_();
            if (event.getModelPlayer().field_217114_e) {
                matrixStack.func_227861_a_(0.0, 0.75, 0.0);
                matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            }
            matrixStack.func_227860_a_();
            if (entity.func_213453_ef()) {
                matrixStack.func_227861_a_(0.0, 0.2, 0.0);
            }
            event.getModelPlayer().func_225599_a_(HandSide.RIGHT, event.getMatrixStack());
            matrixStack.func_227863_a_(Axis.POSITIVE_X.func_229187_a_(180.0f));
            matrixStack.func_227863_a_(Axis.POSITIVE_Y.func_229187_a_(180.0f));
            boolean leftHanded = entity.func_184591_cq() == HandSide.LEFT;
            matrixStack.func_227861_a_((double)(leftHanded ? -1 : 1) / 16.0, 0.125, -0.625);
            matrixStack.func_227861_a_(0.0, -0.5625, 0.359375);
            IRenderTypeBuffer.Impl renderTypeBuffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            RenderUtil.renderColoredModel(SpecialModels.NOZZLE.getModel(), ItemCameraTransforms.TransformType.NONE, false, matrixStack, (IRenderTypeBuffer)renderTypeBuffer, -1, 0xF000F0, OverlayTexture.field_229196_a_);
            matrixStack.func_227865_b_();
            matrixStack.func_227865_b_();
        }
    }

    @SubscribeEvent
    public void renderCustomBlockHighlights(DrawHighlightEvent.HighlightBlock event) {
    }

    private void boxRenderGlStart() {
    }

    private void boxRenderGlEnd() {
    }

    @SubscribeEvent
    public void setLiquidFogDensity(EntityViewRenderEvent.FogDensity event) {
        event.getInfo().getBlockAtCamera();
    }

    @SubscribeEvent
    public void onJump(InputEvent.KeyInputEvent event) {
        if (event.getAction() == 1 && event.getKey() == Minecraft.func_71410_x().field_71474_y.field_151444_V.getKey().func_197937_c()) {
            VehicleEntity vehicle;
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (Minecraft.func_71410_x().field_71462_r == null && player.func_184187_bx() instanceof VehicleEntity && (vehicle = (VehicleEntity)player.func_184187_bx()).canTowTrailer()) {
                PacketHandler.instance.sendToServer((Object)new MessageHitchTrailer(vehicle.getTrailer() == null));
            }
        }
    }
}

