/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render;

import com.mrcrayfish.vehicle.entity.LandVehicleEntity;

public class Wheel {
    private float offsetX;
    private float offsetY;
    private float offsetZ;
    private float width;
    private float scaleX;
    private float scaleY;
    private float scaleZ;
    private Side side;
    private Position position;
    private boolean particles;
    private boolean render;

    public Wheel(Side side, Position position, float width, float scaleX, float scaleY, float scaleZ, float offsetX, float offsetY, float offsetZ, boolean particles, boolean render) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.width = width;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
        this.side = side;
        this.position = position;
        this.particles = particles;
        this.render = render;
    }

    public float getWheelRotation(LandVehicleEntity vehicle, float partialTicks) {
        if (this.position == Position.REAR) {
            return vehicle.prevRearWheelRotation + (vehicle.rearWheelRotation - vehicle.prevRearWheelRotation) * partialTicks;
        }
        return vehicle.prevFrontWheelRotation + (vehicle.frontWheelRotation - vehicle.prevFrontWheelRotation) * partialTicks;
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public float getOffsetZ() {
        return this.offsetZ;
    }

    public float getWidth() {
        return this.width;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public float getScaleZ() {
        return this.scaleZ;
    }

    public Side getSide() {
        return this.side;
    }

    public Position getPosition() {
        return this.position;
    }

    public boolean shouldSpawnParticles() {
        return this.particles;
    }

    public boolean shouldRender() {
        return this.render;
    }

    public static enum Position {
        FRONT,
        REAR,
        NONE;

    }

    public static enum Side {
        LEFT(-1),
        RIGHT(1),
        NONE(0);

        int offset;

        private Side(int offset) {
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

