/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.vehicle;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.vehicle.client.ISpecialModel;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.client.render.Axis;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.vehicle.MiniBusEntity;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerEntity;

public class RenderMiniBus
extends AbstractRenderVehicle<MiniBusEntity> {
    @Override
    public ISpecialModel getTowBarModel() {
        return SpecialModels.BIG_TOW_BAR;
    }

    @Override
    public void render(MiniBusEntity entity, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, float partialTicks, int light) {
        this.renderDamagedPart((VehicleEntity)entity, SpecialModels.MINI_BUS_BODY.getModel(), matrixStack, renderTypeBuffer, light);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(-0.2825, 0.225, 1.0625);
        matrixStack.func_227863_a_(Axis.POSITIVE_X.func_229187_a_(-67.5f));
        matrixStack.func_227861_a_(0.0, -0.02, 0.0);
        matrixStack.func_227862_a_(0.75f, 0.75f, 0.75f);
        float wheelAngle = entity.prevRenderWheelAngle + (entity.renderWheelAngle - entity.prevRenderWheelAngle) * partialTicks;
        float wheelAngleNormal = wheelAngle / 45.0f;
        float turnRotation = wheelAngleNormal * 25.0f;
        matrixStack.func_227863_a_(Axis.POSITIVE_Y.func_229187_a_(turnRotation));
        RenderUtil.renderColoredModel(SpecialModels.GO_KART_STEERING_WHEEL.getModel(), ItemCameraTransforms.TransformType.NONE, false, matrixStack, renderTypeBuffer, -1, light, OverlayTexture.field_229196_a_);
        matrixStack.func_227865_b_();
    }

    @Override
    public void applyPlayerModel(MiniBusEntity entity, PlayerEntity player, PlayerModel<AbstractClientPlayerEntity> model, float partialTicks) {
        if (entity.func_184179_bs() == player) {
            float wheelAngle = entity.prevRenderWheelAngle + (entity.renderWheelAngle - entity.prevRenderWheelAngle) * partialTicks;
            float wheelAngleNormal = wheelAngle / 45.0f;
            float turnRotation = wheelAngleNormal * 6.0f;
            model.field_178723_h.field_78795_f = (float)Math.toRadians(-65.0f - turnRotation);
            model.field_178723_h.field_78796_g = (float)Math.toRadians(-7.0);
            model.field_178724_i.field_78795_f = (float)Math.toRadians(-65.0f + turnRotation);
            model.field_178724_i.field_78796_g = (float)Math.toRadians(7.0);
        }
    }
}

