/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.vehicle;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.client.render.Axis;
import com.mrcrayfish.vehicle.common.Seat;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.entity.vehicle.SportsPlaneEntity;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;

public class RenderSportsPlane
extends AbstractRenderVehicle<SportsPlaneEntity> {
    @Override
    public void render(SportsPlaneEntity entity, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, float partialTicks, int light) {
        this.renderDamagedPart((VehicleEntity)entity, SpecialModels.SPORTS_PLANE.getModel(), matrixStack, renderTypeBuffer, light);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, -0.1875, 0.5);
        matrixStack.func_227861_a_(0.5, 0.0, 0.0);
        matrixStack.func_227861_a_(0.375, 0.0, 0.0);
        matrixStack.func_227863_a_(Axis.POSITIVE_X.func_229187_a_(-5.0f));
        this.renderDamagedPart((VehicleEntity)entity, SpecialModels.SPORTS_PLANE_WING.getModel(), matrixStack, renderTypeBuffer, light);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, -0.1875, 0.5);
        matrixStack.func_227863_a_(Axis.POSITIVE_Z.func_229187_a_(180.0f));
        matrixStack.func_227861_a_(0.5, 0.0625, 0.0);
        matrixStack.func_227861_a_(0.375, 0.0, 0.0);
        matrixStack.func_227863_a_(Axis.POSITIVE_X.func_229187_a_(5.0f));
        this.renderDamagedPart((VehicleEntity)entity, SpecialModels.SPORTS_PLANE_WING.getModel(), matrixStack, renderTypeBuffer, light);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, -0.5, 0.0);
        matrixStack.func_227862_a_(0.85f, 0.85f, 0.85f);
        this.renderWheel(entity, matrixStack, renderTypeBuffer, 0.0f, -0.1875f, 1.5f, 0.0f, partialTicks, light);
        this.renderWheel(entity, matrixStack, renderTypeBuffer, 0.46875f, -0.1875f, 0.125f, 100.0f, partialTicks, light);
        this.renderWheel(entity, matrixStack, renderTypeBuffer, -0.46875f, -0.1875f, 0.125f, -100.0f, partialTicks, light);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        float propellerRotation = entity.prevPropellerRotation + (entity.propellerRotation - entity.prevPropellerRotation) * partialTicks;
        matrixStack.func_227861_a_(0.0, -0.09375, 1.3875);
        matrixStack.func_227863_a_(Axis.POSITIVE_Z.func_229187_a_(propellerRotation));
        this.renderDamagedPart((VehicleEntity)entity, SpecialModels.SPORTS_PLANE_PROPELLER.getModel(), matrixStack, renderTypeBuffer, light);
        matrixStack.func_227865_b_();
    }

    private void renderWheel(SportsPlaneEntity vehicle, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, float offsetX, float offsetY, float offsetZ, float legRotation, float partialTicks, int light) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)offsetX, (double)offsetY, (double)offsetZ);
        this.renderDamagedPart((VehicleEntity)vehicle, SpecialModels.SPORTS_PLANE_WHEEL_COVER.getModel(), matrixStack, renderTypeBuffer, light);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, -0.140625, 0.0);
        matrixStack.func_227860_a_();
        if (vehicle.isMoving()) {
            float wheelRotation = vehicle.prevWheelRotation + (vehicle.wheelRotation - vehicle.prevWheelRotation) * partialTicks;
            matrixStack.func_227863_a_(Axis.POSITIVE_X.func_229187_a_(-wheelRotation));
        }
        matrixStack.func_227862_a_(0.8f, 0.8f, 0.8f);
        RenderUtil.renderColoredModel(RenderUtil.getModel(new ItemStack((IItemProvider)ModItems.STANDARD_WHEEL.get())), ItemCameraTransforms.TransformType.NONE, false, matrixStack, renderTypeBuffer, -1, light, OverlayTexture.field_229196_a_);
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
        matrixStack.func_227863_a_(Axis.POSITIVE_Y.func_229187_a_(legRotation));
        this.renderDamagedPart((VehicleEntity)vehicle, SpecialModels.SPORTS_PLANE_LEG.getModel(), matrixStack, renderTypeBuffer, light);
        matrixStack.func_227865_b_();
    }

    @Override
    public void applyPlayerModel(SportsPlaneEntity entity, PlayerEntity player, PlayerModel model, float partialTicks) {
        model.field_178721_j.field_78795_f = (float)Math.toRadians(-85.0);
        model.field_178721_j.field_78796_g = (float)Math.toRadians(10.0);
        model.field_178722_k.field_78795_f = (float)Math.toRadians(-85.0);
        model.field_178722_k.field_78796_g = (float)Math.toRadians(-10.0);
    }

    @Override
    public void applyPlayerRender(SportsPlaneEntity entity, PlayerEntity player, float partialTicks, MatrixStack matrixStack, IVertexBuilder builder) {
        int index = entity.getSeatTracker().getSeatIndex(player.func_110124_au());
        if (index != -1) {
            VehicleProperties properties = entity.getProperties();
            Seat seat = properties.getSeats().get(index);
            Vector3d seatVec = seat.getPosition().func_72441_c(0.0, (double)(properties.getAxleOffset() + properties.getWheelOffset()), 0.0).func_186678_a(properties.getBodyPosition().getScale()).func_186678_a(0.0625);
            double scale = 1.0666666666666667;
            double offsetX = seatVec.field_72450_a * scale;
            double offsetY = (seatVec.field_72448_b + player.func_70033_W() - 0.5) * scale + 1.5;
            double offsetZ = seatVec.field_72449_c * scale;
            matrixStack.func_227861_a_(offsetX, offsetY, offsetZ);
            float bodyPitch = entity.prevBodyRotationX + (entity.bodyRotationX - entity.prevBodyRotationX) * partialTicks;
            float bodyRoll = entity.prevBodyRotationZ + (entity.bodyRotationZ - entity.prevBodyRotationZ) * partialTicks;
            matrixStack.func_227863_a_(Axis.POSITIVE_Z.func_229187_a_(bodyRoll));
            matrixStack.func_227863_a_(Axis.POSITIVE_X.func_229187_a_(-bodyPitch));
            matrixStack.func_227861_a_(-offsetX, -offsetY, -offsetX);
        }
    }
}

