/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity.trailer;

import com.mrcrayfish.vehicle.client.EntityRayTracer;
import com.mrcrayfish.vehicle.entity.TrailerEntity;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageAttachTrailer;
import com.mrcrayfish.vehicle.network.message.MessageEntityFluid;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.PacketDistributor;

public class FluidTrailerEntity
extends TrailerEntity
implements IEntityAdditionalSpawnData {
    private static final EntityRayTracer.RayTracePart CONNECTION_BOX = new EntityRayTracer.RayTracePart(FluidTrailerEntity.createScaledBoundingBox(-0.4375, 0.26875, 0.875, 0.4375, 0.53125, 1.5, 1.1));
    private static final Map<EntityRayTracer.RayTracePart, EntityRayTracer.TriangleRayTraceList> interactionBoxMapStatic = (Map)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> {
        HashMap<EntityRayTracer.RayTracePart, EntityRayTracer.TriangleRayTraceList> map = new HashMap<EntityRayTracer.RayTracePart, EntityRayTracer.TriangleRayTraceList>();
        map.put(CONNECTION_BOX, EntityRayTracer.boxToTriangles(CONNECTION_BOX.getBox(), null));
        return map;
    });
    protected FluidTank tank = new FluidTank(100000){

        protected void onContentsChanged() {
            FluidTrailerEntity.this.syncTank();
        }
    };

    public FluidTrailerEntity(EntityType<? extends FluidTrailerEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public boolean canBeColored() {
        return true;
    }

    @Override
    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (!this.field_70170_p.field_72995_K && !player.func_213453_ef() && FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)this.tank)) {
            return ActionResultType.SUCCESS;
        }
        return super.func_184230_a(player, hand);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Map<EntityRayTracer.RayTracePart, EntityRayTracer.TriangleRayTraceList> getStaticInteractionBoxMap() {
        return interactionBoxMapStatic;
    }

    @Override
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public List<EntityRayTracer.RayTracePart> getApplicableInteractionBoxes() {
        return Collections.singletonList(CONNECTION_BOX);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInteractionBoxes(Tessellator tessellator, BufferBuilder buffer) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean processHit(EntityRayTracer.RayTraceResultRotated result, boolean rightClick) {
        if (result.getPartHit() == CONNECTION_BOX && rightClick) {
            PacketHandler.instance.sendToServer((Object)new MessageAttachTrailer(this.func_145782_y(), Minecraft.func_71410_x().field_71439_g.func_145782_y()));
            return true;
        }
        return super.processHit(result, rightClick);
    }

    @Override
    public double getHitchOffset() {
        return -25.0;
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Tank", 10)) {
            this.tank.readFromNBT(compound.func_74775_l("Tank"));
        }
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        CompoundNBT tankTag = new CompoundNBT();
        this.tank.writeToNBT(tankTag);
        compound.func_218657_a("Tank", (INBT)tankTag);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.tank).cast();
        }
        return super.getCapability(cap);
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public void syncTank() {
        if (!this.field_70170_p.field_72995_K) {
            PacketHandler.instance.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new MessageEntityFluid(this.func_145782_y(), this.tank.getFluid()));
        }
    }

    @Override
    public void writeSpawnData(PacketBuffer buffer) {
        super.writeSpawnData(buffer);
        buffer.func_150786_a(this.tank.writeToNBT(new CompoundNBT()));
    }

    @Override
    public void readSpawnData(PacketBuffer buffer) {
        super.readSpawnData(buffer);
        this.tank.readFromNBT(buffer.func_150793_b());
    }
}

