/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.network.message;

import com.mrcrayfish.vehicle.common.Seat;
import com.mrcrayfish.vehicle.common.SeatTracker;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.network.message.IMessage;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageCycleSeats
implements IMessage<MessageCycleSeats> {
    @Override
    public void encode(MessageCycleSeats message, PacketBuffer buffer) {
    }

    @Override
    public MessageCycleSeats decode(PacketBuffer buffer) {
        return new MessageCycleSeats();
    }

    @Override
    public void handle(MessageCycleSeats message, Supplier<NetworkEvent.Context> supplier) {
        if (supplier.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            supplier.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)supplier.get()).getSender();
                if (player != null && player.func_184187_bx() instanceof VehicleEntity) {
                    VehicleEntity vehicle = (VehicleEntity)player.func_184187_bx();
                    List<Seat> seats = vehicle.getProperties().getSeats();
                    if (vehicle.func_184188_bt().size() >= seats.size()) {
                        return;
                    }
                    SeatTracker tracker = vehicle.getSeatTracker();
                    int seatIndex = tracker.getSeatIndex(player.func_110124_au());
                    for (int i = 0; i < seats.size() - 1; ++i) {
                        int nextIndex = (seatIndex + (i + 1)) % seats.size();
                        if (!tracker.isSeatAvailable(nextIndex)) continue;
                        tracker.setSeatIndex(nextIndex, player.func_110124_au());
                        return;
                    }
                }
            });
            supplier.get().setPacketHandled(true);
        }
    }
}

