/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.tile;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import vazkii.quark.addons.oddities.block.CrateBlock;
import vazkii.quark.addons.oddities.container.CrateContainer;
import vazkii.quark.addons.oddities.module.CrateModule;
import vazkii.quark.base.handler.SortingHandler;

public class CrateTileEntity
extends LockableTileEntity
implements ISidedInventory,
ITickableTileEntity {
    private int totalItems = 0;
    private int numPlayersUsing;
    private List<ItemStack> stacks = new ArrayList<ItemStack>();
    private LazyOptional<SidedInvWrapper> wrapper = LazyOptional.of(() -> new SidedInvWrapper((ISidedInventory)this, Direction.UP));
    private int[] visibleSlots = new int[0];
    boolean needsUpdate = false;
    protected final IIntArray crateData = new IIntArray(){

        public int func_221476_a(int index) {
            return index == 0 ? CrateTileEntity.this.totalItems : CrateTileEntity.this.stacks.size();
        }

        public void func_221477_a(int index, int value) {
        }

        public int func_221478_a() {
            return 2;
        }
    };

    public CrateTileEntity() {
        super(CrateModule.crateType);
    }

    public void spillTheTea() {
        SortingHandler.mergeStacks(this.stacks);
        for (ItemStack stack : this.stacks) {
            if (stack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)stack);
        }
    }

    public void func_73660_a() {
        if (this.needsUpdate) {
            this.stacks.removeIf(ItemStack::func_190926_b);
            this.needsUpdate = false;
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("totalItems", this.totalItems);
        ListNBT list = new ListNBT();
        for (ItemStack stack : this.stacks) {
            CompoundNBT stackCmp = new CompoundNBT();
            stack.func_77955_b(stackCmp);
            list.add((Object)stackCmp);
        }
        compound.func_218657_a("stacks", (INBT)list);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        this.totalItems = nbt.func_74762_e("totalItems");
        ListNBT list = nbt.func_150295_c("stacks", 10);
        this.stacks = new ArrayList<ItemStack>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            this.stacks.add(ItemStack.func_199557_a((CompoundNBT)list.func_150305_b(i)));
        }
        super.func_230337_a_(state, nbt);
    }

    public ItemStack func_70301_a(int slot) {
        return slot < this.stacks.size() ? this.stacks.get(slot) : ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int slot) {
        if (slot < this.stacks.size()) {
            ItemStack stack = this.func_70301_a(slot);
            this.totalItems -= stack.func_190916_E();
            this.needsUpdate = true;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        ItemStack stackAt = this.func_70301_a(slot);
        if (slot >= this.stacks.size()) {
            this.stacks.add(stack);
            this.totalItems += stack.func_190916_E();
        } else {
            int sizeDiff = stack.func_190916_E() - stackAt.func_190916_E();
            this.totalItems += sizeDiff;
            this.stacks.set(slot, stack);
        }
    }

    public ItemStack func_70298_a(int slot, int count) {
        ItemStack stack = this.func_70301_a(slot);
        ItemStack retstack = stack.func_77979_a(count);
        this.totalItems -= count;
        if (stack.func_190926_b()) {
            this.needsUpdate = true;
        }
        return retstack;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.totalItems = 0;
        for (ItemStack stack : this.stacks) {
            this.totalItems += stack.func_190916_E();
        }
    }

    public int func_70302_i_() {
        return Math.min(CrateModule.maxItems, this.stacks.size() + 1);
    }

    public void func_174888_l() {
        this.stacks.clear();
        this.totalItems = 0;
    }

    public boolean func_191420_l() {
        return this.totalItems == 0;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction dir) {
        return true;
    }

    public boolean func_180462_a(int index, ItemStack stack, Direction dir) {
        return this.totalItems + stack.func_190916_E() <= CrateModule.maxItems;
    }

    public int[] func_180463_a(Direction arg0) {
        if (this.visibleSlots.length != this.stacks.size() + 1) {
            this.visibleSlots = new int[this.stacks.size() + 1];
            for (int i = 0; i < this.visibleSlots.length; ++i) {
                this.visibleSlots[i] = i;
            }
        }
        return this.visibleSlots;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent(CrateModule.crate.func_149739_a());
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new CrateContainer(id, player, this, this.crateData);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.wrapper.cast();
        }
        return super.getCapability(capability, facing);
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !(player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    public void func_174889_b(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            BlockState blockstate = this.func_195044_w();
            boolean flag = (Boolean)blockstate.func_177229_b((Property)CrateBlock.PROPERTY_OPEN);
            if (!flag) {
                this.playSound(blockstate, SoundEvents.field_219602_O);
                this.setOpenProperty(blockstate, true);
            }
            this.scheduleTick();
        }
    }

    private void scheduleTick() {
        this.field_145850_b.func_205220_G_().func_205360_a(this.func_174877_v(), (Object)this.func_195044_w().func_177230_c(), 5);
    }

    public void crateTick() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        this.numPlayersUsing = CrateTileEntity.calculatePlayersUsing(this.field_145850_b, this, i, j, k);
        if (this.numPlayersUsing > 0) {
            this.scheduleTick();
        } else {
            BlockState blockstate = this.func_195044_w();
            if (!blockstate.func_203425_a(CrateModule.crate)) {
                this.func_145843_s();
                return;
            }
            boolean flag = (Boolean)blockstate.func_177229_b((Property)CrateBlock.PROPERTY_OPEN);
            if (flag) {
                this.playSound(blockstate, SoundEvents.field_219601_N);
                this.setOpenProperty(blockstate, false);
            }
        }
    }

    public static int calculatePlayersUsing(World p_213976_0_, LockableTileEntity p_213976_1_, int p_213976_2_, int p_213976_3_, int p_213976_4_) {
        int i = 0;
        for (PlayerEntity playerentity : p_213976_0_.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)((float)p_213976_2_ - 5.0f), (double)((float)p_213976_3_ - 5.0f), (double)((float)p_213976_4_ - 5.0f), (double)((float)(p_213976_2_ + 1) + 5.0f), (double)((float)(p_213976_3_ + 1) + 5.0f), (double)((float)(p_213976_4_ + 1) + 5.0f)))) {
            CrateTileEntity iinventory;
            if (!(playerentity.field_71070_bA instanceof CrateContainer) || (iinventory = ((CrateContainer)playerentity.field_71070_bA).crate) != p_213976_1_) continue;
            ++i;
        }
        return i;
    }

    public void func_174886_c(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.numPlayersUsing;
        }
    }

    private void setOpenProperty(BlockState state, boolean open) {
        this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)state.func_206870_a((Property)CrateBlock.PROPERTY_OPEN, (Comparable)Boolean.valueOf(open)), 3);
    }

    private void playSound(BlockState state, SoundEvent sound) {
        double d0 = (double)this.field_174879_c.func_177958_n() + 0.5;
        double d1 = (double)this.field_174879_c.func_177956_o() + 0.5;
        double d2 = (double)this.field_174879_c.func_177952_p() + 0.5;
        this.field_145850_b.func_184148_a((PlayerEntity)null, d0, d1, d2, sound, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }
}

