/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import vazkii.arl.interf.IBlockColorProvider;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.block.QuarkSlabBlock;
import vazkii.quark.base.block.QuarkStairsBlock;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.building.block.VerticalSlabBlock;
import vazkii.quark.content.building.module.VerticalSlabsModule;

public class TurfBlock
extends QuarkBlock
implements IBlockColorProvider {
    public TurfBlock(String regname, QuarkModule module, ItemGroup creativeTab, AbstractBlock.Properties properties) {
        super(regname, module, creativeTab, properties);
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction dir, IPlantable plant) {
        return TurfBlock.canSustain(state, world, pos, dir, plant);
    }

    @OnlyIn(value=Dist.CLIENT)
    public IBlockColor getBlockColor() {
        BlockColors colors = Minecraft.func_71410_x().func_184125_al();
        BlockState grass = Blocks.field_196658_i.func_176223_P();
        return (state, world, pos, tintIndex) -> colors.func_228054_a_(grass, world, pos, tintIndex);
    }

    @OnlyIn(value=Dist.CLIENT)
    public IItemColor getItemColor() {
        ItemColors colors = Minecraft.func_71410_x().getItemColors();
        ItemStack grass = new ItemStack((IItemProvider)Items.field_221581_i);
        return (stack, tintIndex) -> colors.func_186728_a(grass, tintIndex);
    }

    public static boolean canSustain(BlockState state, IBlockReader world, BlockPos pos, Direction dir, IPlantable plant) {
        if (!state.func_224755_d(world, pos, dir)) {
            return false;
        }
        PlantType type = plant.getPlantType(world, pos.func_177972_a(dir));
        if (plant instanceof BushBlock || PlantType.PLAINS.equals(type)) {
            return true;
        }
        if (PlantType.BEACH.equals(type)) {
            boolean hasWater = world.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
            if (!hasWater) {
                for (Direction face : Direction.Plane.HORIZONTAL) {
                    BlockState blockState = world.func_180495_p(pos.func_177972_a(face));
                    FluidState fluidState = world.func_204610_c(pos.func_177972_a(face));
                    hasWater |= blockState.func_203425_a(Blocks.field_185778_de);
                    if (!(hasWater |= fluidState.func_206884_a((ITag)FluidTags.field_206959_a))) continue;
                    break;
                }
            }
            return hasWater;
        }
        return false;
    }

    public static class TurfVerticalSlabBlock
    extends VerticalSlabBlock {
        public TurfVerticalSlabBlock(Block parent, QuarkModule module) {
            super(parent, module);
        }

        public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction dir, IPlantable plant) {
            return TurfBlock.canSustain(state, world, pos, dir, plant);
        }
    }

    public static class TurfStairsBlock
    extends QuarkStairsBlock {
        public TurfStairsBlock(IQuarkBlock parent) {
            super(parent);
        }

        public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction dir, IPlantable plant) {
            return TurfBlock.canSustain(state, world, pos, dir, plant);
        }
    }

    public static class TurfSlabBlock
    extends QuarkSlabBlock
    implements VerticalSlabsModule.IVerticalSlabProvider {
        public TurfSlabBlock(IQuarkBlock parent) {
            super(parent);
        }

        public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction dir, IPlantable plant) {
            return TurfBlock.canSustain(state, world, pos, dir, plant);
        }

        @Override
        public VerticalSlabBlock getVerticalSlab(Block block, QuarkModule module) {
            return new TurfVerticalSlabBlock(block, module);
        }
    }
}

