/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.entity;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BannerItem;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import vazkii.quark.base.util.MovableFakePlayer;
import vazkii.quark.content.building.module.ItemFramesModule;

public class GlassItemFrameEntity
extends ItemFrameEntity
implements IEntityAdditionalSpawnData {
    public static final DataParameter<Boolean> IS_SHINY = EntityDataManager.func_187226_a(GlassItemFrameEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final String TAG_SHINY = "isShiny";
    private boolean didHackery = false;
    private FakePlayer fakePlayer = null;

    public GlassItemFrameEntity(EntityType<? extends GlassItemFrameEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public GlassItemFrameEntity(World worldIn, BlockPos blockPos, Direction face) {
        super(ItemFramesModule.glassFrameEntity, worldIn);
        this.field_174861_a = blockPos;
        this.func_174859_a(face);
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        BlockState behindState;
        ActionResultType result;
        BlockPos behind;
        TileEntity tile;
        ItemStack item = this.func_82335_i();
        if (!player.func_225608_bj_() && !item.func_190926_b() && !(item.func_77973_b() instanceof BannerItem) && (tile = this.field_70170_p.func_175625_s(behind = this.getBehindPos())) != null && tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent() && (result = (behindState = this.field_70170_p.func_180495_p(behind)).func_227031_a_(this.field_70170_p, player, hand, new BlockRayTraceResult(new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()), this.field_174860_b, behind, true))).func_226246_a_()) {
            return result;
        }
        return super.func_184230_a(player, hand);
    }

    public void func_70071_h_() {
        ItemStack stack;
        super.func_70071_h_();
        if (ItemFramesModule.glassItemFramesUpdateMaps && (stack = this.func_82335_i()).func_77973_b() instanceof FilledMapItem && this.field_70170_p instanceof ServerWorld) {
            ServerWorld sworld = (ServerWorld)this.field_70170_p;
            ItemStack clone = stack.func_77946_l();
            MapData data = FilledMapItem.func_195950_a((ItemStack)clone, (World)this.field_70170_p);
            if (data != null && !data.field_215161_h) {
                if (this.fakePlayer == null) {
                    this.fakePlayer = new MovableFakePlayer(sworld, new GameProfile(UUID.randomUUID(), "ItemFrame"));
                }
                FilledMapItem item = (FilledMapItem)stack.func_77973_b();
                clone.func_234695_a_(null);
                this.fakePlayer.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                this.fakePlayer.field_71071_by.func_70299_a(0, clone);
                item.func_77872_a(this.field_70170_p, (Entity)this.fakePlayer, data);
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_SHINY, (Object)false);
    }

    public boolean func_70518_d() {
        return super.func_70518_d() || this.isOnSign();
    }

    public BlockPos getBehindPos() {
        return this.field_174861_a.func_177972_a(this.field_174860_b.func_176734_d());
    }

    public boolean isOnSign() {
        BlockState blockstate = this.field_70170_p.func_180495_p(this.getBehindPos());
        return blockstate.func_177230_c().func_203417_a((ITag)BlockTags.field_219751_T);
    }

    @Nullable
    public ItemEntity func_70099_a(@Nonnull ItemStack stack, float offset) {
        if (stack.func_77973_b() == Items.field_151160_bD && !this.didHackery) {
            stack = new ItemStack((IItemProvider)this.getItem());
            this.didHackery = true;
        }
        return super.func_70099_a(stack, offset);
    }

    @Nonnull
    public ItemStack getPickedResult(RayTraceResult target) {
        ItemStack held = this.func_82335_i();
        if (held.func_190926_b()) {
            return new ItemStack((IItemProvider)this.getItem());
        }
        return held.func_77946_l();
    }

    private Item getItem() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SHINY) != false ? ItemFramesModule.glowingGlassFrame : ItemFramesModule.glassFrame;
    }

    public void func_213281_b(CompoundNBT cmp) {
        super.func_213281_b(cmp);
        cmp.func_74757_a(TAG_SHINY, ((Boolean)this.field_70180_af.func_187225_a(IS_SHINY)).booleanValue());
    }

    public void func_70037_a(CompoundNBT cmp) {
        super.func_70037_a(cmp);
        this.field_70180_af.func_187227_b(IS_SHINY, (Object)cmp.func_74767_n(TAG_SHINY));
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_179255_a(this.field_174861_a);
        buffer.func_150787_b(this.field_174860_b.func_176745_a());
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.field_174861_a = buffer.func_179259_c();
        this.func_174859_a(Direction.func_82600_a((int)buffer.func_150792_a()));
    }
}

