/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.management.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.recipebook.IRecipeShownListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import vazkii.quark.base.client.handler.TopLayerTooltipHandler;
import vazkii.quark.base.handler.MiscUtil;

public class MiniInventoryButton
extends Button {
    private final Consumer<List<String>> tooltip;
    private final int type;
    private final ContainerScreen<?> parent;
    private final int startX;
    private BooleanSupplier shiftTexture = () -> false;

    public MiniInventoryButton(ContainerScreen<?> parent, int type, int x, int y, Consumer<List<String>> tooltip, Button.IPressable onPress) {
        super(parent.getGuiLeft() + x, parent.getGuiTop() + y, 10, 10, (ITextComponent)new StringTextComponent(""), onPress);
        this.parent = parent;
        this.type = type;
        this.tooltip = tooltip;
        this.startX = x;
    }

    public MiniInventoryButton(ContainerScreen<?> parent, int type, int x, int y, String tooltip, Button.IPressable onPress) {
        this(parent, type, x, y, (List<String> t) -> t.add(I18n.func_135052_a((String)tooltip, (Object[])new Object[0])), onPress);
    }

    public MiniInventoryButton setTextureShift(BooleanSupplier func) {
        this.shiftTexture = func;
        return this;
    }

    public void func_230430_a_(MatrixStack matrix, int p_render_1_, int p_render_2_, float p_render_3_) {
        if (this.parent instanceof IRecipeShownListener) {
            this.field_230690_l_ = this.parent.getGuiLeft() + this.startX;
        }
        super.func_230430_a_(matrix, p_render_1_, p_render_2_, p_render_3_);
    }

    public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float pticks) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(MiscUtil.GENERAL_ICONS);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
        RenderSystem.disableLighting();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int u = this.type * this.field_230688_j_;
        int v = 25 + (this.field_230692_n_ ? this.field_230689_k_ : 0);
        if (this.shiftTexture.getAsBoolean()) {
            v += this.field_230689_k_ * 2;
        }
        this.func_238474_b_(matrix, this.field_230690_l_, this.field_230691_m_, u, v, this.field_230688_j_, this.field_230689_k_);
        if (this.field_230692_n_) {
            TopLayerTooltipHandler.setTooltip(this.getTooltip(), mouseX, mouseY);
        }
    }

    protected IFormattableTextComponent func_230442_c_() {
        List<String> tooltip = this.getTooltip();
        return tooltip.isEmpty() ? new StringTextComponent("") : new TranslationTextComponent("gui.narrate.button", new Object[]{this.getTooltip().get(0)});
    }

    public List<String> getTooltip() {
        LinkedList<String> list = new LinkedList<String>();
        this.tooltip.accept(list);
        return list;
    }
}

