/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class PoisonPotatoUsageModule
extends QuarkModule {
    private static final String TAG_POISONED = "quark:poison_potato_applied";
    @Config
    public static double chance = 0.1;
    @Config
    public static boolean poisonEffect = true;

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.EntityInteract event) {
        AgeableEntity ageable;
        if (event.getTarget() instanceof AgeableEntity && event.getItemStack().func_77973_b() == Items.field_151170_bI && (ageable = (AgeableEntity)event.getTarget()).func_70631_g_() && !this.isEntityPoisoned((Entity)ageable)) {
            if (!event.getWorld().field_72995_K) {
                Vector3d pos = ageable.func_213303_ch();
                if (ageable.field_70170_p.field_73012_v.nextDouble() < chance) {
                    ageable.func_184185_a(SoundEvents.field_187537_bA, 0.5f, 0.25f);
                    ageable.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.2, 0.8, 0.0);
                    this.poisonEntity((Entity)ageable);
                    if (poisonEffect) {
                        ageable.func_195064_c(new EffectInstance(Effects.field_76436_u, 200));
                    }
                } else {
                    ageable.func_184185_a(SoundEvents.field_187537_bA, 0.5f, 0.5f + ageable.field_70170_p.field_73012_v.nextFloat() / 2.0f);
                    ageable.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.1, 0.0);
                }
                if (!event.getPlayer().func_184812_l_()) {
                    event.getItemStack().func_190918_g(1);
                }
            } else {
                event.getPlayer().func_184609_a(event.getHand());
            }
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        AnimalEntity animal;
        if (event.getEntity() instanceof AnimalEntity && (animal = (AnimalEntity)event.getEntity()).func_70631_g_() && this.isEntityPoisoned((Entity)animal)) {
            animal.func_70873_a(-24000);
        }
    }

    private boolean isEntityPoisoned(Entity e) {
        return e.getPersistentData().func_74767_n(TAG_POISONED);
    }

    private void poisonEntity(Entity e) {
        e.getPersistentData().func_74757_a(TAG_POISONED, true);
    }
}

