/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.math;

import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class ChunkDimPos
implements Comparable<ChunkDimPos> {
    public final RegistryKey<World> dimension;
    public final int x;
    public final int z;
    private ChunkPos chunkPos;
    private int hash;

    public ChunkDimPos(RegistryKey<World> dim, int _x, int _z) {
        this.dimension = dim;
        this.x = _x;
        this.z = _z;
    }

    public ChunkDimPos(RegistryKey<World> dim, ChunkPos pos) {
        this(dim, pos.field_77276_a, pos.field_77275_b);
    }

    public ChunkDimPos(World world, BlockPos pos) {
        this((RegistryKey<World>)world.func_234923_W_(), pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    public ChunkDimPos(Entity entity) {
        this(entity.field_70170_p, entity.func_233580_cy_());
    }

    public ChunkPos getChunkPos() {
        if (this.chunkPos == null) {
            this.chunkPos = new ChunkPos(this.x, this.z);
        }
        return this.chunkPos;
    }

    public String toString() {
        return "[" + this.dimension.func_240901_a_() + ":" + this.x + ":" + this.z + "]";
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Objects.hash(this.dimension.func_240901_a_(), this.x, this.z);
            if (this.hash == 0) {
                this.hash = 1;
            }
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ChunkDimPos) {
            ChunkDimPos p = (ChunkDimPos)obj;
            return this.dimension == p.dimension && this.x == p.x && this.z == p.z;
        }
        return false;
    }

    @Override
    public int compareTo(ChunkDimPos o) {
        int i = this.dimension.func_240901_a_().compareTo(o.dimension.func_240901_a_());
        return i == 0 ? Long.compare(this.getChunkPos().func_201841_a(), o.getChunkPos().func_201841_a()) : i;
    }

    public ChunkDimPos offset(int ox, int oz) {
        return new ChunkDimPos(this.dimension, this.x + ox, this.z + oz);
    }
}

