/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.loot.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.darkhax.bookshelf.Bookshelf;
import net.darkhax.bookshelf.util.WorldUtils;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.gen.feature.structure.Structure;

public class CheckStructure
implements ILootCondition {
    public static final Serializer SERIALIZER = new Serializer();
    private final String structureName;
    private Structure<?> structure;

    public CheckStructure(String structureName) {
        this.structureName = structureName;
    }

    public boolean test(LootContext ctx) {
        Vector3d pos = (Vector3d)ctx.func_216031_c(LootParameters.field_237457_g_);
        if (pos != null && this.loadStructure()) {
            return WorldUtils.isInStructure(ctx.func_202879_g(), new BlockPos(pos), this.structure);
        }
        return false;
    }

    public LootConditionType func_230419_b_() {
        return Bookshelf.instance.conditionCheckStructure;
    }

    private boolean loadStructure() {
        if (this.structure == null) {
            this.structure = (Structure)Structure.field_236365_a_.get((Object)this.structureName);
            if (this.structure == null) {
                Bookshelf.LOG.error("Loot table condition is looking for structure {} which doesn't exist.", (Object)this.structureName);
                return false;
            }
        }
        return true;
    }

    static class Serializer
    implements ILootSerializer<CheckStructure> {
        Serializer() {
        }

        public void serialize(JsonObject json, CheckStructure value, JsonSerializationContext context) {
            json.addProperty("structure", value.structureName);
        }

        public CheckStructure deserialize(JsonObject json, JsonDeserializationContext context) {
            String name = JSONUtils.func_151200_h((JsonObject)json, (String)"structure");
            return new CheckStructure(name);
        }
    }
}

