/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL11;
import sonar.fluxnetworks.common.misc.FluxUtils;

public class LineChart {
    private final int x;
    private final int y;
    private final int height;
    private final int linePoints;
    private final String displayUnitX;
    private String displayUnitY;
    private long maxUnitY;
    private final String suffixUnitY;
    private LongList data = new LongArrayList();
    private final FloatList currentHeight;
    private final FloatList targetHeight;

    public LineChart(int x, int y, int height, int linePoints, String displayUnitX, String suffixUnitY) {
        int i;
        this.x = x;
        this.y = y;
        this.height = height;
        this.linePoints = linePoints;
        this.displayUnitX = displayUnitX;
        this.suffixUnitY = suffixUnitY;
        this.currentHeight = new FloatArrayList(linePoints);
        for (i = 0; i < linePoints; ++i) {
            this.currentHeight.add((float)(y + height));
        }
        this.targetHeight = new FloatArrayList(linePoints);
        for (i = 0; i < linePoints; ++i) {
            this.targetHeight.add((float)(y + height));
        }
    }

    public void drawChart(Minecraft mc, MatrixStack matrixStack, float partialTicks) {
        int i;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableTexture();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        GL11.glLineWidth((float)((float)mc.func_228018_at_().func_198100_s()));
        builder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (i = 0; i < this.currentHeight.size(); ++i) {
            builder.func_225582_a_((double)(this.x + 20 * i), (double)this.currentHeight.getFloat(i), 0.0).func_225586_a_(255, 255, 255, 255).func_181675_d();
        }
        tessellator.func_78381_a();
        GL11.glDisable((int)2848);
        GL11.glLineWidth((float)1.0f);
        GL11.glEnable((int)2832);
        GL11.glHint((int)3153, (int)4354);
        GL11.glPointSize((float)((float)(4.0 * mc.func_228018_at_().func_198100_s())));
        builder.func_181668_a(0, DefaultVertexFormats.field_181706_f);
        for (i = 0; i < this.currentHeight.size(); ++i) {
            builder.func_225582_a_((double)(this.x + 20 * i), (double)this.currentHeight.getFloat(i), 0.0).func_225586_a_(255, 255, 255, 255).func_181675_d();
        }
        tessellator.func_78381_a();
        GL11.glDisable((int)2832);
        GL11.glPointSize((float)1.0f);
        Screen.func_238467_a_((MatrixStack)matrixStack, (int)(this.x - 16), (int)(this.y + this.height), (int)(this.x + 116), (int)(this.y + this.height + 1), (int)-805306369);
        Screen.func_238467_a_((MatrixStack)matrixStack, (int)(this.x - 14), (int)(this.y - 6), (int)(this.x - 13), (int)(this.y + this.height + 3), (int)-805306369);
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(0.625f, 0.625f, 1.0f);
        mc.field_71466_p.func_238421_b_(matrixStack, this.suffixUnitY, (float)(this.x - 15) * 1.6f - (float)mc.field_71466_p.func_78256_a(this.suffixUnitY), ((float)this.y - 7.5f) * 1.6f, 0xFFFFFF);
        mc.field_71466_p.func_238421_b_(matrixStack, this.displayUnitY, (float)(this.x - 15) * 1.6f - (float)mc.field_71466_p.func_78256_a(this.displayUnitY), (float)(this.y - 2) * 1.6f, 0xFFFFFF);
        mc.field_71466_p.func_238421_b_(matrixStack, this.displayUnitX, (float)(this.x + 118) * 1.6f - (float)mc.field_71466_p.func_78256_a(this.displayUnitX), ((float)(this.y + this.height) + 1.5f) * 1.6f, 0xFFFFFF);
        for (i = 0; i < this.data.size(); ++i) {
            String d = FluxUtils.compact(this.data.getLong(i));
            mc.field_71466_p.func_238421_b_(matrixStack, d, (float)(this.x + 20 * i) * 1.6f - (float)mc.field_71466_p.func_78256_a(d) * 0.5f, (this.currentHeight.getFloat(i) - 7.0f) * 1.6f, 0xFFFFFF);
            String c = String.valueOf((5 - i) * 5);
            mc.field_71466_p.func_238421_b_(matrixStack, c, (float)(this.x + 20 * i) * 1.6f - (float)mc.field_71466_p.func_78256_a(c) * 0.5f, (float)(this.y + this.height + 2) * 1.6f, 0xFFFFFF);
        }
        matrixStack.func_227865_b_();
        RenderSystem.disableBlend();
        this.updateHeight(partialTicks);
    }

    public void updateData(LongList newData) {
        this.data = newData;
        this.calculateUnitY((List<Long>)newData);
        this.calculateTargetHeight((List<Long>)newData);
    }

    private void updateHeight(float partialTick) {
        if (this.currentHeight.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.currentHeight.size(); ++i) {
            float diff = this.targetHeight.getFloat(i) - this.currentHeight.getFloat(i);
            if (diff == 0.0f) continue;
            float p = partialTick / 16.0f;
            float r = Math.abs(diff) <= p ? this.targetHeight.getFloat(i) : (diff > 0.0f ? this.currentHeight.getFloat(i) + Math.max(Math.min(diff, diff / 4.0f * partialTick), p) : this.currentHeight.getFloat(i) + Math.min(Math.max(diff, diff / 4.0f * partialTick), -p));
            this.currentHeight.set(i, r);
        }
    }

    private void calculateUnitY(@Nonnull List<Long> data) {
        long maxUnitY;
        long maxValue = 0L;
        for (long v : data) {
            maxValue = Math.max(maxValue, v);
        }
        if (maxValue <= 0L) {
            this.displayUnitY = "1";
            this.maxUnitY = 1L;
            return;
        }
        int exp = (int)Math.log10(maxValue);
        if (exp <= 0) {
            maxUnitY = maxValue + 1L;
        } else if (exp <= 1) {
            maxUnitY = (maxValue / 5L + 1L) * 5L;
        } else if (exp <= 2) {
            maxUnitY = (maxValue / 50L + 1L) * 50L;
        } else {
            int unit = 10;
            for (int i = 1; i < exp; ++i) {
                unit *= 10;
            }
            maxUnitY = (maxValue / (long)unit + 1L) * (long)unit;
        }
        this.displayUnitY = FluxUtils.compact(maxUnitY);
        this.maxUnitY = maxUnitY;
    }

    private void calculateTargetHeight(@Nonnull List<Long> data) {
        if (data.size() != this.linePoints) {
            return;
        }
        int i = 0;
        for (Long value : data) {
            this.targetHeight.set(i, (float)((double)this.y + (double)this.height * (1.0 - (double)value.longValue() / (double)this.maxUnitY)));
            ++i;
        }
    }
}

