/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.basic;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public abstract class GuiButtonCore
extends AbstractGui {
    public boolean clickable = true;
    public int x;
    public int y;
    public int width;
    public int height;
    public int id;
    protected String text;

    public GuiButtonCore(int x, int y, int width, int height, int id) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.id = id;
    }

    public abstract void drawButton(Minecraft var1, MatrixStack var2, int var3, int var4, int var5, int var6);

    public void updateButton(float partialTicks, int mouseX, int mouseY) {
    }

    protected int getHoverState(boolean b) {
        return b ? 1 : 0;
    }

    public boolean isMouseHovered(Minecraft mc, int mouseX, int mouseY) {
        return mouseX >= this.x && mouseX < this.x + this.width && mouseY < this.y + this.height && mouseY >= this.y;
    }

    public int getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public void drawTexturedRectangular(double x, double y, float textureX, float textureY, float width, float height) {
        float f = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        double zLevel = 0.0;
        bufferbuilder.func_225582_a_(x + 0.0, y + (double)height, zLevel).func_225583_a_(textureX * f, (textureY + height) * f).func_181675_d();
        bufferbuilder.func_225582_a_(x + (double)width, y + (double)height, zLevel).func_225583_a_((textureX + width) * f, (textureY + height) * f).func_181675_d();
        bufferbuilder.func_225582_a_(x + (double)width, y + 0.0, zLevel).func_225583_a_((textureX + width) * f, textureY * f).func_181675_d();
        bufferbuilder.func_225582_a_(x + 0.0, y + 0.0, zLevel).func_225583_a_(textureX * f, textureY * f).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawRect(double left, double top, double right, double bottom, int color) {
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227621_I_();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.color4f((float)f, (float)f1, (float)f2, (float)f3);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_225582_a_(left, bottom, 0.0).func_181675_d();
        bufferbuilder.func_225582_a_(right, bottom, 0.0).func_181675_d();
        bufferbuilder.func_225582_a_(right, top, 0.0).func_181675_d();
        bufferbuilder.func_225582_a_(left, top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_227619_H_();
        GlStateManager.func_227737_l_();
    }

    public void accurateBlit(double left, double top, int uvLeft, int uvTop, double width, double height) {
        int texX = 256;
        int texY = 256;
        GuiButtonCore.accurateBlit(left, left + width, top, top + height, ((float)uvLeft + 0.0f) / (float)texX, ((float)uvLeft + (float)width) / (float)texX, ((float)uvTop + 0.0f) / (float)texY, ((float)uvTop + (float)height) / (float)texY);
    }

    public static void accurateBlit(double left, double right, double bottom, double top, float uvLeft, float uvTop, float uvRight, float uvBottom) {
        double z = 0.0;
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_225582_a_(left, top, z).func_225583_a_(uvLeft, uvBottom).func_181675_d();
        builder.func_225582_a_(right, top, z).func_225583_a_(uvTop, uvBottom).func_181675_d();
        builder.func_225582_a_(right, bottom, z).func_225583_a_(uvTop, uvRight).func_181675_d();
        builder.func_225582_a_(left, bottom, z).func_225583_a_(uvLeft, uvRight).func_181675_d();
        builder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)builder);
    }
}

