/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import sonar.fluxnetworks.api.device.IFluxDevice;

public class PriorityGroup<T extends IFluxDevice> {
    public static final Comparator<PriorityGroup<?>> DESCENDING_ORDER = Comparator.comparingInt(p -> -p.getPriority());
    private final int priority;
    private final List<T> devices = new ArrayList<T>();

    private PriorityGroup(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public List<T> getDevices() {
        return this.devices;
    }

    @Nonnull
    public static <T extends IFluxDevice> PriorityGroup<T> getOrCreateGroup(int priority, @Nonnull List<PriorityGroup<T>> groups) {
        Optional<PriorityGroup> group = groups.stream().filter(g -> g.priority == priority).findFirst();
        if (!group.isPresent()) {
            PriorityGroup<T> newGroup = new PriorityGroup<T>(priority);
            groups.add(newGroup);
            return newGroup;
        }
        return group.get();
    }
}

