/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.integration.energy;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import sonar.fluxnetworks.api.energy.IFNEnergyStorage;
import sonar.fluxnetworks.api.energy.IItemEnergyHandler;
import sonar.fluxnetworks.api.energy.ITileEnergyHandler;
import sonar.fluxnetworks.api.misc.FluxCapabilities;
import sonar.fluxnetworks.common.misc.FluxUtils;

public class FNEnergyHandler
implements ITileEnergyHandler,
IItemEnergyHandler {
    public static final FNEnergyHandler INSTANCE = new FNEnergyHandler();

    private FNEnergyHandler() {
    }

    @Override
    public boolean hasCapability(@Nonnull TileEntity tile, @Nonnull Direction side) {
        return !tile.func_145837_r() && tile.getCapability(FluxCapabilities.FN_ENERGY_STORAGE, side).isPresent();
    }

    @Override
    public boolean canAddEnergy(@Nonnull TileEntity tile, @Nonnull Direction side) {
        IFNEnergyStorage storage;
        if (!tile.func_145837_r() && (storage = (IFNEnergyStorage)FluxUtils.get(tile.getCapability(FluxCapabilities.FN_ENERGY_STORAGE, side))) != null) {
            return storage.canReceiveL();
        }
        return false;
    }

    @Override
    public boolean canRemoveEnergy(@Nonnull TileEntity tile, @Nonnull Direction side) {
        IFNEnergyStorage storage;
        if (!tile.func_145837_r() && (storage = (IFNEnergyStorage)FluxUtils.get(tile.getCapability(FluxCapabilities.FN_ENERGY_STORAGE, side))) != null) {
            return storage.canExtractL();
        }
        return false;
    }

    @Override
    public long addEnergy(long amount, @Nonnull TileEntity tile, @Nonnull Direction side, boolean simulate) {
        IFNEnergyStorage storage = (IFNEnergyStorage)FluxUtils.get(tile.getCapability(FluxCapabilities.FN_ENERGY_STORAGE, side));
        return storage == null ? 0L : storage.receiveEnergyL(amount, simulate);
    }

    @Override
    public long removeEnergy(long amount, @Nonnull TileEntity tile, @Nonnull Direction side) {
        IFNEnergyStorage storage = (IFNEnergyStorage)FluxUtils.get(tile.getCapability(FluxCapabilities.FN_ENERGY_STORAGE, side));
        return storage == null ? 0L : storage.extractEnergyL(amount, false);
    }

    @Override
    public boolean hasCapability(@Nonnull ItemStack stack) {
        return stack.getCapability(FluxCapabilities.FN_ENERGY_STORAGE).isPresent();
    }

    @Override
    public boolean canAddEnergy(@Nonnull ItemStack stack) {
        IFNEnergyStorage storage = (IFNEnergyStorage)FluxUtils.get(stack.getCapability(FluxCapabilities.FN_ENERGY_STORAGE));
        return storage != null && storage.canReceiveL();
    }

    @Override
    public boolean canRemoveEnergy(@Nonnull ItemStack stack) {
        IFNEnergyStorage storage = (IFNEnergyStorage)FluxUtils.get(stack.getCapability(FluxCapabilities.FN_ENERGY_STORAGE));
        return storage != null && storage.canExtractL();
    }

    @Override
    public long addEnergy(long amount, @Nonnull ItemStack stack, boolean simulate) {
        IFNEnergyStorage storage = (IFNEnergyStorage)FluxUtils.get(stack.getCapability(FluxCapabilities.FN_ENERGY_STORAGE));
        return storage == null ? 0L : storage.receiveEnergyL(amount, simulate);
    }

    @Override
    public long removeEnergy(long amount, @Nonnull ItemStack stack) {
        IFNEnergyStorage storage = (IFNEnergyStorage)FluxUtils.get(stack.getCapability(FluxCapabilities.FN_ENERGY_STORAGE));
        return storage == null ? 0L : storage.extractEnergyL(amount, false);
    }
}

