/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.misc;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.energy.IItemEnergyHandler;
import sonar.fluxnetworks.api.energy.ITileEnergyHandler;
import sonar.fluxnetworks.common.integration.energy.FNEnergyHandler;
import sonar.fluxnetworks.common.integration.energy.ForgeEnergyHandler;

public class EnergyUtils {
    private static final List<ITileEnergyHandler> TILE_ENERGY_HANDLERS = new ArrayList<ITileEnergyHandler>();
    private static final List<Block> BLOCK_BLACKLIST = new ArrayList<Block>();
    private static final List<IItemEnergyHandler> ITEM_ENERGY_HANDLERS = new ArrayList<IItemEnergyHandler>();
    private static final List<Item> ITEM_BLACKLIST = new ArrayList<Item>();

    public static void reloadBlacklist() {
        BLOCK_BLACKLIST.clear();
        for (String str : FluxConfig.blockBlacklistStrings) {
            if (str.isEmpty()) continue;
            if (!str.contains(":")) {
                FluxNetworks.LOGGER.warn("BLACKLIST ERROR: " + str + " has incorrect formatting");
                continue;
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(str));
            if (block == null) continue;
            BLOCK_BLACKLIST.add(block);
        }
        ITEM_BLACKLIST.clear();
        for (String str : FluxConfig.itemBlackListStrings) {
            if (str.isEmpty()) continue;
            if (!str.contains(":")) {
                FluxNetworks.LOGGER.warn("BLACKLIST ERROR: " + str + " has incorrect formatting");
                continue;
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(str));
            if (item == null) continue;
            ITEM_BLACKLIST.add(item);
        }
        FluxNetworks.LOGGER.info("BLACKLIST RELOADED");
    }

    @Nullable
    public static ITileEnergyHandler getEnergyHandler(@Nullable TileEntity tile, @Nonnull Direction dir) {
        if (tile == null) {
            return null;
        }
        if (tile instanceof IFluxDevice) {
            return null;
        }
        if (BLOCK_BLACKLIST.contains(tile.func_195044_w().func_177230_c())) {
            return null;
        }
        for (ITileEnergyHandler handler : TILE_ENERGY_HANDLERS) {
            if (!handler.hasCapability(tile, dir)) continue;
            return handler;
        }
        return null;
    }

    public static boolean canRenderConnection(@Nullable TileEntity tile, @Nonnull Direction dir) {
        return EnergyUtils.getEnergyHandler(tile, dir) != null;
    }

    @Nullable
    public static IItemEnergyHandler getEnergyHandler(@Nullable ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.func_190926_b()) {
            return null;
        }
        if (ITEM_BLACKLIST.contains(stack.func_77973_b())) {
            return null;
        }
        for (IItemEnergyHandler handler : ITEM_ENERGY_HANDLERS) {
            if (!handler.hasCapability(stack)) continue;
            return handler;
        }
        return null;
    }

    static {
        TILE_ENERGY_HANDLERS.add(FNEnergyHandler.INSTANCE);
        ITEM_ENERGY_HANDLERS.add(FNEnergyHandler.INSTANCE);
        TILE_ENERGY_HANDLERS.add(ForgeEnergyHandler.INSTANCE);
        ITEM_ENERGY_HANDLERS.add(ForgeEnergyHandler.INSTANCE);
    }
}

