/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.blockcommands;

import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.extensions.IForgePacketBuffer;
import net.minecraftforge.fluids.FluidStack;

public interface ISerializer<T> {
    public Function<PacketBuffer, T> getDeserializer();

    public BiConsumer<PacketBuffer, T> getSerializer();

    public static class FluidStackSerializer
    implements ISerializer<FluidStack> {
        @Override
        public Function<PacketBuffer, FluidStack> getDeserializer() {
            return IForgePacketBuffer::readFluidStack;
        }

        @Override
        public BiConsumer<PacketBuffer, FluidStack> getSerializer() {
            return IForgePacketBuffer::writeFluidStack;
        }
    }

    public static class ItemStackSerializer
    implements ISerializer<ItemStack> {
        @Override
        public Function<PacketBuffer, ItemStack> getDeserializer() {
            return PacketBuffer::func_150791_c;
        }

        @Override
        public BiConsumer<PacketBuffer, ItemStack> getSerializer() {
            return PacketBuffer::func_150788_a;
        }
    }

    public static class BlockPosSerializer
    implements ISerializer<BlockPos> {
        @Override
        public Function<PacketBuffer, BlockPos> getDeserializer() {
            return PacketBuffer::func_179259_c;
        }

        @Override
        public BiConsumer<PacketBuffer, BlockPos> getSerializer() {
            return PacketBuffer::func_179255_a;
        }
    }

    public static class StringSerializer
    implements ISerializer<String> {
        @Override
        public Function<PacketBuffer, String> getDeserializer() {
            return buf -> buf.func_150789_c(Short.MAX_VALUE);
        }

        @Override
        public BiConsumer<PacketBuffer, String> getSerializer() {
            return PacketBuffer::func_180714_a;
        }
    }

    public static class IntegerSerializer
    implements ISerializer<Integer> {
        @Override
        public Function<PacketBuffer, Integer> getDeserializer() {
            return PacketBuffer::readInt;
        }

        @Override
        public BiConsumer<PacketBuffer, Integer> getSerializer() {
            return PacketBuffer::writeInt;
        }
    }
}

