/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.client.GuiTools;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GuiSideWindow;
import mcjty.lib.gui.IKeyReceiver;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.WindowTools;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.network.PacketSendServerCommand;
import mcjty.lib.network.PacketServerCommandTyped;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SafeClientTools;
import mcjty.lib.varia.Tools;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public abstract class GenericGuiContainer<T extends GenericTileEntity, C extends Container>
extends ContainerScreen<C>
implements IKeyReceiver {
    protected Window window;
    private WindowManager windowManager;
    protected final T tileEntity;
    private GuiSideWindow sideWindow;

    public void setWindowDimensions(int x, int y) {
        this.field_146999_f = x;
        this.field_147000_g = y;
    }

    public GenericGuiContainer(T tileEntity, C container, PlayerInventory inventory, ManualEntry manualEntry) {
        super(container, inventory, (ITextComponent)new StringTextComponent("test"));
        this.tileEntity = tileEntity;
        this.sideWindow = new GuiSideWindow(manualEntry.getManual(), manualEntry.getEntry(), manualEntry.getPage());
        this.windowManager = null;
    }

    public List<Rectangle2d> getExtraWindowBounds() {
        if (this.sideWindow.getWindow() == null || this.sideWindow.getWindow().getToplevel() == null) {
            Logging.getLogger().error((Object)new RuntimeException("Internal error! getExtraWindowBounds() called before initGui!"));
            return Collections.emptyList();
        }
        ArrayList<Rectangle2d> bounds = new ArrayList<Rectangle2d>();
        Rectangle r1 = this.sideWindow.getWindow().getToplevel().getBounds();
        bounds.add(new Rectangle2d(r1.x, r1.y, r1.width, r1.height));
        if (this.windowManager != null) {
            for (Window w : this.windowManager.getWindows()) {
                Rectangle r = w.getToplevel().getBounds();
                bounds.add(new Rectangle2d(r.x, r.y, r.width, r.height));
            }
        }
        return bounds;
    }

    public void func_231160_c_() {
        this.windowManager = null;
        super.func_231160_c_();
        this.sideWindow.initGui(this.field_230706_i_, (Screen)this, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
    }

    protected void registerWindows(WindowManager mgr) {
    }

    protected WindowManager getWindowManager() {
        if (this.windowManager == null) {
            if (this.sideWindow.getWindow() == null) {
                RuntimeException e = new RuntimeException("Internal error! getWindowManager() called before initGui!");
                Logging.getLogger().error((Object)e);
                throw e;
            }
            this.windowManager = new WindowManager((Screen)this);
            this.windowManager.addWindow(this.sideWindow.getWindow());
            this.windowManager.addWindow(this.window);
            this.registerWindows(this.windowManager);
        }
        return this.windowManager;
    }

    protected void func_230451_b_(@Nonnull MatrixStack matrixStack, int p_230451_2_, int p_230451_3_) {
        this.getWindowManager().drawTooltips(matrixStack);
    }

    public void drawHoveringText(MatrixStack matrixStack, List<String> textLines, List<ItemStack> items, int x, int y, FontRenderer font) {
        if (!textLines.isEmpty()) {
            matrixStack.func_227860_a_();
            RenderSystem.disableRescaleNormal();
            net.minecraft.client.renderer.RenderHelper.func_74518_a();
            RenderSystem.disableLighting();
            RenderSystem.disableDepthTest();
            int i = 0;
            int linesWithItemStacks = 0;
            for (String s : textLines) {
                int j;
                if (s != null && items != null && s.contains("@") && !items.isEmpty()) {
                    List<Object> list = WindowTools.parseString(s, items);
                    boolean lineHasItemStacks = false;
                    j = 0;
                    for (Object o : list) {
                        if (o instanceof String) {
                            j += font.func_78256_a((String)o);
                            continue;
                        }
                        j += 20;
                        lineHasItemStacks = true;
                    }
                    if (lineHasItemStacks) {
                        ++linesWithItemStacks;
                    }
                } else {
                    j = font.func_78256_a(s);
                }
                if (j <= i) continue;
                i = j;
            }
            int xx = x + 12;
            int yy = y - 12;
            int k = 8;
            if (textLines.size() > 1) {
                k += 2 + (textLines.size() - 1) * 10 + linesWithItemStacks * 8;
            }
            if (xx > this.field_230708_k_ - this.field_147003_i - i - 5) {
                xx -= 28 + i;
            }
            if (xx < 4 - this.field_147003_i) {
                xx = 4 - this.field_147003_i;
            }
            if (yy > this.field_230709_l_ - this.field_147009_r - k - 4) {
                yy = this.field_230709_l_ - this.field_147009_r - k - 4;
            } else if (yy < 4 - this.field_147009_r) {
                yy = 4 - this.field_147009_r;
            }
            this.func_230926_e_(300);
            this.field_230707_j_.field_77023_b = 300.0f;
            int l = -267386864;
            this.func_238468_a_(matrixStack, xx - 3, yy - 4, xx + i + 3, yy - 3, l, l);
            this.func_238468_a_(matrixStack, xx - 3, yy + k + 3, xx + i + 3, yy + k + 4, l, l);
            this.func_238468_a_(matrixStack, xx - 3, yy - 3, xx + i + 3, yy + k + 3, l, l);
            this.func_238468_a_(matrixStack, xx - 4, yy - 3, xx - 3, yy + k + 3, l, l);
            this.func_238468_a_(matrixStack, xx + i + 3, yy - 3, xx + i + 4, yy + k + 3, l, l);
            int i1 = 0x505000FF;
            int j1 = (i1 & 0xFEFEFE) >> 1 | i1 & 0xFF000000;
            this.func_238468_a_(matrixStack, xx - 3, yy - 3 + 1, xx - 3 + 1, yy + k + 3 - 1, i1, j1);
            this.func_238468_a_(matrixStack, xx + i + 2, yy - 3 + 1, xx + i + 3, yy + k + 3 - 1, i1, j1);
            this.func_238468_a_(matrixStack, xx - 3, yy - 3, xx + i + 3, yy - 3 + 1, i1, i1);
            this.func_238468_a_(matrixStack, xx - 3, yy + k + 2, xx + i + 3, yy + k + 3, j1, j1);
            RenderSystem.translated((double)0.0, (double)0.0, (double)this.field_230707_j_.field_77023_b);
            this.renderTextLines(matrixStack, textLines, items, font, xx, yy);
            this.func_230926_e_(0);
            this.field_230707_j_.field_77023_b = 0.0f;
            RenderSystem.enableLighting();
            RenderSystem.enableDepthTest();
            net.minecraft.client.renderer.RenderHelper.func_227780_a_();
            RenderSystem.enableRescaleNormal();
            matrixStack.func_227865_b_();
        }
    }

    private void renderTextLines(MatrixStack matrixStack, List<String> textLines, List<ItemStack> items, FontRenderer font, int xx, int yy) {
        for (int i = 0; i < textLines.size(); ++i) {
            String s1 = textLines.get(i);
            if (s1 != null && items != null && s1.contains("@") && !items.isEmpty()) {
                List<Object> list = WindowTools.parseString(s1, items);
                int curx = xx;
                boolean lineHasItemStacks = false;
                for (Object o : list) {
                    if (o instanceof String) {
                        String s2 = (String)o;
                        font.func_238405_a_(matrixStack, s2, (float)curx, (float)yy, -1);
                        curx += font.func_78256_a(s2);
                        continue;
                    }
                    RenderHelper.renderObject(matrixStack, curx + 1, yy, o, false);
                    curx += 20;
                    lineHasItemStacks = true;
                }
                if (lineHasItemStacks) {
                    yy += 8;
                }
            } else {
                font.func_238405_a_(matrixStack, s1, (float)xx, (float)yy, -1);
            }
            if (i == 0) {
                yy += 2;
            }
            yy += 10;
        }
    }

    protected void func_230450_a_(@Nonnull MatrixStack matrixStack, float partialTicks, int x, int y) {
        this.drawWindow(matrixStack);
    }

    protected void drawWindow(MatrixStack matrixStack) {
        if (this.window == null) {
            return;
        }
        this.func_230446_a_(matrixStack);
        this.getWindowManager().syncBindings(this.tileEntity);
        this.getWindowManager().draw(matrixStack);
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.window == null) {
            return;
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        this.drawStackTooltips(matrixStack, mouseX, mouseY);
    }

    public void func_238746_a_(@Nonnull MatrixStack matrixStack, @Nonnull Slot slot) {
        if (!this.isPartiallyCoveredByModalWindow(slot)) {
            super.func_238746_a_(matrixStack, slot);
        }
    }

    @Nullable
    public Slot getSlotUnderMouse() {
        Slot slot = super.getSlotUnderMouse();
        if (slot == null) {
            return null;
        }
        if (this.isPartiallyCoveredByModalWindow(slot)) {
            return null;
        }
        return slot;
    }

    public boolean func_195362_a(@Nonnull Slot slotIn, double mouseX, double mouseY) {
        if (this.isPartiallyCoveredByModalWindow(slotIn)) {
            return false;
        }
        return super.func_195362_a(slotIn, mouseX, mouseY);
    }

    private boolean isPartiallyCoveredByModalWindow(Slot slotIn) {
        int xPos = slotIn.field_75223_e + this.window.getToplevel().getBounds().x;
        int yPos = slotIn.field_75221_f + this.window.getToplevel().getBounds().y;
        return this.getWindowManager().getModalWindows().anyMatch(window -> window.getToplevel().getBounds().intersects(new Rectangle(xPos, yPos, 18, 18)));
    }

    protected void drawStackTooltips(MatrixStack matrixStack, int mouseX, int mouseY) {
        BlockRender blockRender;
        Object renderItem;
        ItemStack itemStack;
        int x = GuiTools.getRelativeX(this.window.getGui());
        int y = GuiTools.getRelativeY(this.window.getGui());
        Widget<?> widget = this.window.getToplevel().getWidgetAtPosition(x, y);
        if (widget instanceof BlockRender && !(itemStack = (renderItem = (blockRender = (BlockRender)widget).getRenderItem()) instanceof ItemStack ? (ItemStack)renderItem : (renderItem instanceof Block ? new ItemStack((IItemProvider)((Block)renderItem)) : (renderItem instanceof Item ? new ItemStack((IItemProvider)((Item)renderItem)) : ItemStack.field_190927_a))).func_190926_b()) {
            this.customRenderToolTip(matrixStack, blockRender, itemStack, mouseX, mouseY);
        }
    }

    protected List<ITextComponent> addCustomLines(List<ITextComponent> oldList, BlockRender blockRender, ItemStack stack) {
        return oldList;
    }

    protected void customRenderToolTip(MatrixStack matrixStack, BlockRender blockRender, ItemStack stack, int x, int y) {
        List<Object> list;
        if (stack.func_77973_b() == null) {
            list = new ArrayList<ITextComponent>();
        } else {
            ITooltipFlag.TooltipFlags flag = this.getMinecraft().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
            list = stack.func_82840_a((PlayerEntity)this.getMinecraft().field_71439_g, (ITooltipFlag)flag);
        }
        list = this.addCustomLines(list, blockRender, stack);
        FontRenderer font = null;
        stack.func_77973_b();
        font = stack.func_77973_b().getFontRenderer(stack);
        GuiUtils.preItemToolTip((ItemStack)stack);
        GuiUtils.drawHoveringText((MatrixStack)matrixStack, list, (int)x, (int)y, (int)this.field_146999_f, (int)this.field_147000_g, (int)-1, (FontRenderer)(font == null ? this.getMinecraft().field_71466_p : font));
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.getMinecraft().field_195559_v.func_197967_a(false);
    }

    public boolean func_231044_a_(double x, double y, int button) {
        boolean rc = super.func_231044_a_(x, y, button);
        if (this.window != null) {
            this.getWindowManager().mouseClicked(x, y, button);
        }
        return rc;
    }

    public boolean func_231045_a_(double x, double y, int button, double scaledX, double scaledY) {
        boolean rc = super.func_231045_a_(x, y, button, scaledX, scaledY);
        if (this.window != null) {
            this.getWindowManager().mouseDragged(x, y, button);
        }
        return rc;
    }

    public boolean func_231043_a_(double x, double y, double amount) {
        boolean rc = super.func_231043_a_(x, y, amount);
        if (this.window != null) {
            this.getWindowManager().mouseScrolled(x, y, amount);
        }
        return false;
    }

    public boolean func_231048_c_(double x, double y, int button) {
        boolean rc = super.func_231048_c_(x, y, button);
        if (this.window != null) {
            this.getWindowManager().mouseReleased(x, y, button);
        }
        return rc;
    }

    @Override
    public Window getWindow() {
        return this.window;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        boolean b;
        boolean bl = b = this.window == null || this.getWindowManager().keyTyped(keyCode, scanCode);
        if (b) {
            return super.func_231046_a_(keyCode, scanCode, modifiers);
        }
        return false;
    }

    @Override
    public boolean mouseClickedFromEvent(double x, double y, int button) {
        WindowManager manager = this.getWindow().getWindowManager();
        manager.mouseClicked(x, y, button);
        return true;
    }

    @Override
    public boolean mouseReleasedFromEvent(double x, double y, int button) {
        WindowManager manager = this.getWindow().getWindowManager();
        manager.mouseReleased(x, y, button);
        return true;
    }

    @Override
    public boolean mouseScrolledFromEvent(double x, double y, double amount) {
        WindowManager manager = this.getWindow().getWindowManager();
        manager.mouseScrolled(x, y, amount);
        return true;
    }

    @Override
    public void keyTypedFromEvent(int keyCode, int scanCode) {
        if (this.window != null && this.getWindowManager().keyTyped(keyCode, scanCode)) {
            super.func_231046_a_(keyCode, scanCode, 0);
        }
    }

    @Override
    public void charTypedFromEvent(char codePoint) {
        if (this.window == null || this.getWindowManager().charTyped(codePoint)) {
            // empty if block
        }
    }

    public <T> void setValue(SimpleChannel channel, Value<?, T> value, T v) {
        this.sendServerCommandTyped(channel, ((GenericTileEntity)((Object)this.tileEntity)).getDimension(), GenericTileEntity.COMMAND_SYNC_BINDING.getName(), TypedMap.builder().put(value.getKey(), v).build());
    }

    public void sendServerCommandTyped(SimpleChannel network, String command, TypedMap params) {
        network.sendToServer((Object)new PacketServerCommandTyped(this.tileEntity.func_174877_v(), ((GenericTileEntity)((Object)this.tileEntity)).getDimension(), command, params));
    }

    public void sendServerCommandTyped(SimpleChannel network, Command<?> command, TypedMap params) {
        network.sendToServer((Object)new PacketServerCommandTyped(this.tileEntity.func_174877_v(), ((GenericTileEntity)((Object)this.tileEntity)).getDimension(), command.getName(), params));
    }

    public void sendServerCommandTyped(SimpleChannel network, RegistryKey<World> dimensionId, String command, TypedMap params) {
        network.sendToServer((Object)new PacketServerCommandTyped(this.tileEntity.func_174877_v(), dimensionId, command, params));
    }

    public void sendServerCommand(SimpleChannel network, String modid, String command, @Nonnull TypedMap arguments) {
        network.sendToServer((Object)new PacketSendServerCommand(modid, command, arguments));
    }

    public void sendServerCommand(SimpleChannel network, String modid, String command) {
        network.sendToServer((Object)new PacketSendServerCommand(modid, command, TypedMap.EMPTY));
    }

    public static <C extends GenericContainer, S extends GenericGuiContainer<T, C>, T extends GenericTileEntity> void register(ContainerType<C> type, GuiSupplier<C, S, T> guiSupplier) {
        ScreenManager.IScreenFactory factory = (container, inventory, title) -> {
            TileEntity te = SafeClientTools.getClientWorld().func_175625_s(container.getPos());
            return Tools.safeMap(te, tile -> guiSupplier.create(tile, container, inventory), "Invalid tile entity!");
        };
        ScreenManager.func_216911_a(type, (ScreenManager.IScreenFactory)factory);
    }

    protected void updateEnergyBar(EnergyBar energyBar) {
        this.tileEntity.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> {
            energyBar.maxValue(((GenericEnergyStorage)e).getCapacity());
            energyBar.value(((GenericEnergyStorage)e).getEnergy());
        });
    }

    @FunctionalInterface
    public static interface GuiSupplier<C extends GenericContainer, S extends GenericGuiContainer, T extends GenericTileEntity> {
        public S create(T var1, C var2, PlayerInventory var3);
    }
}

