/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.stream.Collectors;
import mcjty.lib.client.GuiTools;
import mcjty.lib.gui.GuiSideWindow;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.gui.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class GuiItemScreen
extends Screen {
    protected SimpleChannel network;
    protected Window window;
    protected int xSize;
    protected int ySize;
    protected int guiLeft;
    protected int guiTop;
    private GuiSideWindow sideWindow;

    public GuiItemScreen(SimpleChannel network, int xSize, int ySize, ManualEntry manualEntry) {
        super((ITextComponent)new StringTextComponent("todo"));
        this.network = network;
        this.xSize = xSize;
        this.ySize = ySize;
        this.sideWindow = new GuiSideWindow(manualEntry.getManual(), manualEntry.getEntry(), manualEntry.getPage());
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.guiLeft = (this.field_230708_k_ - this.xSize) / 2;
        this.guiTop = (this.field_230709_l_ - this.ySize) / 2;
        this.sideWindow.initGui(this.getMinecraft(), this, this.guiLeft, this.guiTop, this.xSize, this.ySize);
    }

    public boolean func_231044_a_(double x, double y, int button) {
        boolean rc = super.func_231044_a_(x, y, button);
        this.window.mouseClicked(x, y, button);
        this.sideWindow.getWindow().mouseClicked(x, y, button);
        return rc;
    }

    public boolean func_231045_a_(double x, double y, int button, double scaledX, double scaledY) {
        boolean rc = super.func_231045_a_(x, y, button, scaledX, scaledY);
        this.window.mouseDragged(x, y, button);
        this.sideWindow.getWindow().mouseDragged(x, y, button);
        return rc;
    }

    public boolean func_231043_a_(double x, double y, double amount) {
        boolean rc = super.func_231043_a_(x, y, amount);
        this.window.mouseScrolled(x, y, amount);
        this.sideWindow.getWindow().mouseScrolled(x, y, amount);
        return rc;
    }

    public boolean func_231048_c_(double x, double y, int state) {
        boolean rc = super.func_231048_c_(x, y, state);
        this.window.mouseReleased(x, y, state);
        this.sideWindow.getWindow().mouseReleased(x, y, state);
        return rc;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        boolean rc = super.func_231046_a_(keyCode, scanCode, modifiers);
        this.window.keyTyped(keyCode, scanCode);
        return rc;
    }

    public void drawWindow(MatrixStack matrixStack) {
        List processors;
        List properties;
        int y;
        int x;
        this.func_230446_a_(matrixStack);
        this.window.draw(matrixStack);
        this.sideWindow.getWindow().draw(matrixStack);
        List<String> tooltips = this.window.getTooltips();
        Minecraft mc = this.getMinecraft();
        if (tooltips != null) {
            x = GuiTools.getRelativeX(this);
            y = GuiTools.getRelativeY(this);
            properties = tooltips.stream().map(StringTextComponent::new).collect(Collectors.toList());
            processors = LanguageMap.func_74808_a().func_244260_a(properties);
            this.func_238654_b_(matrixStack, processors, x - this.guiLeft, y - this.guiTop);
        }
        if ((tooltips = this.sideWindow.getWindow().getTooltips()) != null) {
            x = GuiTools.getRelativeX(this);
            y = GuiTools.getRelativeY(this);
            properties = tooltips.stream().map(StringTextComponent::new).collect(Collectors.toList());
            processors = LanguageMap.func_74808_a().func_244260_a(properties);
            this.func_238654_b_(matrixStack, processors, x - this.guiLeft, y - this.guiTop);
        }
    }
}

