/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.gui.GuiParser;
import mcjty.lib.gui.events.BlockRenderEvent;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.ItemStackTools;
import net.minecraft.block.Block;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockRender
extends AbstractWidget<BlockRender> {
    public static final String TYPE_BLOCKRENDER = "blockrender";
    public static final int DEFAULT_OFFSET = 0;
    public static final boolean DEFAULT_HILIGHT_ON_HOVER = false;
    public static final boolean DEFAULT_SHOW_LABEL = false;
    private Object renderItem = null;
    private int offsetX = 0;
    private int offsetY = 0;
    private long prevTime = -1L;
    private boolean hilightOnHover = false;
    private boolean showLabel = false;
    private Integer labelColor = null;
    private List<BlockRenderEvent> selectionEvents = null;

    public Object getRenderItem() {
        return this.renderItem;
    }

    public BlockRender renderItem(Object renderItem) {
        this.renderItem = renderItem;
        return this;
    }

    public BlockRender() {
        this.desiredHeight(16);
        this.desiredWidth(16);
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public BlockRender showLabel(boolean showLabel) {
        this.showLabel = showLabel;
        return this;
    }

    public int getLabelColor() {
        return this.labelColor == null ? StyleConfig.colorTextNormal : this.labelColor;
    }

    public BlockRender labelColor(int labelColor) {
        this.labelColor = labelColor;
        return this;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public BlockRender offsetX(int offsetX) {
        this.offsetX = offsetX;
        return this;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public BlockRender offsetY(int offsetY) {
        this.offsetY = offsetY;
        return this;
    }

    public boolean isHilightOnHover() {
        return this.hilightOnHover;
    }

    public BlockRender hilightOnHover(boolean hilightOnHover) {
        this.hilightOnHover = hilightOnHover;
        return this;
    }

    @Override
    public void draw(Screen gui, MatrixStack matrixStack, int x, int y) {
        if (!this.visible) {
            return;
        }
        if (this.showLabel) {
            this.drawBackground(gui, matrixStack, x, y, this.bounds.height, this.bounds.height);
        } else {
            super.draw(gui, matrixStack, x, y);
        }
        if (this.renderItem != null) {
            int xx = x + this.bounds.x + this.offsetX;
            int yy = y + this.bounds.y + this.offsetY;
            this.mc.func_175599_af().field_77023_b = 100.0f;
            this.window.getGui().func_230926_e_(100);
            RenderHelper.renderObject(matrixStack, xx, yy, this.renderItem, false);
            this.mc.func_175599_af().field_77023_b = 0.0f;
            this.window.getGui().func_230926_e_(0);
            if (this.hilightOnHover && this.isHovering()) {
                RenderSystem.disableLighting();
                RenderSystem.disableDepthTest();
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                RenderHelper.drawVerticalGradientRect(xx, yy, xx + 16, yy + 16, -2130706433, -2130706433);
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                RenderSystem.enableDepthTest();
            }
            if (this.showLabel) {
                String name = this.renderItem instanceof ItemStack ? ((ItemStack)this.renderItem).func_200301_q().getString() : (this.renderItem instanceof FluidStack ? ((FluidStack)this.renderItem).getDisplayName().getString() : (this.renderItem instanceof Item ? new ItemStack((IItemProvider)((Item)this.renderItem)).func_200301_q().getString() : (this.renderItem instanceof Block ? new ItemStack((IItemProvider)((Block)this.renderItem)).func_200301_q().getString() : "")));
                Objects.requireNonNull(this.mc.field_71466_p);
                int h = 9;
                int dy = (this.bounds.height - h) / 2;
                this.mc.field_71466_p.func_238421_b_(matrixStack, name, (float)(xx + 20), (float)(yy + dy), this.getLabelColor());
            }
        }
    }

    @Override
    public Widget<?> mouseClick(double x, double y, int button) {
        if (this.isEnabledAndVisible()) {
            this.fireSelectionEvents();
            long t = System.currentTimeMillis();
            if (this.prevTime != -1L && t - this.prevTime < 250L) {
                this.fireDoubleClickEvent();
            }
            this.prevTime = t;
            return this;
        }
        return null;
    }

    public BlockRender event(BlockRenderEvent event) {
        if (this.selectionEvents == null) {
            this.selectionEvents = new ArrayList<BlockRenderEvent>();
        }
        this.selectionEvents.add(event);
        return this;
    }

    public void removeSelectionEvent(BlockRenderEvent event) {
        if (this.selectionEvents != null) {
            this.selectionEvents.remove(event);
        }
    }

    private void fireSelectionEvents() {
        this.fireChannelEvents("select");
        if (this.selectionEvents != null) {
            for (BlockRenderEvent event : this.selectionEvents) {
                event.select();
            }
        }
    }

    private void fireDoubleClickEvent() {
        this.fireChannelEvents("doubleclick");
        if (this.selectionEvents != null) {
            for (BlockRenderEvent event : this.selectionEvents) {
                event.doubleClick();
            }
        }
    }

    @Override
    public void readFromGuiCommand(GuiParser.GuiCommand command) {
        super.readFromGuiCommand(command);
        command.findCommand("offset").ifPresent(cmd -> {
            this.offsetX = cmd.getOptionalPar(0, 0);
            this.offsetY = cmd.getOptionalPar(1, 0);
        });
        this.hilightOnHover = GuiParser.get(command, "highlighthover", false);
        this.showLabel = GuiParser.get(command, "showlabel", false);
        this.labelColor = GuiParser.get(command, "labelColor", null);
        command.findCommand("render").ifPresent(cmd -> {
            this.renderItem = ItemStackTools.guiCommandToItemStack(cmd);
        });
    }

    @Override
    public void fillGuiCommand(GuiParser.GuiCommand command) {
        super.fillGuiCommand(command);
        if (this.offsetX != 0 || this.offsetY != 0) {
            command.command(new GuiParser.GuiCommand("offset").parameter(this.offsetX).parameter(this.offsetY));
        }
        GuiParser.put(command, "highlighthover", this.hilightOnHover, false);
        GuiParser.put(command, "showlabel", this.showLabel, false);
        GuiParser.put(command, "labelColor", this.labelColor, null);
        if (this.renderItem != null && this.renderItem instanceof ItemStack) {
            command.command(ItemStackTools.itemStackToGuiCommand("render", (ItemStack)this.renderItem));
        }
    }

    @Override
    public GuiParser.GuiCommand createGuiCommand() {
        return new GuiParser.GuiCommand(TYPE_BLOCKRENDER);
    }

    @Override
    public <T> void setGenericValue(T value) {
        if (value == null) {
            this.renderItem(null);
        } else {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(value.toString()));
            if (item != null) {
                this.renderItem(new ItemStack((IItemProvider)item));
            } else {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(value.toString()));
                if (block != null) {
                    this.renderItem(new ItemStack((IItemProvider)block));
                } else {
                    this.renderItem(null);
                }
            }
        }
    }

    @Override
    public Object getGenericValue(Type<?> type) {
        if (this.renderItem instanceof ItemStack) {
            return ((ItemStack)this.renderItem).func_77973_b().getRegistryName().toString();
        }
        return null;
    }
}

