/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;

public class BlockTools {
    public static String writeBlockState(BlockState tag) {
        StringBuilder builder = new StringBuilder(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)tag.func_177230_c()).toString());
        ImmutableMap properties = tag.func_206871_b();
        if (!properties.isEmpty()) {
            int c = 64;
            for (Map.Entry entry : properties.entrySet()) {
                Property property = (Property)entry.getKey();
                builder.append((char)c);
                c = 44;
                builder.append(property.func_177701_a());
                builder.append('=');
                builder.append(BlockTools.getName(property, (Comparable)entry.getValue()));
            }
        }
        return builder.toString();
    }

    private static <T extends Comparable<T>> String getName(Property<T> property, Comparable<?> cmp) {
        return property.func_177702_a(cmp);
    }

    public static BlockState readBlockState(String s) {
        String properties;
        String blockName;
        if (s.contains("@")) {
            String[] split = StringUtils.split((String)s, (char)'@');
            blockName = split[0];
            properties = split[1];
        } else {
            blockName = s;
            properties = null;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
        if (block == null) {
            throw new RuntimeException("Cannot find block '" + blockName + "'!");
        }
        BlockState state = block.func_176223_P();
        if (properties != null) {
            String[] split;
            StateContainer statecontainer = state.func_177230_c().func_176194_O();
            for (String pv : split = StringUtils.split((String)properties, (char)',')) {
                String[] sp = StringUtils.split((String)pv, (char)'=');
                Property property = statecontainer.func_185920_a(sp[0]);
                if (property == null) continue;
                state = BlockTools.setValueHelper(state, property, sp[1]);
            }
        }
        return state;
    }

    private static <T extends Comparable<T>> BlockState setValueHelper(BlockState state, Property<T> property, String value) {
        Optional optional = property.func_185929_b(value);
        if (optional.isPresent()) {
            return (BlockState)state.func_206870_a(property, (Comparable)optional.get());
        }
        return state;
    }
}

