/*
 * Decompiled with CFR 0.152.
 */
package com.rolfmao.upgradednetherite.handlers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.rolfmao.upgradednetherite.config.UpgradedNetheriteConfig;
import com.rolfmao.upgradednetherite.handlers.PlayerFallDistanceUpdateHandler;
import com.rolfmao.upgradednetherite.init.UpgradedNetheriteEffects;
import com.rolfmao.upgradednetherite.utils.ArmorUtil;
import com.rolfmao.upgradednetherite.utils.DurabilityUtil;
import com.rolfmao.upgradednetherite.utils.EntityDataUtil;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="upgradednetherite", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ArmorEventHandler {
    private Multimap<Attribute, AttributeModifier> SwimAttributeMap() {
        HashMultimap attributesDefault = HashMultimap.create();
        attributesDefault.put((Object)ForgeMod.SWIM_SPEED.get(), (Object)new AttributeModifier(UUID.fromString("fbfd69fe-3369-11eb-adc1-0242ac120002"), "upgradednetherite:swim_bonus", 1.1, AttributeModifier.Operation.MULTIPLY_BASE));
        return attributesDefault;
    }

    private Multimap<Attribute, AttributeModifier> HealthAttributeMap(Integer mult) {
        HashMultimap attributesDefault = HashMultimap.create();
        attributesDefault.put((Object)Attributes.field_233818_a_, (Object)new AttributeModifier(UUID.fromString("7d87fb9e-d0ca-4bdd-8d00-384044b3417b"), "upgradednetherite:health_malus", (double)UpgradedNetheriteConfig.HealthMalus * -0.01 * (double)mult.intValue(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        return attributesDefault;
    }

    private Multimap<Attribute, AttributeModifier> LuckAttributeMap() {
        HashMultimap attributesDefault = HashMultimap.create();
        attributesDefault.put((Object)Attributes.field_233828_k_, (Object)new AttributeModifier(UUID.fromString("33ca3756-9ea8-41d0-898c-d93352065fbb"), "upgradednetherite:luck_bonus", (double)UpgradedNetheriteConfig.LuckBonus, AttributeModifier.Operation.ADDITION));
        return attributesDefault;
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (ArmorUtil.isWearingGoldArmor(player) && UpgradedNetheriteConfig.EnableLuckBonus) {
                player.func_233645_dx_().func_233793_b_(this.LuckAttributeMap());
            } else if (!ArmorUtil.isWearingGoldArmor(player)) {
                player.func_233645_dx_().func_233785_a_(this.LuckAttributeMap());
            }
            if (ArmorUtil.isWearingFeatherArmor(player) && (player.field_70170_p.func_204610_c(player.getEntity().func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206960_b) || player.field_70170_p.func_204610_c(player.getEntity().func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206959_a)) && !player.func_213453_ef() && !player.func_203007_ba() && !player.func_184613_cA() && UpgradedNetheriteConfig.EnableWaterLavaWalking && !player.field_71075_bZ.field_75100_b) {
                if (player.func_70090_H() || player.func_180799_ab()) {
                    if (!ArmorUtil.isWearingWaterArmor(player) && player.func_213322_ci().field_72448_b < 0.226 && player.func_213322_ci().field_72448_b > 0.11 && (player.func_208600_a((ITag)FluidTags.field_206960_b) || player.func_208600_a((ITag)FluidTags.field_206959_a)) && player.field_70170_p.field_72995_K && player instanceof ClientPlayerEntity && ((ClientPlayerEntity)player).field_71158_b.field_78901_c) {
                        player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, (player.func_213322_ci().field_72448_b + 1.0) * 0.015, 0.0));
                    } else if (player.func_213322_ci().field_72448_b < 0.15 && !player.func_208600_a((ITag)FluidTags.field_206960_b) && !player.func_208600_a((ITag)FluidTags.field_206959_a)) {
                        player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, 0.15 - player.func_213322_ci().field_72448_b, 0.0));
                    }
                } else {
                    player.field_70143_R = 0.0f;
                    player.func_230245_c_(true);
                    player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, -player.func_213322_ci().func_82617_b(), 0.0));
                    if (player.field_70170_p.func_204610_c(player.getEntity().func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206960_b) && UpgradedNetheriteConfig.EnableLavaDamageDurabilityFeatherArmor) {
                        DurabilityUtil.FeatherDurabilityLoss(player);
                    }
                    if (player.field_70170_p.func_204610_c(player.getEntity().func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206959_a) && UpgradedNetheriteConfig.EnableWaterDamageDurabilityFeatherArmor) {
                        DurabilityUtil.FeatherDurabilityLoss(player);
                    }
                }
            }
            if (player.field_70170_p.field_72995_K && ArmorUtil.isWearingFeatherArmor(player) && (player.func_233570_aj_() || EntityDataUtil.getAbilityClimbwall((Entity)player)) && !EntityDataUtil.getAbilityMultiJump((Entity)player) && UpgradedNetheriteConfig.EnableMultiJump) {
                EntityDataUtil.setAbilityMultiJump((Entity)player, true);
            } else if (player.field_70170_p.field_72995_K && player instanceof ClientPlayerEntity && ((ClientPlayerEntity)player).field_71158_b.field_78901_c && ArmorUtil.isWearingFeatherArmor(player) && !player.field_71075_bZ.field_75101_c && !player.func_70090_H() && !player.func_180799_ab() && !player.func_70617_f_() && player.func_213322_ci().field_72448_b < 0.0 && EntityDataUtil.getAbilityMultiJump((Entity)player) && UpgradedNetheriteConfig.EnableMultiJump) {
                player.field_70143_R = 0.0f;
                PlayerFallDistanceUpdateHandler.PlayerFallDistanceUpdate(player.func_110124_au(), Float.valueOf(player.field_70143_R));
                player.func_70664_aZ();
                EntityDataUtil.decreaseAbilityMultiJump((Entity)player);
            } else if (!(ArmorUtil.isWearingFeatherArmor(player) && UpgradedNetheriteConfig.EnableMultiJump || !EntityDataUtil.getAbilityMultiJump((Entity)player))) {
                EntityDataUtil.setAbilityMultiJump((Entity)player, false);
            }
            if (ArmorUtil.intWearingCorrupt(player, true) < 1 && !player.func_70644_a((Effect)UpgradedNetheriteEffects.NETHERITE_CORRUPTION.get()) || !UpgradedNetheriteConfig.EnableHealthMalus) {
                player.func_233645_dx_().func_233785_a_(this.HealthAttributeMap(0));
            } else if (ArmorUtil.intWearingCorrupt(player, true) >= 1 || player.func_70644_a((Effect)UpgradedNetheriteEffects.NETHERITE_CORRUPTION.get())) {
                if (player.func_70644_a((Effect)UpgradedNetheriteEffects.NETHERITE_CORRUPTION.get())) {
                    player.func_233645_dx_().func_233793_b_(this.HealthAttributeMap(ArmorUtil.intWearingCorrupt(player, true) + (player.func_70660_b((Effect)UpgradedNetheriteEffects.NETHERITE_CORRUPTION.get()).func_76458_c() + 1)));
                } else {
                    player.func_233645_dx_().func_233793_b_(this.HealthAttributeMap(ArmorUtil.intWearingCorrupt(player, true)));
                }
            }
            if (EntityDataUtil.getMalusCorruption((Entity)player) > 0 && !player.func_70644_a((Effect)UpgradedNetheriteEffects.NETHERITE_CORRUPTION.get())) {
                EntityDataUtil.setMalusCorruption((Entity)player, 0);
                EntityDataUtil.setCorrupterite((Entity)player, ArmorUtil.intWearingCorrupt(player, false));
            }
            if (ArmorUtil.isWearingEnderArmor(player)) {
                BlockPos blockpos1 = player.getEntity().func_233580_cy_().func_177977_b();
                BlockState blockstate = player.field_70170_p.func_180495_p(blockpos1);
                if (blockstate.func_185904_a().func_76230_c()) {
                    EntityDataUtil.setAbilityEnderPos((Entity)player, true);
                }
            } else if (!ArmorUtil.isWearingEnderArmor(player) && EntityDataUtil.getAbilityEnderPos((Entity)player) != null) {
                EntityDataUtil.setAbilityEnderPos((Entity)player, false);
            }
            if (ArmorUtil.isWearingWaterArmor(player) && UpgradedNetheriteConfig.EnableWaterBreath && player.func_70086_ai() < player.func_205010_bg()) {
                player.func_70050_g(player.func_70086_ai() + 4);
                DurabilityUtil.WaterDurabilityLoss(player);
            }
            if (ArmorUtil.isWearingPhantomArmor(player) && UpgradedNetheriteConfig.EnableStepHeight) {
                if (player.field_70138_W < 1.0f) {
                    EntityDataUtil.setAbilityStepHeight((Entity)player, true);
                    player.field_70138_W = 1.0f;
                }
            } else if (EntityDataUtil.getAbilityStepHeight((Entity)player) && player.field_70138_W > 0.6f) {
                player.field_70138_W = 0.6f;
                EntityDataUtil.setAbilityStepHeight((Entity)player, false);
            }
            if (ArmorUtil.intWearingCorrupt(player, false) > 0) {
                DurabilityUtil.CorruptDurabilityGain(player);
            }
            if (ArmorUtil.isWearingFireArmor(player) && UpgradedNetheriteConfig.EnableLavaSpeed && player.func_180799_ab() && !player.field_71075_bZ.field_75100_b) {
                player.func_213317_d(player.func_213322_ci().func_216372_d((double)1.66f, 1.0, (double)1.66f));
            }
            if (ArmorUtil.isWearingWaterArmor(player) && UpgradedNetheriteConfig.EnableWaterSpeed) {
                player.func_233645_dx_().func_233793_b_(this.SwimAttributeMap());
            } else if (!ArmorUtil.isWearingWaterArmor(player)) {
                player.func_233645_dx_().func_233785_a_(this.SwimAttributeMap());
            }
            if (UpgradedNetheriteConfig.EnableClimbWall && ArmorUtil.isWearingPoisonArmor(player)) {
                if (!player.func_213453_ef() && EntityDataUtil.getAbilityClimbwall((Entity)player)) {
                    if (player.func_213322_ci().func_82617_b() < 0.0) {
                        player.func_230245_c_(true);
                        player.func_213317_d(player.func_213322_ci().func_72441_c(-player.func_213322_ci().func_82615_a() / 5.0, -player.func_213322_ci().func_82617_b(), -player.func_213322_ci().func_82616_c() / 5.0));
                        player.field_70143_R = 0.0f;
                    }
                    if (player.func_213322_ci().func_82615_a() != 0.0 && player.func_213322_ci().func_82616_c() != 0.0) {
                        EntityDataUtil.setAbilityClimbwall((Entity)player, false);
                    }
                }
                if ((player.func_213453_ef() || player.func_70617_f_()) && EntityDataUtil.getAbilityClimbwall((Entity)player)) {
                    EntityDataUtil.setAbilityClimbwall((Entity)player, false);
                }
                if (!(player.func_213453_ef() || !player.field_70123_F || player.func_180799_ab() || player.func_70090_H() || player.field_71075_bZ.field_75100_b || player.func_70617_f_() || !(player.func_213322_ci().func_82617_b() < 0.1))) {
                    Double LookAt = player.func_70040_Z().field_72448_b;
                    if (LookAt > 0.1) {
                        LookAt = 0.1;
                    }
                    if (LookAt < -0.1) {
                        LookAt = -0.1;
                    }
                    if (player.field_70170_p.field_72995_K && player instanceof ClientPlayerEntity && ((ClientPlayerEntity)player).field_71158_b.field_192832_b < 0.0f) {
                        LookAt = LookAt * -1.0;
                    }
                    player.func_213317_d(player.func_213322_ci().func_72441_c(-player.func_213322_ci().func_82615_a() / 5.0, LookAt - player.func_213322_ci().field_72448_b, -player.func_213322_ci().func_82616_c() / 5.0));
                    EntityDataUtil.setAbilityClimbwall((Entity)player, true);
                    player.field_70143_R = 0.0f;
                    if (player.field_70170_p.field_72995_K) {
                        PlayerFallDistanceUpdateHandler.PlayerFallDistanceUpdate(player.func_110124_au(), Float.valueOf(player.field_70143_R));
                    }
                }
            } else if (!ArmorUtil.isWearingPoisonArmor(player) && EntityDataUtil.getAbilityClimbwall((Entity)player)) {
                EntityDataUtil.setAbilityClimbwall((Entity)player, false);
            }
            EntityDataUtil.tickCooldown(player);
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.LOWEST)
    public static void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (ArmorUtil.isWearingWitherArmor(player) && UpgradedNetheriteConfig.EnableWitherImmune && player.func_70644_a(Effects.field_82731_v)) {
                player.func_195063_d(Effects.field_82731_v);
                DurabilityUtil.WitherDurabilityLoss(player);
            }
            if (ArmorUtil.isWearingPoisonArmor(player) && UpgradedNetheriteConfig.EnablePoisonImmune && player.func_70644_a(Effects.field_76436_u)) {
                player.func_195063_d(Effects.field_76436_u);
                DurabilityUtil.PoisonDurabilityLoss(player);
            }
            if (UpgradedNetheriteConfig.EnableHealthMalus) {
                if (ArmorUtil.intWearingCorrupt(player, false) > 0 && EntityDataUtil.getCorrupterite((Entity)player) < ArmorUtil.intWearingCorrupt(player, false)) {
                    EntityDataUtil.setCorrupterite((Entity)player, ArmorUtil.intWearingCorrupt(player, false));
                }
                if (ArmorUtil.intWearingCorrupt(player, false) >= 0 && EntityDataUtil.getCorrupterite((Entity)player) > ArmorUtil.intWearingCorrupt(player, false) + EntityDataUtil.getMalusCorruption((Entity)player)) {
                    EntityDataUtil.setMalusCorruption((Entity)player, EntityDataUtil.getCorrupterite((Entity)player) - ArmorUtil.intWearingCorrupt(player, false));
                    player.func_195064_c(new EffectInstance((Effect)UpgradedNetheriteEffects.NETHERITE_CORRUPTION.get(), 12000, EntityDataUtil.getMalusCorruption((Entity)player) - 1, false, true, true));
                } else if (ArmorUtil.intWearingCorrupt(player, false) + EntityDataUtil.getMalusCorruption((Entity)player) > EntityDataUtil.getCorrupterite((Entity)player) && player.func_70644_a((Effect)UpgradedNetheriteEffects.NETHERITE_CORRUPTION.get())) {
                    Integer time = 0;
                    time = player.func_70660_b((Effect)UpgradedNetheriteEffects.NETHERITE_CORRUPTION.get()).func_76459_b();
                    player.func_195063_d((Effect)UpgradedNetheriteEffects.NETHERITE_CORRUPTION.get());
                    EntityDataUtil.setMalusCorruption((Entity)player, EntityDataUtil.getCorrupterite((Entity)player) - ArmorUtil.intWearingCorrupt(player, false));
                    if (ArmorUtil.intWearingCorrupt(player, false) != 4) {
                        player.func_195064_c(new EffectInstance((Effect)UpgradedNetheriteEffects.NETHERITE_CORRUPTION.get(), time.intValue(), EntityDataUtil.getMalusCorruption((Entity)player) - 1, false, true, true));
                    }
                }
            } else {
                EntityDataUtil.setCorrupterite((Entity)player, 0);
                EntityDataUtil.setMalusCorruption((Entity)player, 0);
                if (player.func_70644_a((Effect)UpgradedNetheriteEffects.NETHERITE_CORRUPTION.get())) {
                    player.func_195063_d((Effect)UpgradedNetheriteEffects.NETHERITE_CORRUPTION.get());
                }
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.LOWEST)
    public static void onDamageEntity(LivingHurtEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onLivingAttackEvent(LivingAttackEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (event.getSource().func_76347_k() && ArmorUtil.isWearingFireArmor(player)) {
                if (UpgradedNetheriteConfig.EnableFireImmune) {
                    if (event.isCancelable()) {
                        event.setCanceled(true);
                    }
                    player.func_70066_B();
                    DurabilityUtil.FireDurabilityLoss(player);
                }
            } else if (event.getSource() == DamageSource.field_76380_i && !player.field_70170_p.func_201670_d() && ArmorUtil.isWearingEnderArmor(player) && player.func_226278_cu_() < -64.0 && !player.func_70644_a((Effect)UpgradedNetheriteEffects.ENDER_ANCHOR.get()) && UpgradedNetheriteConfig.EnableVoidSave) {
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                World world = player.field_70170_p;
                player.func_184210_p();
                player.field_70143_R = 0.0f;
                if (!EntityDataUtil.hasEnderTeleportCooldown(player)) {
                    Boolean validtp = false;
                    if (EntityDataUtil.getAbilityEnderPos((Entity)player) != null) {
                        BlockPos blockpos = EntityDataUtil.getAbilityEnderPos((Entity)player);
                        ArrayList<BlockPos> validtpList = new ArrayList<BlockPos>();
                        if (world.func_180495_p(blockpos.func_177977_b()).func_185904_a().func_76230_c() && (player.field_70170_p.func_204610_c(blockpos).func_206888_e() || player.field_70170_p.func_180495_p(blockpos).func_203425_a(Blocks.field_203203_C)) && player.field_70170_p.func_180495_p(blockpos).func_196957_g((IBlockReader)player.field_70170_p, blockpos, PathType.LAND) && (player.field_70170_p.func_204610_c(blockpos.func_177984_a()).func_206888_e() || player.field_70170_p.func_180495_p(blockpos.func_177984_a()).func_203425_a(Blocks.field_203203_C)) && player.field_70170_p.func_180495_p(blockpos.func_177984_a()).func_196957_g((IBlockReader)player.field_70170_p, blockpos.func_177984_a(), PathType.LAND)) {
                            validtpList.add(blockpos.func_185334_h());
                        }
                        if (validtpList.size() <= 0) {
                            for (BlockPos blockpos1 : BlockPos.func_218278_a((BlockPos)blockpos.func_177982_a(-5, -5, -5), (BlockPos)blockpos.func_177982_a(5, 5, 5))) {
                                if (!world.func_180495_p(blockpos1.func_177977_b()).func_185904_a().func_76230_c() || !player.field_70170_p.func_204610_c(blockpos1).func_206888_e() && !player.field_70170_p.func_180495_p(blockpos1).func_203425_a(Blocks.field_203203_C) || !player.field_70170_p.func_180495_p(blockpos1).func_196957_g((IBlockReader)player.field_70170_p, blockpos1, PathType.LAND) || !player.field_70170_p.func_204610_c(blockpos1.func_177984_a()).func_206888_e() && !player.field_70170_p.func_180495_p(blockpos1.func_177984_a()).func_203425_a(Blocks.field_203203_C) || !player.field_70170_p.func_180495_p(blockpos1.func_177984_a()).func_196957_g((IBlockReader)player.field_70170_p, blockpos1.func_177984_a(), PathType.LAND)) continue;
                                validtpList.add(blockpos1.func_185334_h());
                            }
                        }
                        if (validtpList.size() > 0) {
                            Integer IRNG = player.func_70681_au().nextInt(validtpList.size());
                            player.func_70634_a((double)((BlockPos)validtpList.get(IRNG)).func_177958_n() + 0.5, (double)((BlockPos)validtpList.get(IRNG)).func_177956_o(), (double)((BlockPos)validtpList.get(IRNG)).func_177952_p() + 0.5);
                            player.getPersistentData().func_74768_a("upgraded_netherite_ender_teleport_cd", 20);
                            SoundEvent soundevent = SoundEvents.field_187534_aX;
                            player.field_70170_p.func_184148_a(null, (double)((BlockPos)validtpList.get(IRNG)).func_177958_n() + 0.5, (double)((BlockPos)validtpList.get(IRNG)).func_177956_o(), (double)((BlockPos)validtpList.get(IRNG)).func_177952_p() + 0.5, soundevent, SoundCategory.PLAYERS, 1.0f, 1.0f);
                            player.func_184185_a(soundevent, 1.0f, 1.0f);
                            for (int i = 0; i < 32; ++i) {
                                player.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, (double)((BlockPos)validtpList.get(IRNG)).func_177958_n() + 0.5, (double)((BlockPos)validtpList.get(IRNG)).func_177956_o() + player.func_70681_au().nextDouble() * 2.0, (double)((BlockPos)validtpList.get(IRNG)).func_177952_p() + 0.5, player.func_70681_au().nextGaussian(), 0.0, player.func_70681_au().nextGaussian());
                            }
                            validtp = true;
                        }
                    }
                    if (!validtp.booleanValue()) {
                        if (!world.func_180495_p(new BlockPos(100, 48, 0)).func_185904_a().func_76230_c()) {
                            world.func_175656_a(new BlockPos(100, 48, 0), Blocks.field_150343_Z.func_176223_P());
                        }
                        if (world.func_180495_p(new BlockPos(100, 49, 0)) != Blocks.field_150350_a.func_176223_P()) {
                            world.func_175656_a(new BlockPos(100, 49, 0), Blocks.field_150350_a.func_176223_P());
                        }
                        if (world.func_180495_p(new BlockPos(100, 50, 0)) != Blocks.field_150350_a.func_176223_P()) {
                            world.func_175656_a(new BlockPos(100, 50, 0), Blocks.field_150350_a.func_176223_P());
                        }
                        player.func_70634_a(100.5, 49.0, 0.5);
                        player.getPersistentData().func_74768_a("upgraded_netherite_ender_teleport_cd", 20);
                        SoundEvent soundevent = SoundEvents.field_187534_aX;
                        player.field_70170_p.func_184148_a(null, 100.5, 49.0, 0.5, soundevent, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        player.func_184185_a(soundevent, 1.0f, 1.0f);
                        for (int i = 0; i < 32; ++i) {
                            player.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, 100.5, 49.0 + player.func_70681_au().nextDouble() * 2.0, 0.5, player.func_70681_au().nextGaussian(), 0.0, player.func_70681_au().nextGaussian());
                        }
                    }
                    Iterable armorList = player.func_184193_aE();
                    if (UpgradedNetheriteConfig.EnableBreakEnderArmor) {
                        for (ItemStack stack : armorList) {
                            if (stack.func_190926_b() || !ArmorUtil.isEnderArmor(stack)) continue;
                            stack.func_222118_a(stack.func_77958_k() - stack.func_77952_i(), (LivingEntity)player, e -> e.func_213361_c(((ArmorItem)stack.func_77973_b()).func_185083_B_()));
                        }
                    }
                }
            } else if (event.getSource() == DamageSource.field_76379_h) {
                // empty if block
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public void onEntityFall(LivingFallEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (ArmorUtil.isWearingPhantomArmor(player) && UpgradedNetheriteConfig.EnableFallImmune) {
                event.setResult(Event.Result.DENY);
                if (UpgradedNetheriteConfig.EnableDamageDurabilityPhantomArmor) {
                    Iterable armorList = player.func_184193_aE();
                    for (ItemStack stack : armorList) {
                        if (stack.func_190926_b() || !ArmorUtil.isPhantomArmor(stack) || !((double)player.field_70143_R >= 3.5)) continue;
                        stack.func_222118_a(UpgradedNetheriteConfig.MultiplierDamageDurabilityPhantomArmor * (Math.round(player.field_70143_R) - 3), (LivingEntity)player, livingEntity -> livingEntity.func_213361_c(((ArmorItem)stack.func_77973_b()).func_185083_B_()));
                    }
                }
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
            }
            if (ArmorUtil.isWearingFeatherArmor(player) && UpgradedNetheriteConfig.EnableReduceFallDamage) {
                event.setDamageMultiplier(0.5f);
                if (UpgradedNetheriteConfig.EnableFallDamageDurabilityFeatherArmor && (double)event.getDistance() > 3.0) {
                    DurabilityUtil.FeatherDurabilityLoss(player);
                }
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public void onApplyEffect(PotionEvent.PotionApplicableEvent event) {
        if (event.getEntityLiving() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
            if (event.getPotionEffect().func_188419_a() == Effects.field_82731_v && ArmorUtil.isWearingWitherArmor((PlayerEntity)player) && UpgradedNetheriteConfig.EnableWitherImmune) {
                event.setResult(Event.Result.DENY);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                DurabilityUtil.WitherDurabilityLoss((PlayerEntity)player);
            } else if (event.getPotionEffect().func_188419_a() == Effects.field_76436_u && ArmorUtil.isWearingPoisonArmor((PlayerEntity)player) && UpgradedNetheriteConfig.EnablePoisonImmune) {
                event.setResult(Event.Result.DENY);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                DurabilityUtil.PoisonDurabilityLoss((PlayerEntity)player);
            }
        }
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            EntityDataUtil.setAbilityClimbwall((Entity)player, false);
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    @OnlyIn(value=Dist.CLIENT)
    public void onOverlayRender(RenderGameOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getType() == RenderGameOverlayEvent.ElementType.AIR && ArmorUtil.isWearingWaterArmor((PlayerEntity)mc.field_71439_g) && UpgradedNetheriteConfig.EnableWaterBreath && (double)mc.field_71439_g.func_70086_ai() >= (double)mc.field_71439_g.func_205010_bg() * 0.966) {
            event.setCanceled(true);
        }
    }
}

