/*
 * Decompiled with CFR 0.152.
 */
package com.rolfmao.upgradednetherite.handlers;

import com.rolfmao.upgradednetherite.init.ModItems;
import com.rolfmao.upgradednetherite.init.UpgradedNetheriteEffects;
import com.rolfmao.upgradednetherite.utils.ArmorUtil;
import com.rolfmao.upgradednetherite.utils.DurabilityUtil;
import com.rolfmao.upgradednetherite.utils.ToolUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="upgradednetherite", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventHandler {
    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public static void onEnderTeleport(EnderTeleportEvent event) {
        if (event.getEntityLiving().func_70644_a((Effect)UpgradedNetheriteEffects.ENDER_ANCHOR.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (ArmorUtil.isWearingFireArmor((PlayerEntity)player) && event.getInfo().func_216771_k().func_206884_a((ITag)FluidTags.field_206960_b)) {
            event.setDensity(0.25f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            ItemStack heldItem = player.func_184614_ca();
            if (ArmorUtil.intWearingCorrupt(player, false) > 0 || ToolUtil.isUsingCorruptTool(player) || ToolUtil.isUsingCorruptWeapon(player) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.CORRUPT_UPGRADED_NETHERITE_BOW.get()))) {
                DurabilityUtil.CorruptDurabilityGain(player);
            }
        }
        if (event.getEntityLiving().func_70644_a((Effect)UpgradedNetheriteEffects.ATTRACTION.get())) {
            LivingEntity target = event.getEntityLiving();
            double tx = target.func_226277_ct_();
            double ty = target.func_226278_cu_();
            double tz = target.func_226281_cx_();
            List entities = target.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(tx - 5.0, ty - 5.0, tz - 5.0, tx + 5.0, ty + 5.0, tz + 5.0));
            int pulled = 0;
            for (LivingEntity entity : entities) {
                if (!entity.func_70089_S() || entity == event.getEntityLiving() || target instanceof WitherEntity || target instanceof EnderDragonEntity || entity instanceof PlayerEntity && !(target instanceof PlayerEntity)) continue;
                if (pulled > 32) break;
                Vector3d entityVector = new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
                Vector3d finalVector = new Vector3d(tx, ty, tz).func_178788_d(entityVector);
                if (entity.func_226278_cu_() < ty && target.func_233570_aj_()) {
                    finalVector = new Vector3d(tx, ty + 0.1, tz).func_178788_d(entityVector);
                    entity.field_70143_R = 0.0f;
                }
                if (!(Math.sqrt(finalVector.field_72450_a * finalVector.field_72450_a + finalVector.field_72448_b * finalVector.field_72448_b + finalVector.field_72449_c * finalVector.field_72449_c) > 1.8)) continue;
                finalVector = finalVector.func_72432_b();
                entity.func_213293_j(finalVector.field_72450_a * (double)0.15f, finalVector.field_72448_b * (double)0.15f, finalVector.field_72449_c * (double)0.15f);
                ++pulled;
            }
        }
    }
}

