/*
 * Decompiled with CFR 0.152.
 */
package com.rolfmao.upgradednetherite.handlers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.rolfmao.upgradednetherite.config.UpgradedNetheriteConfig;
import com.rolfmao.upgradednetherite.handlers.EntityFallDistanceUpdateHandler;
import com.rolfmao.upgradednetherite.utils.ArmorUtil;
import com.rolfmao.upgradednetherite.utils.EntityDataUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.pathfinding.PathType;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="upgradednetherite", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class HorseArmorEventHandler {
    private Multimap<Attribute, AttributeModifier> SwimHorseAttributeMap() {
        HashMultimap attributesDefault = HashMultimap.create();
        attributesDefault.put((Object)ForgeMod.SWIM_SPEED.get(), (Object)new AttributeModifier(UUID.fromString("fbfd69fe-3369-11eb-adc1-0242ac120002"), "upgradednetherite:swim_bonus", 1.5, AttributeModifier.Operation.MULTIPLY_BASE));
        return attributesDefault;
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        HorseEntity horse;
        PlayerEntity player;
        if (event.getEntityLiving() instanceof HorseEntity && ((HorseEntity)event.getEntityLiving()).func_110248_bS()) {
            HorseEntity horse2 = (HorseEntity)event.getEntityLiving();
            PlayerEntity rider = null;
            if (!horse2.func_184188_bt().isEmpty()) {
                for (Entity entity : horse2.func_184188_bt()) {
                    if (!(entity instanceof PlayerEntity)) continue;
                    rider = (PlayerEntity)entity;
                }
            }
            if (horse2.func_180799_ab() && ArmorUtil.isHorseWearingFireArmor(horse2) && UpgradedNetheriteConfig.EnableLavaSpeed) {
                horse2.func_213317_d(horse2.func_213322_ci().func_216372_d(1.66, 1.0, 1.66));
            }
            if (ArmorUtil.isHorseWearingEnderArmor(horse2) && UpgradedNetheriteConfig.EnableVoidSave) {
                BlockPos blockpos1 = horse2.getEntity().func_233580_cy_().func_177977_b();
                BlockState blockstate = horse2.field_70170_p.func_180495_p(blockpos1);
                if (blockstate.func_185904_a().func_76230_c()) {
                    EntityDataUtil.setAbilityEnderPos((Entity)horse2, true);
                }
            } else if (!ArmorUtil.isHorseWearingEnderArmor(horse2) && EntityDataUtil.getAbilityEnderPos((Entity)horse2) != null) {
                EntityDataUtil.setAbilityEnderPos((Entity)horse2, false);
            }
            if (ArmorUtil.isHorseWearingWaterArmor(horse2) && UpgradedNetheriteConfig.EnableWaterSpeed) {
                horse2.func_233645_dx_().func_233793_b_(this.SwimHorseAttributeMap());
            } else if (!ArmorUtil.isHorseWearingWaterArmor(horse2)) {
                horse2.func_233645_dx_().func_233785_a_(this.SwimHorseAttributeMap());
            }
            if (ArmorUtil.isHorseWearingPoisonArmor(horse2) && UpgradedNetheriteConfig.EnableClimbWall) {
                if (rider != null && EntityDataUtil.getAbilityClimbwall((Entity)horse2)) {
                    if (horse2.func_213322_ci().func_82617_b() < 0.0) {
                        horse2.func_230245_c_(true);
                        horse2.field_70143_R = 0.0f;
                        horse2.func_213317_d(horse2.func_213322_ci().func_72441_c(-horse2.func_213322_ci().func_82615_a() / 10.0, -horse2.func_213322_ci().func_82617_b(), -horse2.func_213322_ci().func_82616_c() / 10.0));
                    }
                    if (horse2.func_213322_ci().func_82615_a() != 0.0 && horse2.func_213322_ci().func_82616_c() != 0.0) {
                        EntityDataUtil.setAbilityClimbwall((Entity)horse2, false);
                    }
                }
                if (rider != null && horse2.field_70123_F && !horse2.func_180799_ab() && !horse2.func_70090_H()) {
                    Double LookAt = horse2.func_70040_Z().field_72448_b;
                    if (LookAt > 0.1) {
                        LookAt = 0.1;
                    }
                    if (LookAt < -0.1) {
                        LookAt = -0.1;
                    }
                    if (rider.field_70170_p.field_72995_K && ((ClientPlayerEntity)rider).field_71158_b.field_192832_b < 0.0f) {
                        LookAt = LookAt * -1.0;
                    }
                    horse2.field_70143_R = 0.0f;
                    horse2.func_213317_d(horse2.func_213322_ci().func_72441_c(-horse2.func_213322_ci().func_82615_a() / 10.0, LookAt - horse2.func_213322_ci().field_72448_b, -horse2.func_213322_ci().func_82616_c() / 10.0));
                    if (horse2.field_70170_p.field_72995_K) {
                        EntityFallDistanceUpdateHandler.EntityFallDistanceUpdate(horse2.func_145782_y(), Float.valueOf(horse2.field_70143_R));
                    }
                    EntityDataUtil.setAbilityClimbwall((Entity)horse2, true);
                }
            } else if (!ArmorUtil.isHorseWearingPoisonArmor(horse2) && EntityDataUtil.getAbilityClimbwall((Entity)horse2)) {
                EntityDataUtil.setAbilityClimbwall((Entity)horse2, false);
            }
            if (horse2.func_70086_ai() < horse2.func_205010_bg() && ArmorUtil.isHorseWearingWaterArmor(horse2) && UpgradedNetheriteConfig.EnableWaterBreath) {
                horse2.func_70050_g(horse2.func_70086_ai() + 1);
            }
            if (horse2.func_70644_a(Effects.field_82731_v) && ArmorUtil.isHorseWearingWitherArmor(horse2) && UpgradedNetheriteConfig.EnableWitherImmune) {
                horse2.func_195063_d(Effects.field_82731_v);
            }
            if (horse2.func_70644_a(Effects.field_76436_u) && ArmorUtil.isHorseWearingPoisonArmor(horse2) && UpgradedNetheriteConfig.EnablePoisonImmune) {
                horse2.func_195063_d(Effects.field_76436_u);
            }
            if ((horse2.field_70170_p.func_204610_c(horse2.getEntity().func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206960_b) || horse2.field_70170_p.func_204610_c(horse2.getEntity().func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206959_a)) && ArmorUtil.isHorseWearingFeatherArmor(horse2) && UpgradedNetheriteConfig.EnableWaterLavaWalking) {
                if (horse2.func_70090_H() || horse2.func_180799_ab()) {
                    if (horse2.func_213322_ci().field_72448_b < 0.3 && (horse2.func_208600_a((ITag)FluidTags.field_206960_b) || horse2.func_208600_a((ITag)FluidTags.field_206959_a))) {
                        horse2.func_213317_d(horse2.func_213322_ci().func_72441_c(0.0, 0.3 - horse2.func_213322_ci().field_72448_b, 0.0));
                    } else if (horse2.func_213322_ci().field_72448_b < 0.15 && !horse2.func_208600_a((ITag)FluidTags.field_206960_b) && !horse2.func_208600_a((ITag)FluidTags.field_206959_a)) {
                        horse2.func_213317_d(horse2.func_213322_ci().func_72441_c(0.0, 0.15 - horse2.func_213322_ci().field_72448_b, 0.0));
                    }
                } else {
                    horse2.func_230245_c_(true);
                    horse2.func_70637_d(false);
                    horse2.func_213317_d(horse2.func_213322_ci().func_72441_c(0.0, -horse2.func_213322_ci().func_82617_b(), 0.0));
                }
            }
        }
        if (event.getEntityLiving() instanceof PlayerEntity && (player = (PlayerEntity)event.getEntityLiving()).func_184187_bx() instanceof HorseEntity && player.field_70170_p.field_72995_K && (ArmorUtil.isHorseWearingWaterArmor(horse = (HorseEntity)player.func_184187_bx().getEntity()) && horse.field_70170_p.func_204610_c(player.getEntity().func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206959_a) || ArmorUtil.isHorseWearingFireArmor(horse) && horse.field_70170_p.func_204610_c(player.getEntity().func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206960_b)) && player.field_70170_p.field_72995_K && player instanceof ClientPlayerEntity && ((ClientPlayerEntity)player).field_71158_b.field_192832_b != 0.0f) {
            double d3 = player.func_70040_Z().field_72448_b;
            double d4 = d3 < -0.2 ? 0.085 : 0.06;
            double d5 = player.field_70170_p.field_72995_K && player instanceof ClientPlayerEntity && ((ClientPlayerEntity)player).field_71158_b.field_192832_b > 0.0f ? (d3 - horse.func_213322_ci().field_72448_b) * d4 : -((d3 - horse.func_213322_ci().field_72448_b) * d4) / 4.0;
            horse.func_213317_d(horse.func_213322_ci().func_72441_c(0.0, d5, 0.0));
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.LOWEST)
    public static void onDamageEntity(LivingHurtEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getEntityLiving() instanceof PlayerEntity && event.getEntityLiving().func_184187_bx() instanceof HorseEntity && ArmorUtil.isHorseWearingFeatherArmor((HorseEntity)event.getEntityLiving().func_184187_bx()) && event.getSource() == DamageSource.field_76379_h && UpgradedNetheriteConfig.EnableReduceFallDamage) {
            event.setAmount(event.getAmount() / 2.0f);
        } else if (event.getEntityLiving() instanceof HorseEntity && ArmorUtil.isHorseWearingFeatherArmor((HorseEntity)event.getEntityLiving()) && event.getSource() == DamageSource.field_76379_h && UpgradedNetheriteConfig.EnableReduceFallDamage) {
            event.setAmount(event.getAmount() / 2.0f);
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public void onLivingAttackEvent(LivingAttackEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && event.getEntityLiving().func_184187_bx() instanceof HorseEntity && ((HorseEntity)event.getEntityLiving().func_184187_bx()).func_110248_bS() && ArmorUtil.isHorseWearingPhantomArmor((HorseEntity)event.getEntityLiving().func_184187_bx()) && event.isCancelable()) {
            event.setCanceled(true);
        }
        if (event.getEntityLiving() instanceof HorseEntity && ((HorseEntity)event.getEntityLiving()).func_110248_bS()) {
            HorseEntity horse = (HorseEntity)event.getEntityLiving();
            if (event.getSource().func_76347_k() && ArmorUtil.isHorseWearingFireArmor(horse) && UpgradedNetheriteConfig.EnableFireImmune) {
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                horse.func_70066_B();
            } else if (event.getSource() == DamageSource.field_76379_h && ArmorUtil.isHorseWearingPhantomArmor(horse) && UpgradedNetheriteConfig.EnableFallImmune) {
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
            } else if (event.getSource() == DamageSource.field_76369_e && ArmorUtil.isHorseWearingWaterArmor(horse) && UpgradedNetheriteConfig.EnableWaterBreath) {
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                horse.func_70050_g(horse.func_205010_bg());
            } else if (event.getSource() == DamageSource.field_76380_i && ArmorUtil.isHorseWearingEnderArmor(horse) && UpgradedNetheriteConfig.EnableVoidSave && horse.func_226278_cu_() < -63.0) {
                BlockPos blockpos;
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                World world = horse.field_70170_p;
                if (!horse.func_184188_bt().isEmpty()) {
                    horse.func_184226_ay();
                }
                horse.field_70143_R = 0.0f;
                Boolean validtp = false;
                if (EntityDataUtil.getAbilityEnderPos((Entity)horse) != null) {
                    if (horse.func_213373_a((double)horse.getPersistentData().func_74759_k("upgraded_netherite_ender_pos")[0] + 0.5, (double)horse.getPersistentData().func_74759_k("upgraded_netherite_ender_pos")[1], (double)horse.getPersistentData().func_74759_k("upgraded_netherite_ender_pos")[2] + 0.5, true)) {
                        SoundEvent soundevent = SoundEvents.field_187534_aX;
                        horse.field_70170_p.func_184148_a(null, (double)horse.getPersistentData().func_74759_k("upgraded_netherite_ender_pos")[0] + 0.5, (double)horse.getPersistentData().func_74759_k("upgraded_netherite_ender_pos")[1], (double)horse.getPersistentData().func_74759_k("upgraded_netherite_ender_pos")[2] + 0.5, soundevent, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        horse.func_184185_a(soundevent, 1.0f, 1.0f);
                        validtp = true;
                    } else {
                        blockpos = EntityDataUtil.getAbilityEnderPos((Entity)horse);
                        Iterator validtpList = new ArrayList();
                        for (BlockPos blockpos1 : BlockPos.func_218278_a((BlockPos)blockpos.func_177982_a(-10, -10, -10), (BlockPos)blockpos.func_177982_a(10, 10, 10))) {
                            if (!world.func_180495_p(blockpos1.func_177977_b()).func_185904_a().func_76230_c() || !horse.field_70170_p.func_204610_c(blockpos1).func_206888_e() && !horse.field_70170_p.func_180495_p(blockpos1).func_203425_a(Blocks.field_203203_C) || !horse.field_70170_p.func_180495_p(blockpos1).func_196957_g((IBlockReader)horse.field_70170_p, blockpos1, PathType.LAND) || !horse.field_70170_p.func_204610_c(blockpos1.func_177982_a(-1, 1, 0)).func_206888_e() && !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(-1, 1, 0)).func_203425_a(Blocks.field_203203_C) || !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(-1, 1, 0)).func_196957_g((IBlockReader)horse.field_70170_p, blockpos1.func_177982_a(-1, 1, 0), PathType.LAND) || !horse.field_70170_p.func_204610_c(blockpos1.func_177982_a(-1, 1, -1)).func_206888_e() && !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(-1, 1, -1)).func_203425_a(Blocks.field_203203_C) || !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(-1, 1, -1)).func_196957_g((IBlockReader)horse.field_70170_p, blockpos1.func_177982_a(-1, 1, -1), PathType.LAND) || !horse.field_70170_p.func_204610_c(blockpos1.func_177982_a(-1, 1, 1)).func_206888_e() && !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(-1, 1, 1)).func_203425_a(Blocks.field_203203_C) || !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(-1, 1, 1)).func_196957_g((IBlockReader)horse.field_70170_p, blockpos1.func_177982_a(-1, 1, 1), PathType.LAND) || !horse.field_70170_p.func_204610_c(blockpos1.func_177982_a(0, 1, 0)).func_206888_e() && !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(0, 1, 0)).func_203425_a(Blocks.field_203203_C) || !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(0, 1, 0)).func_196957_g((IBlockReader)horse.field_70170_p, blockpos1.func_177982_a(0, 1, 0), PathType.LAND) || !horse.field_70170_p.func_204610_c(blockpos1.func_177982_a(0, 1, -1)).func_206888_e() && !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(0, 1, -1)).func_203425_a(Blocks.field_203203_C) || !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(0, 1, -1)).func_196957_g((IBlockReader)horse.field_70170_p, blockpos1.func_177982_a(0, 1, -1), PathType.LAND) || !horse.field_70170_p.func_204610_c(blockpos1.func_177982_a(0, 1, 1)).func_206888_e() && !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(0, 1, 1)).func_203425_a(Blocks.field_203203_C) || !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(0, 1, 1)).func_196957_g((IBlockReader)horse.field_70170_p, blockpos1.func_177982_a(0, 1, 1), PathType.LAND) || !horse.field_70170_p.func_204610_c(blockpos1.func_177982_a(1, 1, 0)).func_206888_e() && !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(1, 1, 0)).func_203425_a(Blocks.field_203203_C) || !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(1, 1, 0)).func_196957_g((IBlockReader)horse.field_70170_p, blockpos1.func_177982_a(1, 1, 0), PathType.LAND) || !horse.field_70170_p.func_204610_c(blockpos1.func_177982_a(1, 1, -1)).func_206888_e() && !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(1, 1, -1)).func_203425_a(Blocks.field_203203_C) || !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(1, 1, -1)).func_196957_g((IBlockReader)horse.field_70170_p, blockpos1.func_177982_a(1, 1, -1), PathType.LAND) || !horse.field_70170_p.func_204610_c(blockpos1.func_177982_a(1, 1, 1)).func_206888_e() && !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(1, 1, 1)).func_203425_a(Blocks.field_203203_C) || !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(1, 1, 1)).func_196957_g((IBlockReader)horse.field_70170_p, blockpos1.func_177982_a(1, 1, 1), PathType.LAND)) continue;
                            validtpList.add((BlockPos)blockpos1.func_185334_h());
                        }
                        if (validtpList.size() > 0) {
                            Integer IRNG = horse.func_70681_au().nextInt(validtpList.size());
                            horse.func_70634_a((double)((BlockPos)validtpList.get(IRNG)).func_177958_n() + 0.5, (double)((BlockPos)validtpList.get(IRNG)).func_177956_o(), (double)((BlockPos)validtpList.get(IRNG)).func_177952_p() + 0.5);
                            SoundEvent soundevent = SoundEvents.field_187534_aX;
                            horse.field_70170_p.func_184148_a(null, (double)((BlockPos)validtpList.get(IRNG)).func_177958_n() + 0.5, (double)((BlockPos)validtpList.get(IRNG)).func_177956_o(), (double)((BlockPos)validtpList.get(IRNG)).func_177952_p() + 0.5, soundevent, SoundCategory.PLAYERS, 1.0f, 1.0f);
                            horse.func_184185_a(soundevent, 1.0f, 1.0f);
                            validtp = true;
                        }
                    }
                }
                if (!validtp.booleanValue()) {
                    blockpos = new BlockPos(100.5, 49.0, 0.5);
                    for (BlockPos blockpos1 : BlockPos.func_218278_a((BlockPos)blockpos.func_177982_a(-1, -1, -1), (BlockPos)blockpos.func_177982_a(1, -1, 1))) {
                        world.func_175656_a(blockpos1, Blocks.field_150343_Z.func_176223_P());
                    }
                    for (BlockPos blockpos1 : BlockPos.func_218278_a((BlockPos)blockpos.func_177982_a(-1, 0, -1), (BlockPos)blockpos.func_177982_a(1, 1, 1))) {
                        world.func_175656_a(blockpos1, Blocks.field_150350_a.func_176223_P());
                    }
                    horse.func_70634_a(100.5, 49.0, 0.5);
                    SoundEvent soundevent = SoundEvents.field_187534_aX;
                    horse.field_70170_p.func_184148_a(null, 100.5, 49.0, 0.5, soundevent, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    horse.func_184185_a(soundevent, 1.0f, 1.0f);
                }
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.LOWEST)
    public static void onLooting(LootingLevelEvent event) {
        HorseEntity horse;
        ServerPlayerEntity player;
        if (event.getDamageSource() != null && event.getDamageSource().func_76346_g() instanceof ServerPlayerEntity && (player = (ServerPlayerEntity)event.getDamageSource().func_76346_g()).func_184187_bx() instanceof HorseEntity && ArmorUtil.isHorseWearingGoldArmor(horse = (HorseEntity)player.func_184187_bx().getEntity()) && UpgradedNetheriteConfig.EnableLootingBonus) {
            event.setLootingLevel(event.getLootingLevel() + 1);
        }
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof HorseEntity && ((HorseEntity)event.getEntityLiving()).func_110248_bS()) {
            HorseEntity horse = (HorseEntity)event.getEntityLiving();
            EntityDataUtil.setAbilityClimbwall((Entity)horse, false);
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public void onApplyEffect(PotionEvent.PotionApplicableEvent event) {
        if (event.getEntityLiving() instanceof HorseEntity && ((HorseEntity)event.getEntityLiving()).func_110248_bS()) {
            HorseEntity horse = (HorseEntity)event.getEntityLiving();
            if (event.getPotionEffect().func_188419_a() == Effects.field_82731_v && ArmorUtil.isHorseWearingWitherArmor(horse) && UpgradedNetheriteConfig.EnableWitherImmune) {
                event.setResult(Event.Result.DENY);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
            } else if (event.getPotionEffect().func_188419_a() == Effects.field_76436_u && ArmorUtil.isHorseWearingPoisonArmor(horse) && UpgradedNetheriteConfig.EnablePoisonImmune) {
                event.setResult(Event.Result.DENY);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onUnmount(EntityMountEvent event) {
        HorseEntity horse;
        if (event.isDismounting() && event.getEntity() instanceof PlayerEntity && !event.getEntity().func_226274_bn_() && event.getEntity().func_184187_bx() instanceof HorseEntity && (horse = (HorseEntity)event.getEntity().func_184187_bx()).func_110248_bS() && horse.func_208600_a((ITag)FluidTags.field_206959_a) && ArmorUtil.isHorseWearingWaterArmor(horse) && (UpgradedNetheriteConfig.EnableWaterBreath || UpgradedNetheriteConfig.EnableWaterSpeed)) {
            event.setCanceled(true);
        }
    }
}

