/*
 * Decompiled with CFR 0.152.
 */
package com.rolfmao.upgradednetherite.handlers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.rolfmao.upgradednetherite.config.UpgradedNetheriteConfig;
import com.rolfmao.upgradednetherite.utils.ReachEntity;
import com.rolfmao.upgradednetherite.utils.ToolUtil;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="upgradednetherite", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ToolEventHandler {
    private Multimap<Attribute, AttributeModifier> ReachAttributeMap() {
        HashMultimap attributesDefault = HashMultimap.create();
        attributesDefault.put((Object)ForgeMod.REACH_DISTANCE.get(), (Object)new AttributeModifier(UUID.fromString("ca095c88-32c8-11eb-adc1-0242ac120002"), "upgradednetherite:reach_bonus", (double)UpgradedNetheriteConfig.BonusReachTool, AttributeModifier.Operation.ADDITION));
        return attributesDefault;
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (ToolUtil.isUsingPhantomTool(player) && UpgradedNetheriteConfig.EnableReachEffect) {
                player.func_233645_dx_().func_233793_b_(this.ReachAttributeMap());
            } else if (!ToolUtil.isUsingPhantomTool(player) || !UpgradedNetheriteConfig.EnableReachEffect) {
                player.func_233645_dx_().func_233785_a_(this.ReachAttributeMap());
            }
            if (!player.field_70170_p.field_72995_K && ToolUtil.isUsingPhantomTool(player) && UpgradedNetheriteConfig.EnableGlowingEffect && !ToolUtil.getDisableEffect(player.func_184614_ca())) {
                List list = player.field_70170_p.func_175674_a((Entity)player, player.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0), entity -> entity instanceof LivingEntity);
                list.forEach(entity -> {
                    if (!(!(entity instanceof LivingEntity) || entity instanceof PlayerEntity && entity.func_213453_ef())) {
                        ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_188423_x, 5, 0, false, false, false));
                    }
                });
            }
            if (ToolUtil.isUsingFeatherTool(player) && UpgradedNetheriteConfig.EnableAttractItem && !ToolUtil.getDisableEffect(player.func_184614_ca()) && !player.func_213453_ef()) {
                double px = player.func_226277_ct_();
                double py = player.func_226278_cu_();
                double pz = player.func_226281_cx_();
                List items = player.field_70170_p.func_217357_a(ItemEntity.class, new AxisAlignedBB(px - 5.0, py - 5.0, pz - 5.0, px + 5.0, py + 5.0, pz + 5.0));
                int pulled = 0;
                for (ItemEntity item : items) {
                    if (!item.func_70089_S() || item.func_92059_d().func_190926_b() || item.getPersistentData().func_74767_n("PreventRemoteMovement")) continue;
                    if (pulled > 128) break;
                    Vector3d entityVector = new Vector3d(item.func_226277_ct_(), item.func_226278_cu_(), item.func_226281_cx_());
                    Vector3d finalVector = new Vector3d(px, py + 0.5, pz).func_178788_d(entityVector);
                    if (Math.sqrt(finalVector.field_72450_a * finalVector.field_72450_a + finalVector.field_72448_b * finalVector.field_72448_b + finalVector.field_72449_c * finalVector.field_72449_c) > 1.0) {
                        finalVector = finalVector.func_72432_b();
                    }
                    item.func_213293_j(finalVector.field_72450_a * (double)0.3f, finalVector.field_72448_b * (double)0.3f, finalVector.field_72449_c * (double)0.3f);
                    item.func_174868_q();
                    ++pulled;
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        PlayerEntity player = event.getPlayer();
        if (ToolUtil.isUsingPhantomTool(player) && !(player instanceof ServerPlayerEntity) && UpgradedNetheriteConfig.EnableReachEffect) {
            ReachEntity.handleExtendedReach(player);
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        PlayerEntity player;
        if (event.getEntityLiving() instanceof PlayerEntity && ToolUtil.isUsingWaterTool(player = (PlayerEntity)event.getEntityLiving()) && player.func_208600_a((ITag)FluidTags.field_206959_a) && UpgradedNetheriteConfig.EnableMiningSpeedUnderwater) {
            event.setNewSpeed(event.getOriginalSpeed() * 2.0f);
        }
    }
}

