/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.container;

import java.util.ArrayList;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.container.WarpPlateContainer;
import net.blay09.mods.waystones.container.WaystoneSelectionContainer;
import net.blay09.mods.waystones.container.WaystoneSettingsContainer;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.tileentity.SharestoneTileEntity;
import net.blay09.mods.waystones.tileentity.WarpPlateTileEntity;
import net.blay09.mods.waystones.tileentity.WaystoneTileEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModContainers {
    public static ContainerType<WaystoneSelectionContainer> waystoneSelection;
    public static ContainerType<WaystoneSelectionContainer> sharestoneSelection;
    public static ContainerType<WarpPlateContainer> warpPlate;
    public static ContainerType<WaystoneSettingsContainer> waystoneSettings;

    public static void register(IForgeRegistry<ContainerType<?>> registry) {
        waystoneSelection = new ContainerType((ContainerType.IFactory)((IContainerFactory)(windowId, inv, data) -> {
            BlockPos pos;
            TileEntity tileEntity;
            WarpMode warpMode = WarpMode.values[data.readByte()];
            IWaystone fromWaystone = null;
            if (warpMode == WarpMode.WAYSTONE_TO_WAYSTONE && (tileEntity = inv.field_70458_d.field_70170_p.func_175625_s(pos = data.func_179259_c())) instanceof WaystoneTileEntity) {
                fromWaystone = ((WaystoneTileEntity)tileEntity).getWaystone();
            }
            return WaystoneSelectionContainer.createWaystoneSelection(windowId, inv.field_70458_d, warpMode, fromWaystone);
        }));
        sharestoneSelection = new ContainerType((ContainerType.IFactory)((IContainerFactory)(windowId, inv, data) -> {
            BlockPos pos = data.func_179259_c();
            int count = data.readShort();
            ArrayList<IWaystone> waystones = new ArrayList<IWaystone>(count);
            for (int i = 0; i < count; ++i) {
                waystones.add(Waystone.read(data));
            }
            TileEntity tileEntity = inv.field_70458_d.field_70170_p.func_175625_s(pos);
            if (tileEntity instanceof SharestoneTileEntity) {
                IWaystone fromWaystone = ((SharestoneTileEntity)tileEntity).getWaystone();
                return new WaystoneSelectionContainer(sharestoneSelection, WarpMode.SHARESTONE_TO_SHARESTONE, fromWaystone, windowId, waystones);
            }
            return null;
        }));
        warpPlate = new ContainerType((ContainerType.IFactory)((IContainerFactory)(windowId, inv, data) -> {
            BlockPos pos = data.func_179259_c();
            TileEntity tileEntity = inv.field_70458_d.field_70170_p.func_175625_s(pos);
            if (tileEntity instanceof WarpPlateTileEntity) {
                return new WarpPlateContainer(windowId, (WarpPlateTileEntity)tileEntity, inv);
            }
            return null;
        }));
        waystoneSettings = new ContainerType((ContainerType.IFactory)((IContainerFactory)(windowId, inv, data) -> {
            IWaystone waystone = Waystone.read(data);
            return new WaystoneSettingsContainer(waystoneSettings, waystone, windowId);
        }));
        registry.registerAll((IForgeRegistryEntry[])new ContainerType[]{(ContainerType)waystoneSelection.setRegistryName("waystone_selection"), (ContainerType)sharestoneSelection.setRegistryName("sharestone_selection"), (ContainerType)warpPlate.setRegistryName("warp_plate_selection"), (ContainerType)waystoneSettings.setRegistryName("waystone_settings")});
    }
}

