/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Objects;
import net.blay09.mods.waystones.block.ModBlocks;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.config.WorldGenStyle;
import net.blay09.mods.waystones.worldgen.WaystoneFeature;
import net.blay09.mods.waystones.worldgen.WaystonePlacement;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.LegacySingleJigsawPiece;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="waystones")
public class ModWorldGen {
    private static final ResourceLocation villageWaystoneStructure = new ResourceLocation("waystones", "village/common/waystone");
    private static final ResourceLocation desertVillageWaystoneStructure = new ResourceLocation("waystones", "village/desert/waystone");
    private static final ResourceLocation emptyStructure = new ResourceLocation("empty");
    private static WaystoneFeature waystoneFeature;
    private static WaystoneFeature mossyWaystoneFeature;
    private static WaystoneFeature sandyWaystoneFeature;
    private static ConfiguredFeature<?, ?> configuredWaystoneFeature;
    private static ConfiguredFeature<?, ?> configuredMossyWaystoneFeature;
    private static ConfiguredFeature<?, ?> configuredSandyWaystoneFeature;
    private static WaystonePlacement waystonePlacement;

    public static void registerFeatures(IForgeRegistry<Feature<?>> registry) {
        Feature[] featureArray = new Feature[3];
        waystoneFeature = (WaystoneFeature)new WaystoneFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, ModBlocks.waystone.func_176223_P()).setRegistryName("waystone");
        featureArray[0] = waystoneFeature;
        mossyWaystoneFeature = (WaystoneFeature)new WaystoneFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, ModBlocks.mossyWaystone.func_176223_P()).setRegistryName("mossy_waystone");
        featureArray[1] = mossyWaystoneFeature;
        sandyWaystoneFeature = (WaystoneFeature)new WaystoneFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, ModBlocks.sandyWaystone.func_176223_P()).setRegistryName("sandy_waystone");
        featureArray[2] = sandyWaystoneFeature;
        registry.registerAll((IForgeRegistryEntry[])featureArray);
    }

    public static void registerConfiguredFeatures() {
        configuredWaystoneFeature = ModWorldGen.registerConfiguredWaystone(waystoneFeature);
        configuredMossyWaystoneFeature = ModWorldGen.registerConfiguredWaystone(mossyWaystoneFeature);
        configuredSandyWaystoneFeature = ModWorldGen.registerConfiguredWaystone(sandyWaystoneFeature);
    }

    private static ConfiguredFeature<?, ?> registerConfiguredWaystone(WaystoneFeature feature) {
        ConfiguredFeature configuredFeature = feature.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e).func_227228_a_(waystonePlacement.func_227446_a_((IPlacementConfig)NoPlacementConfig.field_202468_e));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)Objects.requireNonNull(feature.getRegistryName()), (Object)configuredFeature);
        return configuredFeature;
    }

    public static void registerPlacements(IForgeRegistry<Placement<?>> registry) {
        Placement[] placementArray = new Placement[1];
        waystonePlacement = (WaystonePlacement)new WaystonePlacement((Codec<NoPlacementConfig>)NoPlacementConfig.field_236555_a_).setRegistryName("waystone");
        placementArray[0] = waystonePlacement;
        registry.registerAll((IForgeRegistryEntry[])placementArray);
    }

    @SubscribeEvent
    public static void onBiomeLoading(BiomeLoadingEvent event) {
        ConfiguredFeature<?, ?> configuredFeature = ModWorldGen.getWaystoneFeature(event.getCategory());
        event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, configuredFeature);
    }

    private static ConfiguredFeature<?, ?> getWaystoneFeature(Biome.Category biomeCategory) {
        WorldGenStyle worldGenStyle = (WorldGenStyle)((Object)WaystonesConfig.COMMON.worldGenStyle.get());
        switch (worldGenStyle) {
            case MOSSY: {
                return configuredMossyWaystoneFeature;
            }
            case SANDY: {
                return configuredSandyWaystoneFeature;
            }
            case BIOME: {
                switch (biomeCategory) {
                    case DESERT: {
                        return configuredSandyWaystoneFeature;
                    }
                    case JUNGLE: 
                    case SWAMP: 
                    case MUSHROOM: {
                        return configuredMossyWaystoneFeature;
                    }
                }
                return configuredWaystoneFeature;
            }
        }
        return configuredWaystoneFeature;
    }

    public static void setupVillageWorldGen(DynamicRegistries dynamicRegistries) {
        if (((Boolean)WaystonesConfig.COMMON.spawnInVillages.get()).booleanValue() || ((Boolean)WaystonesConfig.COMMON.forceSpawnInVillages.get()).booleanValue()) {
            ModWorldGen.addWaystoneStructureToVillageConfig(dynamicRegistries, "village/plains/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(dynamicRegistries, "village/snowy/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(dynamicRegistries, "village/savanna/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(dynamicRegistries, "village/desert/houses", desertVillageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(dynamicRegistries, "village/taiga/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(dynamicRegistries, "repurposed_structures:village/badlands/houses", desertVillageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(dynamicRegistries, "repurposed_structures:village/birch/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(dynamicRegistries, "repurposed_structures:village/dark_forest/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(dynamicRegistries, "repurposed_structures:village/jungle/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(dynamicRegistries, "repurposed_structures:village/mountains/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(dynamicRegistries, "repurposed_structures:village/oak/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(dynamicRegistries, "repurposed_structures:village/swamp/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(dynamicRegistries, "repurposed_structures:village/mushroom/houses", villageWaystoneStructure, 1);
        }
    }

    private static void addWaystoneStructureToVillageConfig(DynamicRegistries dynamicRegistries, String villagePiece, ResourceLocation waystoneStructure, int weight) {
        LegacySingleJigsawPiece piece = (LegacySingleJigsawPiece)JigsawPiece.func_242849_a((String)waystoneStructure.toString()).apply(JigsawPattern.PlacementBehaviour.RIGID);
        JigsawPattern pool = dynamicRegistries.func_243612_b(Registry.field_243555_ax).func_241873_b(new ResourceLocation(villagePiece)).orElse(null);
        if (pool != null) {
            ArrayList<LegacySingleJigsawPiece> listOfPieces = new ArrayList<LegacySingleJigsawPiece>(pool.field_214953_e);
            for (int i = 0; i < weight; ++i) {
                listOfPieces.add(piece);
            }
            pool.field_214953_e = listOfPieces;
            ArrayList<Pair> listOfWeightedPieces = new ArrayList<Pair>(pool.field_214952_d);
            listOfWeightedPieces.add(new Pair((Object)piece, (Object)weight));
            pool.field_214952_d = listOfWeightedPieces;
        }
    }
}

