/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.items;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbuilder.RFToolsBuilder;
import mcjty.rftoolsbuilder.modules.builder.BuilderConfiguration;
import mcjty.rftoolsbuilder.modules.builder.blocks.SpaceChamberControllerTileEntity;
import mcjty.rftoolsbuilder.modules.builder.client.GuiChamberDetails;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;

public class SpaceChamberCardItem
extends Item
implements ITooltipSettings {
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbuilder.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"cost", this::getCostDescription), TooltipBuilder.parameter((String)"channel", this::getChannelDescription), TooltipBuilder.general((String)"extra", (TextFormatting[])new TextFormatting[]{TextFormatting.GRAY})});

    private String getCostDescription(ItemStack stack) {
        return BuilderConfiguration.builderRfPerOperation.get() + " RF/t per block";
    }

    private String getChannelDescription(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        int channel = -1;
        if (tag != null) {
            channel = tag.func_74762_e("channel");
        }
        if (channel != -1) {
            return "Channel: " + channel;
        }
        return "Channel is not set!";
    }

    public SpaceChamberCardItem() {
        super(new Item.Properties().func_200917_a(1).func_200915_b(0).func_200916_a(RFToolsBuilder.setup.getTab()));
    }

    public void func_77624_a(@Nonnull ItemStack itemStack, World world, @Nonnull List<ITextComponent> list, @Nonnull ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(this.getRegistryName(), itemStack, list, flag);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, PlayerEntity player, @Nonnull Hand hand) {
        if (!player.func_213453_ef()) {
            this.showDetails(world, player, player.func_184586_b(hand));
        }
        return super.func_77659_a(world, player, hand);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        ItemStack stack = player.func_184586_b(hand);
        World level = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        TileEntity te = level.func_175625_s(pos);
        CompoundNBT tagCompound = stack.func_196082_o();
        int channel = -1;
        if (te instanceof SpaceChamberControllerTileEntity) {
            channel = ((SpaceChamberControllerTileEntity)te).getChannel();
        }
        if (channel == -1) {
            this.showDetails(level, player, stack);
        } else {
            tagCompound.func_74768_a("channel", channel);
            if (level.field_72995_K) {
                Logging.message((PlayerEntity)player, (String)("Card is set to channel '" + channel + "'"));
            }
        }
        return ActionResultType.SUCCESS;
    }

    private void showDetails(World world, PlayerEntity player, ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("channel")) {
            int channel = stack.func_77978_p().func_74762_e("channel");
            if (channel != -1) {
                this.showDetailsGui(world, player);
            } else {
                Logging.message((PlayerEntity)player, (String)(TextFormatting.YELLOW + "Card is not linked!"));
            }
        }
    }

    private void showDetailsGui(World world, PlayerEntity player) {
        if (world.field_72995_K) {
            GuiChamberDetails.open();
        }
    }
}

