/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.scanner.network;

import java.util.function.Supplier;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardItem;
import mcjty.rftoolsbuilder.shapes.IFormula;
import mcjty.rftoolsbuilder.shapes.Shape;
import mcjty.rftoolsbuilder.shapes.ShapeDataManagerServer;
import mcjty.rftoolsbuilder.shapes.ShapeID;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketRequestShapeData {
    private ItemStack card;
    private ShapeID id;

    public void toBytes(PacketBuffer buf) {
        buf.func_150788_a(this.card);
        this.id.toBytes(buf);
    }

    public PacketRequestShapeData() {
    }

    public PacketRequestShapeData(PacketBuffer buf) {
        this.card = buf.func_150791_c();
        this.id = new ShapeID(buf);
    }

    public PacketRequestShapeData(ItemStack card, ShapeID id) {
        this.card = card;
        this.id = id;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            Shape shape = ShapeCardItem.getShape(this.card);
            boolean solid = ShapeCardItem.isSolid(this.card);
            BlockPos dimension = ShapeCardItem.getDimension(this.card);
            BlockPos clamped = new BlockPos(Math.min(dimension.func_177958_n(), 512), Math.min(dimension.func_177956_o(), 256), Math.min(dimension.func_177952_p(), 512));
            int dy = clamped.func_177956_o();
            this.card = this.card.func_77946_l();
            IFormula formula = shape.getFormulaFactory().get();
            formula = formula.correctFormula(solid);
            formula.setup((World)ctx.getSender().func_71121_q(), new BlockPos(0, 0, 0), clamped, new BlockPos(0, 0, 0), this.card.func_77978_p());
            for (int y = 0; y < dy; ++y) {
                ShapeDataManagerServer.pushWork(this.id, this.card, y, formula, ctx.getSender());
            }
        });
        ctx.setPacketHandled(true);
    }
}

