/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.scanner.network;

import java.util.List;
import java.util.function.Supplier;
import mcjty.rftoolsbuilder.shapes.BeaconType;
import mcjty.rftoolsbuilder.shapes.ScanDataManagerClient;
import mcjty.rftoolsbuilder.shapes.ScanExtraData;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketReturnExtraData {
    private int scanId;
    private ScanExtraData data;

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.scanId);
        if (this.data == null) {
            buf.writeInt(-1);
        } else {
            List<ScanExtraData.Beacon> beacons = this.data.getBeacons();
            buf.writeInt(beacons.size());
            for (ScanExtraData.Beacon beacon : beacons) {
                buf.func_179255_a(beacon.getPos());
                buf.writeByte(beacon.getType().ordinal());
                buf.writeBoolean(beacon.isDoBeacon());
            }
        }
    }

    public PacketReturnExtraData() {
    }

    public PacketReturnExtraData(PacketBuffer buf) {
        this.scanId = buf.readInt();
        int size = buf.readInt();
        if (size == -1) {
            this.data = null;
        } else {
            this.data = new ScanExtraData();
            for (int i = 0; i < size; ++i) {
                BlockPos pos = buf.func_179259_c();
                BeaconType type = BeaconType.VALUES[buf.readByte()];
                boolean doBeacon = buf.readBoolean();
                this.data.addBeacon(pos, type, doBeacon);
            }
        }
    }

    public PacketReturnExtraData(int scanId, ScanExtraData extraData) {
        this.scanId = scanId;
        this.data = extraData;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> ScanDataManagerClient.getScansClient().registerExtraDataFromServer(this.scanId, this.data));
        ctx.setPacketHandled(true);
    }
}

