/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.shapes;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.lib.varia.Check32;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardItem;
import mcjty.rftoolsbuilder.modules.scanner.ScannerConfiguration;
import mcjty.rftoolsbuilder.modules.scanner.network.PacketRequestShapeData;
import mcjty.rftoolsbuilder.setup.RFToolsBuilderMessages;
import mcjty.rftoolsbuilder.shapes.BeaconType;
import mcjty.rftoolsbuilder.shapes.IShapeParentGui;
import mcjty.rftoolsbuilder.shapes.RenderData;
import mcjty.rftoolsbuilder.shapes.ScanDataManagerClient;
import mcjty.rftoolsbuilder.shapes.ScanExtraData;
import mcjty.rftoolsbuilder.shapes.ShapeBlockInfo;
import mcjty.rftoolsbuilder.shapes.ShapeDataManagerClient;
import mcjty.rftoolsbuilder.shapes.ShapeID;
import net.minecraft.block.BlockState;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHelper;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class ShapeRenderer {
    private int prevX = -1;
    private int prevY = -1;
    private float scale = 3.0f;
    private float dx = 230.0f;
    private float dy = 100.0f;
    private float xangle = 25.0f;
    private float yangle = 25.0f;
    private float zangle = 0.0f;
    private ShapeID shapeID;
    private int waitForNewRequest = 0;
    private static Vector3d offset = new Vector3d(0.0, 0.0, 0.0);
    private int extraDataCounter = 0;
    private static RenderData.RenderElement[] beaconElement = null;
    private static RenderData.RenderElement[] beaconElementBeacon = null;

    public ShapeRenderer(ShapeID shapeID) {
        this.shapeID = shapeID;
    }

    public void setShapeID(ShapeID shapeID) {
        this.shapeID = shapeID;
    }

    public ShapeID getShapeID() {
        return this.shapeID;
    }

    public int getCount() {
        RenderData data = ShapeDataManagerClient.getRenderData(this.shapeID);
        if (data != null) {
            return data.getBlockCount();
        }
        return 0;
    }

    public static RenderData getRenderDataAndCreate(ShapeID shapeID) {
        RenderData data = ShapeDataManagerClient.getRenderDataAndCreate(shapeID);
        data.touch();
        return data;
    }

    public static void setRenderData(ShapeID id, @Nullable RenderData.RenderPlane plane, int offsetY, int dy, String msg) {
        RenderData data = ShapeRenderer.getRenderDataAndCreate(id);
        data.setPlaneData(plane, offsetY, dy);
        data.previewMessage = msg;
    }

    public void initView(int dx, int dy) {
        Minecraft mc = Minecraft.func_71410_x();
        MainWindow mainWindow = mc.func_228018_at_();
        int xScale = mainWindow.func_198107_o();
        int yScale = mainWindow.func_198087_p();
        int sx = (dx + 84) * mainWindow.func_198105_m() / xScale;
        int sy = mainWindow.func_198083_n() - (dy + 136) * mainWindow.func_198083_n() / yScale;
        int sw = 161 * mainWindow.func_198105_m() / xScale;
        int sh = 130 * mainWindow.func_198083_n() / yScale;
        int vx = sx + sw / 2;
        int vy = sy + sh / 2;
        this.dx = (float)((double)vx / mainWindow.func_198100_s());
        this.dy = (float)((double)vy / mainWindow.func_198100_s());
    }

    public void handleShapeDragging(int x, int y, boolean[] buttons) {
        MouseHelper mouse = Minecraft.func_71410_x().field_71417_B;
        if (x >= 100 && y <= 120) {
            if (SafeClientTools.isSneaking()) {
                if (this.prevX != -1 && buttons[0]) {
                    this.dx += (float)(x - this.prevX);
                    this.dy += (float)(y - this.prevY);
                }
            } else if (this.prevX != -1 && buttons[0]) {
                this.yangle -= (float)(x - this.prevX);
                this.xangle += (float)(y - this.prevY);
            }
            this.prevX = x;
            this.prevY = y;
        }
        if (buttons[2]) {
            this.xangle = 0.0f;
            this.yangle = 0.0f;
        }
    }

    public void handleMouseWheel(double dwheel) {
        if (dwheel < 0.0) {
            this.scale = (float)((double)this.scale * 0.6);
            if ((double)this.scale <= 0.1) {
                this.scale = 0.1f;
            }
        } else if (dwheel > 0.0) {
            this.scale = (float)((double)this.scale * 1.4);
        }
    }

    public boolean renderShapeInWorld(ItemStack stack, double x, double y, double z, float offset, float scale, float angle, boolean scan, ShapeID shape) {
        GlStateManager.func_227626_N_();
        GlStateManager.func_227688_c_((float)((float)x + 0.5f), (float)((float)y + 1.0f + offset), (float)((float)z + 0.5f));
        GlStateManager.func_227672_b_((float)scale, (float)scale, (float)scale);
        GlStateManager.func_227689_c_((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        Minecraft.func_71410_x().field_71460_t.func_228384_l_().func_205108_b();
        GlStateManager.func_227737_l_();
        GlStateManager.func_227771_z_();
        GlStateManager.func_227722_g_();
        GlStateManager.func_227621_I_();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        boolean doSound = this.renderFacesInWorld(buffer, stack, scan, shape.isGrayscale(), shape.getScanId());
        GlStateManager.func_227619_H_();
        GlStateManager.func_227737_l_();
        GlStateManager.func_227716_f_();
        Minecraft.func_71410_x().field_71460_t.func_228384_l_().func_205109_c();
        GlStateManager.func_227627_O_();
        return doSound;
    }

    public void renderShape(MatrixStack matrixStack, IShapeParentGui gui, ItemStack stack, int x, int y, boolean showAxis, boolean showOuter, boolean showScan, boolean showGuidelines) {
        ShapeRenderer.setupScissor(gui);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)this.dx, (double)this.dy, 200.0);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f - this.xangle));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(this.yangle));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(this.zangle));
        matrixStack.func_227862_a_(-this.scale, this.scale, this.scale);
        RenderSystem.disableBlend();
        RenderSystem.disableCull();
        RenderSystem.disableTexture();
        RenderSystem.disableLighting();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GL11.glEnable((int)3089);
        this.renderFacesForGui(tessellator, buffer, stack, showScan, false, -1);
        BlockPos dimension = ShapeCardItem.getDimension(stack);
        this.renderHelpers(tessellator, buffer, dimension.func_177958_n(), dimension.func_177956_o(), dimension.func_177952_p(), showAxis, showOuter);
        GL11.glDisable((int)3089);
        matrixStack.func_227865_b_();
        if (showGuidelines) {
            RenderSystem.lineWidth((float)3.0f);
            buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            buffer.func_225582_a_((double)(x - 62), (double)(y + 180), 0.0).func_227885_a_(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            buffer.func_225582_a_((double)(x - 39), (double)(y + 180), 0.0).func_227885_a_(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            buffer.func_225582_a_((double)(x - 62), (double)(y + 195), 0.0).func_227885_a_(0.0f, 0.8f, 0.0f, 1.0f).func_181675_d();
            buffer.func_225582_a_((double)(x - 39), (double)(y + 195), 0.0).func_227885_a_(0.0f, 0.8f, 0.0f, 1.0f).func_181675_d();
            buffer.func_225582_a_((double)(x - 62), (double)(y + 210), 0.0).func_227885_a_(0.0f, 0.0f, 1.0f, 1.0f).func_181675_d();
            buffer.func_225582_a_((double)(x - 39), (double)(y + 210), 0.0).func_227885_a_(0.0f, 0.0f, 1.0f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
        }
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        RenderHelper.func_227780_a_();
        RenderData data = ShapeDataManagerClient.getRenderData(this.shapeID);
        if (data != null && !data.previewMessage.isEmpty()) {
            Minecraft.func_71410_x().field_71466_p.func_238421_b_(matrixStack, data.previewMessage, (float)(gui.getPreviewLeft() + 84), (float)(gui.getPreviewTop() + 50), -65536);
        }
    }

    private void renderHelpers(Tessellator tessellator, BufferBuilder buffer, int xlen, int ylen, int zlen, boolean showAxis, boolean showOuter) {
        if (showAxis) {
            ShapeRenderer.renderAxis(tessellator, buffer, xlen / 2, ylen / 2, zlen / 2);
        }
        if (showOuter) {
            ShapeRenderer.renderOuterBox(tessellator, buffer, xlen, ylen, zlen);
        }
    }

    private void renderHelpersInGui(Tessellator tessellator, BufferBuilder buffer, int xlen, int ylen, int zlen, boolean showAxis, boolean showOuter) {
        if (showAxis) {
            ShapeRenderer.renderAxisInGui(tessellator, buffer, xlen / 2, ylen / 2, zlen / 2);
        }
        if (showOuter) {
            ShapeRenderer.renderOuterBoxInGui(tessellator, buffer, xlen, ylen, zlen);
        }
    }

    private static Vector3d setOffset(double x, double y, double z) {
        Vector3d old = offset;
        offset = new Vector3d(x, y, z);
        return old;
    }

    private static void restoreOffset(Vector3d prev) {
        offset = prev;
    }

    private static void add(BufferBuilder buffer, double x, double y, double z) {
        buffer.func_225582_a_(x + ShapeRenderer.offset.field_72450_a, y + ShapeRenderer.offset.field_72448_b, z + ShapeRenderer.offset.field_72449_c).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
    }

    private static void add(BufferBuilder buffer, double x, double y, double z, float r, float g, float b, float a) {
        buffer.func_225582_a_(x + ShapeRenderer.offset.field_72450_a, y + ShapeRenderer.offset.field_72448_b, z + ShapeRenderer.offset.field_72449_c).func_227885_a_(r, g, b, a).func_181675_d();
    }

    static void renderOuterBox(Tessellator tessellator, BufferBuilder buffer, int xlen, int ylen, int zlen) {
        RenderSystem.lineWidth((float)1.0f);
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        Vector3d origOffset = ShapeRenderer.setOffset(0.5, 0.5, 0.5);
        int xleft = -xlen / 2;
        int xright = xlen / 2 + (xlen & 1);
        int ybot = -ylen / 2;
        int ytop = ylen / 2 + (ylen & 1);
        int zsouth = -zlen / 2;
        int znorth = zlen / 2 + (zlen & 1);
        ShapeRenderer.add(buffer, xleft, ybot, zsouth);
        ShapeRenderer.add(buffer, xright, ybot, zsouth);
        ShapeRenderer.add(buffer, xleft, ybot, zsouth);
        ShapeRenderer.add(buffer, xleft, ytop, zsouth);
        ShapeRenderer.add(buffer, xleft, ybot, zsouth);
        ShapeRenderer.add(buffer, xleft, ybot, znorth);
        ShapeRenderer.add(buffer, xright, ytop, znorth);
        ShapeRenderer.add(buffer, xleft, ytop, znorth);
        ShapeRenderer.add(buffer, xright, ytop, znorth);
        ShapeRenderer.add(buffer, xright, ybot, znorth);
        ShapeRenderer.add(buffer, xright, ytop, znorth);
        ShapeRenderer.add(buffer, xright, ytop, zsouth);
        ShapeRenderer.add(buffer, xright, ybot, zsouth);
        ShapeRenderer.add(buffer, xright, ybot, znorth);
        ShapeRenderer.add(buffer, xright, ybot, zsouth);
        ShapeRenderer.add(buffer, xright, ytop, zsouth);
        ShapeRenderer.add(buffer, xleft, ytop, zsouth);
        ShapeRenderer.add(buffer, xright, ytop, zsouth);
        ShapeRenderer.add(buffer, xleft, ytop, zsouth);
        ShapeRenderer.add(buffer, xleft, ytop, znorth);
        ShapeRenderer.add(buffer, xleft, ytop, znorth);
        ShapeRenderer.add(buffer, xleft, ybot, znorth);
        ShapeRenderer.add(buffer, xleft, ybot, znorth);
        ShapeRenderer.add(buffer, xright, ybot, znorth);
        ShapeRenderer.restoreOffset(origOffset);
        tessellator.func_78381_a();
    }

    static void renderOuterBoxInGui(Tessellator tessellator, BufferBuilder buffer, int xlen, int ylen, int zlen) {
        RenderSystem.lineWidth((float)1.0f);
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        Vector3d origOffset = ShapeRenderer.setOffset(0.5, 0.5, 0.5);
        int xleft = -xlen / 2;
        int xright = xlen / 2 + (xlen & 1);
        int ybot = -ylen / 2;
        int ytop = ylen / 2 + (ylen & 1);
        int zsouth = -zlen / 2;
        int znorth = zlen / 2 + (zlen & 1);
        ShapeRenderer.add(buffer, xleft, ybot, zsouth);
        ShapeRenderer.add(buffer, xright, ybot, zsouth);
        ShapeRenderer.add(buffer, xleft, ybot, zsouth);
        ShapeRenderer.add(buffer, xleft, ytop, zsouth);
        ShapeRenderer.add(buffer, xleft, ybot, zsouth);
        ShapeRenderer.add(buffer, xleft, ybot, znorth);
        ShapeRenderer.add(buffer, xright, ytop, znorth);
        ShapeRenderer.add(buffer, xleft, ytop, znorth);
        ShapeRenderer.add(buffer, xright, ytop, znorth);
        ShapeRenderer.add(buffer, xright, ybot, znorth);
        ShapeRenderer.add(buffer, xright, ytop, znorth);
        ShapeRenderer.add(buffer, xright, ytop, zsouth);
        ShapeRenderer.add(buffer, xright, ybot, zsouth);
        ShapeRenderer.add(buffer, xright, ybot, znorth);
        ShapeRenderer.add(buffer, xright, ybot, zsouth);
        ShapeRenderer.add(buffer, xright, ytop, zsouth);
        ShapeRenderer.add(buffer, xleft, ytop, zsouth);
        ShapeRenderer.add(buffer, xright, ytop, zsouth);
        ShapeRenderer.add(buffer, xleft, ytop, zsouth);
        ShapeRenderer.add(buffer, xleft, ytop, znorth);
        ShapeRenderer.add(buffer, xleft, ytop, znorth);
        ShapeRenderer.add(buffer, xleft, ybot, znorth);
        ShapeRenderer.add(buffer, xleft, ybot, znorth);
        ShapeRenderer.add(buffer, xright, ybot, znorth);
        ShapeRenderer.restoreOffset(origOffset);
        tessellator.func_78381_a();
    }

    static void renderAxisInGui(Tessellator tessellator, BufferBuilder buffer, int xlen, int ylen, int zlen) {
        RenderSystem.lineWidth((float)2.5f);
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        Vector3d origOffset = ShapeRenderer.setOffset(0.5, 0.5, 0.5);
        ShapeRenderer.add(buffer, 0.0, 0.0, 0.0, 1.0f, 0.0f, 0.0f, 1.0f);
        ShapeRenderer.add(buffer, xlen, 0.0, 0.0, 1.0f, 0.0f, 0.0f, 1.0f);
        ShapeRenderer.add(buffer, 0.0, 0.0, 0.0, 0.0f, 1.0f, 0.0f, 1.0f);
        ShapeRenderer.add(buffer, 0.0, ylen, 0.0, 0.0f, 1.0f, 0.0f, 1.0f);
        ShapeRenderer.add(buffer, 0.0, 0.0, 0.0, 0.0f, 0.0f, 1.0f, 1.0f);
        ShapeRenderer.add(buffer, 0.0, 0.0, zlen, 0.0f, 0.0f, 1.0f, 1.0f);
        ShapeRenderer.restoreOffset(origOffset);
        tessellator.func_78381_a();
    }

    static void renderAxis(Tessellator tessellator, BufferBuilder buffer, int xlen, int ylen, int zlen) {
        RenderSystem.lineWidth((float)2.5f);
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        Vector3d origOffset = ShapeRenderer.setOffset(0.5, 0.5, 0.5);
        ShapeRenderer.add(buffer, 0.0, 0.0, 0.0, 1.0f, 0.0f, 0.0f, 1.0f);
        ShapeRenderer.add(buffer, xlen, 0.0, 0.0, 1.0f, 0.0f, 0.0f, 1.0f);
        ShapeRenderer.add(buffer, 0.0, 0.0, 0.0, 0.0f, 1.0f, 0.0f, 1.0f);
        ShapeRenderer.add(buffer, 0.0, ylen, 0.0, 0.0f, 1.0f, 0.0f, 1.0f);
        ShapeRenderer.add(buffer, 0.0, 0.0, 0.0, 0.0f, 0.0f, 1.0f, 1.0f);
        ShapeRenderer.add(buffer, 0.0, 0.0, zlen, 0.0f, 0.0f, 1.0f, 1.0f);
        ShapeRenderer.restoreOffset(origOffset);
        tessellator.func_78381_a();
    }

    private int calculateChecksum(ItemStack stack) {
        Check32 crc = new Check32();
        if (!stack.func_190926_b()) {
            ShapeCardItem.getFormulaCheckClient(stack, crc);
        }
        return crc.get();
    }

    private boolean renderFacesInWorld(BufferBuilder buffer, ItemStack stack, boolean showScan, boolean grayscale, int scanId) {
        int recursiveScanId;
        RenderData data = ShapeRenderer.getRenderDataAndCreate(this.shapeID);
        if (data.isWantData() || this.waitForNewRequest > 0) {
            if (this.waitForNewRequest <= 0) {
                RFToolsBuilderMessages.INSTANCE.sendToServer((Object)new PacketRequestShapeData(stack, this.shapeID));
                this.waitForNewRequest = 20;
                data.setWantData(false);
            } else {
                --this.waitForNewRequest;
            }
        } else {
            long check = this.calculateChecksum(stack);
            if (!data.hasData() || check != data.getChecksum()) {
                data.setChecksum(check);
                data.setWantData(true);
            }
        }
        boolean needScanSound = false;
        if (data.getPlanes() != null) {
            long time = System.currentTimeMillis();
            for (RenderData.RenderPlane plane : data.getPlanes()) {
                boolean flash;
                if (plane == null) continue;
                if (plane.isDirty()) {
                    this.createRenderData(plane, data, grayscale);
                    plane.markClean();
                }
                boolean bl = flash = showScan && plane.getBirthtime() > time - (long)((Integer)ScannerConfiguration.projectorFlashTimeout.get()).intValue();
                if (flash) {
                    needScanSound = true;
                    GlStateManager.func_227740_m_();
                    GlStateManager.func_227676_b_((int)1, (int)1);
                }
                plane.render();
                if (!flash) continue;
                GlStateManager.func_227737_l_();
                GlStateManager.func_227676_b_((int)770, (int)771);
            }
        }
        if ((recursiveScanId = ShapeCardItem.getScanIdRecursive(stack)) > 0) {
            --this.extraDataCounter;
            if (this.extraDataCounter <= 0) {
                this.extraDataCounter = 10;
                ScanDataManagerClient.getScansClient().requestExtraDataClient(recursiveScanId);
            }
            ScanExtraData extraData = ScanDataManagerClient.getScansClient().getExtraDataClient(recursiveScanId);
            for (ScanExtraData.Beacon beacon : extraData.getBeacons()) {
                int x = beacon.getPos().func_177958_n();
                int y = beacon.getPos().func_177956_o() + 1;
                int z = beacon.getPos().func_177952_p();
                BeaconType type = beacon.getType();
                GlStateManager.func_227688_c_((float)x, (float)y, (float)z);
                RenderData.RenderElement element = ShapeRenderer.getBeaconElement(buffer, type, beacon.isDoBeacon());
                element.render();
                GlStateManager.func_227688_c_((float)(-x), (float)(-y), (float)(-z));
            }
        }
        return needScanSound;
    }

    private boolean renderFacesForGui(Tessellator tessellator, BufferBuilder buffer, ItemStack stack, boolean showScan, boolean grayscale, int scanId) {
        int recursiveScanId;
        RenderData data = ShapeRenderer.getRenderDataAndCreate(this.shapeID);
        if (data.isWantData() || this.waitForNewRequest > 0) {
            if (this.waitForNewRequest <= 0) {
                RFToolsBuilderMessages.INSTANCE.sendToServer((Object)new PacketRequestShapeData(stack, this.shapeID));
                this.waitForNewRequest = 20;
                data.setWantData(false);
            } else {
                --this.waitForNewRequest;
            }
        } else {
            long check = this.calculateChecksum(stack);
            if (!data.hasData() || check != data.getChecksum()) {
                data.setChecksum(check);
                data.setWantData(true);
            }
        }
        boolean needScanSound = false;
        if (data.getPlanes() != null) {
            long time = System.currentTimeMillis();
            for (RenderData.RenderPlane plane : data.getPlanes()) {
                boolean flash;
                if (plane == null) continue;
                if (plane.isDirty()) {
                    this.createRenderData(plane, data, grayscale);
                    plane.markClean();
                }
                boolean bl = flash = showScan && plane.getBirthtime() > time - (long)((Integer)ScannerConfiguration.projectorFlashTimeout.get()).intValue();
                if (flash) {
                    needScanSound = true;
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc((int)1, (int)1);
                }
                plane.render();
                if (!flash) continue;
                RenderSystem.disableBlend();
                RenderSystem.blendFunc((int)770, (int)771);
            }
        }
        if ((recursiveScanId = ShapeCardItem.getScanIdRecursive(stack)) > 0) {
            --this.extraDataCounter;
            if (this.extraDataCounter <= 0) {
                this.extraDataCounter = 10;
                ScanDataManagerClient.getScansClient().requestExtraDataClient(recursiveScanId);
            }
            ScanExtraData extraData = ScanDataManagerClient.getScansClient().getExtraDataClient(recursiveScanId);
            for (ScanExtraData.Beacon beacon : extraData.getBeacons()) {
                int x = beacon.getPos().func_177958_n();
                int y = beacon.getPos().func_177956_o() + 1;
                int z = beacon.getPos().func_177952_p();
                BeaconType type = beacon.getType();
                RenderSystem.translatef((float)x, (float)y, (float)z);
                RenderData.RenderElement element = ShapeRenderer.getBeaconElement(buffer, type, beacon.isDoBeacon());
                element.render();
                RenderSystem.translatef((float)(-x), (float)(-y), (float)(-z));
            }
        }
        return needScanSound;
    }

    private void createRenderData(RenderData.RenderPlane plane, RenderData data, boolean grayscale) {
        HashMap<BlockState, ShapeBlockInfo> palette = new HashMap<BlockState, ShapeBlockInfo>();
        int avgcnt = 0;
        int total = 0;
        int y = plane.getY();
        int offsety = plane.getOffsety();
        data.createRenderList(offsety);
        RenderData.vboBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        for (RenderData.RenderStrip strip : plane.getStrips()) {
            int z = plane.getStartz();
            int x = strip.getX();
            List<Pair<Integer, BlockState>> columnData = strip.getData();
            for (int i = 0; i < columnData.size(); ++i) {
                Pair<Integer, BlockState> pair = columnData.get(i);
                int cnt = (Integer)pair.getKey();
                BlockState state = (BlockState)pair.getValue();
                if (state != null) {
                    ShapeBlockInfo.IBlockRender bd;
                    Vector3d origOffset = ShapeRenderer.setOffset(x, y, z);
                    avgcnt += cnt;
                    ++total;
                    ShapeBlockInfo info = ShapeBlockInfo.getBlockInfo(palette, state);
                    ShapeBlockInfo.Col col = info.getCol();
                    float r = col.getR();
                    float g = col.getG();
                    float b = col.getB();
                    if (grayscale) {
                        float a;
                        g = b = (a = 0.21f * r + 0.72f * g + 0.07f * b);
                        r = b;
                    }
                    if ((bd = info.getRender()) == null) {
                        ShapeRenderer.addSideFullTextureU(RenderData.vboBuffer, cnt, r * 0.8f, g * 0.8f, b * 0.8f);
                        ShapeRenderer.addSideFullTextureD(RenderData.vboBuffer, cnt, r * 0.8f, g * 0.8f, b * 0.8f);
                        if (strip.isEmptyAt(i - 1, palette)) {
                            ShapeRenderer.addSideFullTextureN(RenderData.vboBuffer, cnt, r * 1.2f, g * 1.2f, b * 1.2f);
                        }
                        if (strip.isEmptyAt(i + 1, palette)) {
                            ShapeRenderer.addSideFullTextureS(RenderData.vboBuffer, cnt, r * 1.2f, g * 1.2f, b * 1.2f);
                        }
                        ShapeRenderer.addSideFullTextureW(RenderData.vboBuffer, cnt, r, g, b);
                        ShapeRenderer.addSideFullTextureE(RenderData.vboBuffer, cnt, r, g, b);
                    } else {
                        for (int c = 0; c < cnt; ++c) {
                            bd.render(RenderData.vboBuffer, c, r, g, b);
                        }
                    }
                    ShapeRenderer.restoreOffset(origOffset);
                }
                z += cnt;
            }
        }
        data.performRenderToList(offsety);
    }

    private static RenderData.RenderElement getBeaconElement(BufferBuilder buffer, BeaconType type, boolean doBeacon) {
        RenderData.RenderElement[] elements;
        if (beaconElement == null) {
            beaconElement = new RenderData.RenderElement[BeaconType.VALUES.length];
            beaconElementBeacon = new RenderData.RenderElement[BeaconType.VALUES.length];
            for (int i = 0; i < BeaconType.VALUES.length; ++i) {
                ShapeRenderer.beaconElement[i] = null;
                ShapeRenderer.beaconElementBeacon[i] = null;
            }
        }
        if ((elements = doBeacon ? beaconElementBeacon : beaconElement)[type.ordinal()] == null) {
            elements[type.ordinal()] = new RenderData.RenderElement();
            elements[type.ordinal()].createRenderList();
            GlStateManager.func_227701_d_((float)3.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            float r = type.getR();
            float g = type.getG();
            float b = type.getB();
            Vector3d origOffset = ShapeRenderer.setOffset(0.0, -0.7f, 0.0);
            ShapeRenderer.addSideN(buffer, r, g, b, 0.3f);
            ShapeRenderer.addSideS(buffer, r, g, b, 0.3f);
            ShapeRenderer.addSideW(buffer, r, g, b, 0.3f);
            ShapeRenderer.addSideE(buffer, r, g, b, 0.3f);
            ShapeRenderer.addSideU(buffer, r, g, b, 0.3f);
            ShapeRenderer.addSideD(buffer, r, g, b, 0.3f);
            ShapeRenderer.restoreOffset(origOffset);
            origOffset = ShapeRenderer.setOffset(0.0, -0.2f, 0.0);
            ShapeRenderer.addSideN(buffer, r, g, b, 0.2f);
            ShapeRenderer.addSideS(buffer, r, g, b, 0.2f);
            ShapeRenderer.addSideW(buffer, r, g, b, 0.2f);
            ShapeRenderer.addSideE(buffer, r, g, b, 0.2f);
            ShapeRenderer.addSideU(buffer, r, g, b, 0.2f);
            ShapeRenderer.addSideD(buffer, r, g, b, 0.2f);
            ShapeRenderer.restoreOffset(origOffset);
            if (doBeacon) {
                origOffset = ShapeRenderer.setOffset(0.0, 0.2f, 0.0);
                ShapeRenderer.addSideN(buffer, r, g, b, 0.1f, ((Integer)ScannerConfiguration.locatorBeaconHeight.get()).intValue());
                ShapeRenderer.addSideS(buffer, r, g, b, 0.1f, ((Integer)ScannerConfiguration.locatorBeaconHeight.get()).intValue());
                ShapeRenderer.addSideW(buffer, r, g, b, 0.1f, ((Integer)ScannerConfiguration.locatorBeaconHeight.get()).intValue());
                ShapeRenderer.addSideE(buffer, r, g, b, 0.1f, ((Integer)ScannerConfiguration.locatorBeaconHeight.get()).intValue());
                ShapeRenderer.restoreOffset(origOffset);
            }
            elements[type.ordinal()].performRenderToList();
        }
        return elements[type.ordinal()];
    }

    private static void setupScissor(IShapeParentGui gui) {
        Minecraft mc = Minecraft.func_71410_x();
        int xScale = mc.func_228018_at_().func_198107_o();
        int yScale = mc.func_228018_at_().func_198087_p();
        int sx = (gui.getPreviewLeft() + 84) * mc.func_228018_at_().func_198105_m() / xScale;
        int sy = mc.func_228018_at_().func_198083_n() - (gui.getPreviewTop() + 136) * mc.func_228018_at_().func_198083_n() / yScale;
        int sw = 161 * mc.func_228018_at_().func_198105_m() / xScale;
        int sh = 130 * mc.func_228018_at_().func_198083_n() / yScale;
        GL11.glScissor((int)sx, (int)sy, (int)sw, (int)sh);
    }

    public static void addSideFullTextureD(BufferBuilder buffer, int cnt, float r, float g, float b) {
        float a = 0.5f;
        buffer.func_225582_a_(0.0, 0.0, 0.0).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_(1.0, 0.0, 0.0).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_(1.0, 0.0, (double)cnt).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_(0.0, 0.0, (double)cnt).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void addSideFullTextureU(BufferBuilder buffer, int cnt, float r, float g, float b) {
        float a = 0.5f;
        buffer.func_225582_a_(0.0, 1.0, (double)cnt).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_(1.0, 1.0, (double)cnt).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_(1.0, 1.0, 0.0).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_(0.0, 1.0, 0.0).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void addSideFullTextureE(BufferBuilder buffer, int cnt, float r, float g, float b) {
        float a = 0.5f;
        buffer.func_225582_a_(1.0, 0.0, 0.0).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_(1.0, 1.0, 0.0).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_(1.0, 1.0, (double)cnt).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_(1.0, 0.0, (double)cnt).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void addSideFullTextureW(BufferBuilder buffer, int cnt, float r, float g, float b) {
        float a = 0.5f;
        buffer.func_225582_a_(0.0, 0.0, (double)cnt).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_(0.0, 1.0, (double)cnt).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_(0.0, 1.0, 0.0).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_(0.0, 0.0, 0.0).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void addSideFullTextureN(BufferBuilder buffer, int cnt, float r, float g, float b) {
        float a = 0.5f;
        buffer.func_225582_a_(1.0, 1.0, 0.0).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_(1.0, 0.0, 0.0).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_(0.0, 0.0, 0.0).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_(0.0, 1.0, 0.0).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void addSideFullTextureS(BufferBuilder buffer, int cnt, float r, float g, float b) {
        float a = 0.5f;
        buffer.func_225582_a_(1.0, 0.0, (double)cnt).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_(1.0, 1.0, (double)cnt).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_(0.0, 1.0, (double)cnt).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_(0.0, 0.0, (double)cnt).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void addSideD(BufferBuilder buffer, float r, float g, float b, float size) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.func_225582_a_((double)l, (double)l, (double)l).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)h, (double)l, (double)l).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)h, (double)l, (double)h).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)l, (double)l, (double)h).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void addSideU(BufferBuilder buffer, float r, float g, float b, float size) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.func_225582_a_((double)l, (double)h, (double)h).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)h, (double)h, (double)h).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)h, (double)h, (double)l).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)l, (double)h, (double)l).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void addSideE(BufferBuilder buffer, float r, float g, float b, float size) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.func_225582_a_((double)h, (double)l, (double)l).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)h, (double)h, (double)l).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)h, (double)h, (double)h).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)h, (double)l, (double)h).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void addSideW(BufferBuilder buffer, float r, float g, float b, float size) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.func_225582_a_((double)l, (double)l, (double)h).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)l, (double)h, (double)h).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)l, (double)h, (double)l).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)l, (double)l, (double)l).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void addSideN(BufferBuilder buffer, float r, float g, float b, float size) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.func_225582_a_((double)h, (double)h, (double)l).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)h, (double)l, (double)l).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)l, (double)l, (double)l).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)l, (double)h, (double)l).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void addSideS(BufferBuilder buffer, float r, float g, float b, float size) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.func_225582_a_((double)h, (double)l, (double)h).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)h, (double)h, (double)h).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)l, (double)h, (double)h).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)l, (double)l, (double)h).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void addSideE(BufferBuilder buffer, float r, float g, float b, float size, float height) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.func_225582_a_((double)h, 0.0, (double)l).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)h, (double)height, (double)l).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)h, (double)height, (double)h).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)h, 0.0, (double)h).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void addSideW(BufferBuilder buffer, float r, float g, float b, float size, float height) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.func_225582_a_((double)l, 0.0, (double)h).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)l, (double)height, (double)h).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)l, (double)height, (double)l).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)l, 0.0, (double)l).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void addSideN(BufferBuilder buffer, float r, float g, float b, float size, float height) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.func_225582_a_((double)h, (double)height, (double)l).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)h, 0.0, (double)l).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)l, 0.0, (double)l).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)l, (double)height, (double)l).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void addSideS(BufferBuilder buffer, float r, float g, float b, float size, float height) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.func_225582_a_((double)h, 0.0, (double)h).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)h, (double)height, (double)h).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)l, (double)height, (double)h).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)l, 0.0, (double)h).func_227885_a_(r, g, b, a).func_181675_d();
    }
}

