/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.client.render.tile;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.block.BlockEnderChest;
import codechicken.enderstorage.client.model.ButtonModelLibrary;
import codechicken.enderstorage.client.model.ModelEnderChest;
import codechicken.enderstorage.client.render.RenderCustomEndPortal;
import codechicken.enderstorage.tile.TileEnderChest;
import codechicken.lib.colour.EnumColour;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCModelLibrary;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.UVTranslation;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;

public class RenderTileEnderChest
extends TileEntityRenderer<TileEnderChest> {
    private static final RenderType chestType = RenderType.func_228638_b_((ResourceLocation)new ResourceLocation("enderstorage:textures/enderchest.png"));
    private static final RenderType buttonType = RenderType.func_228634_a_((ResourceLocation)new ResourceLocation("enderstorage:textures/buttons.png"));
    private static final RenderType pearlType = CCModelLibrary.getIcos4RenderType((ResourceLocation)new ResourceLocation("enderstorage:textures/hedronmap.png"), (boolean)false);
    private static final ModelEnderChest model = new ModelEnderChest();
    private static final RenderCustomEndPortal renderEndPortal = new RenderCustomEndPortal(0.626, 0.188, 0.812, 0.188, 0.812);

    public RenderTileEnderChest(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileEnderChest enderChest, float partialTicks, MatrixStack mStack, IRenderTypeBuffer getter, int packedLight, int packedOverlay) {
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        double yToCamera = (double)enderChest.func_174877_v().func_177956_o() - this.field_228858_b_.field_217666_g.func_216785_c().field_72448_b;
        RenderTileEnderChest.renderChest(ccrs, mStack, getter, enderChest.rotation, yToCamera, enderChest.getFrequency(), (float)enderChest.getRadianLidAngle(partialTicks), RenderUtils.getTimeOffset((BlockPos)enderChest.func_174877_v()));
    }

    public static void renderChest(CCRenderState ccrs, MatrixStack mStack, IRenderTypeBuffer getter, int rotation, double yToCamera, Frequency freq, float lidAngle, int pearlOffset) {
        Matrix4 mat = new Matrix4(mStack);
        if (lidAngle != 0.0f) {
            renderEndPortal.render(mat, getter, yToCamera);
        }
        ccrs.reset();
        mStack.func_227860_a_();
        mStack.func_227861_a_(0.0, 1.0, 1.0);
        mStack.func_227862_a_(1.0f, -1.0f, -1.0f);
        mStack.func_227861_a_(0.5, 0.5, 0.5);
        mStack.func_227863_a_(new Quaternion(0.0f, (float)(rotation * 90), 0.0f, true));
        mStack.func_227861_a_(-0.5, -0.5, -0.5);
        RenderTileEnderChest.model.chestLid.field_78795_f = lidAngle;
        model.render(mStack, getter.getBuffer(chestType), ccrs.brightness, ccrs.overlay, freq.hasOwner());
        mStack.func_227865_b_();
        ccrs.bind(buttonType, getter);
        EnumColour[] colours = freq.toArray();
        for (int i = 0; i < 3; ++i) {
            CCModel button = ButtonModelLibrary.button.copy();
            button.apply(BlockEnderChest.buttonT[i]);
            button.apply((Transformation)new Translation(0.5, 0.0, 0.5));
            button.apply(new Rotation((double)lidAngle, 1.0, 0.0, 0.0).at(new Vector3(0.0, 0.5625, 0.0625)));
            button.apply(new Rotation((double)(-90 * rotation) * 0.017453292519943, Vector3.Y_POS).at(new Vector3(0.5, 0.0, 0.5)));
            button.render(ccrs, new IVertexOperation[]{mat, new UVTranslation(0.25 * (double)(colours[i].getWoolMeta() % 4), 0.25 * (double)(colours[i].getWoolMeta() / 4))});
        }
        mat.translate(0.5, 0.0, 0.5);
        if (lidAngle != 0.0f) {
            double time = ClientUtils.getRenderTime() + (double)pearlOffset;
            Matrix4 pearlMat = RenderUtils.getMatrix((Matrix4)mat.copy(), (Vector3)new Vector3(0.0, 0.2 + (double)lidAngle * -0.5 + (double)RenderUtils.getPearlBob((double)time), 0.0), (Rotation)new Rotation(time / 3.0, new Vector3(0.0, 1.0, 0.0)), (double)0.04);
            ccrs.brightness = 0xF000F0;
            ccrs.bind(pearlType, getter);
            CCModelLibrary.icosahedron4.render(ccrs, new IVertexOperation[]{pearlMat});
        }
        ccrs.reset();
    }
}

