/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.client.render.tile;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.block.BlockEnderTank;
import codechicken.enderstorage.client.model.ButtonModelLibrary;
import codechicken.enderstorage.client.render.RenderCustomEndPortal;
import codechicken.enderstorage.tile.TileEnderTank;
import codechicken.lib.colour.EnumColour;
import codechicken.lib.fluid.FluidUtils;
import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCModelLibrary;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.SwapYZ;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.UVTranslation;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;

public class RenderTileEnderTank
extends TileEntityRenderer<TileEnderTank> {
    private static final RenderType baseType = RenderType.func_228638_b_((ResourceLocation)new ResourceLocation("enderstorage:textures/endertank.png"));
    private static final RenderType buttonType = RenderType.func_228634_a_((ResourceLocation)new ResourceLocation("enderstorage:textures/buttons.png"));
    private static final RenderType pearlType = CCModelLibrary.getIcos4RenderType((ResourceLocation)new ResourceLocation("enderstorage:textures/hedronmap.png"), (boolean)false);
    public static final CCModel tankModel;
    public static final CCModel valveModel;
    public static final CCModel[] buttons;
    public static final RenderCustomEndPortal renderEndPortal;

    public RenderTileEnderTank(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(TileEnderTank enderTank, float partialTicks, MatrixStack mStack, IRenderTypeBuffer getter, int packedLight, int packedOverlay) {
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        float valveRot = (float)MathHelper.interpolate((double)enderTank.pressure_state.b_rotate, (double)enderTank.pressure_state.a_rotate, (double)partialTicks) * 0.01745f;
        int pearlOffset = RenderUtils.getTimeOffset((BlockPos)enderTank.func_174877_v());
        Matrix4 mat = new Matrix4(mStack);
        double yToCamera = (double)enderTank.func_174877_v().func_177956_o() - this.field_228858_b_.field_217666_g.func_216785_c().field_72448_b;
        RenderTileEnderTank.renderTank(ccrs, mat.copy(), getter, enderTank.rotation, valveRot, yToCamera, enderTank.getFrequency(), pearlOffset);
        RenderTileEnderTank.renderFluid(ccrs, mat, getter, enderTank.liquid_state.c_liquid);
        ccrs.reset();
    }

    public static void renderTank(CCRenderState ccrs, Matrix4 mat, IRenderTypeBuffer getter, int rotation, float valveRot, double yToCamera, Frequency freq, int pearlOffset) {
        renderEndPortal.render(mat, getter, yToCamera);
        ccrs.reset();
        mat.translate(0.5, 0.0, 0.5);
        mat.rotate((double)(-90 * (rotation + 2)) * 0.017453292519943, Vector3.Y_POS);
        ccrs.bind(baseType, getter);
        tankModel.render(ccrs, new IVertexOperation[]{mat});
        Matrix4 valveMat = mat.copy().apply(new Rotation((double)valveRot, Vector3.Z_POS).at(new Vector3(0.0, 0.4165, 0.0)));
        valveModel.render(ccrs, new IVertexOperation[]{valveMat, new UVTranslation(0.0, freq.hasOwner() ? 0.203125 : 0.0)});
        ccrs.bind(buttonType, getter);
        EnumColour[] colours = freq.toArray();
        for (int i = 0; i < 3; ++i) {
            buttons[i].render(ccrs, new IVertexOperation[]{mat, new UVTranslation(0.25 * (double)(colours[i].getWoolMeta() % 4), 0.25 * (double)(colours[i].getWoolMeta() / 4))});
        }
        double time = ClientUtils.getRenderTime() + (double)pearlOffset;
        Matrix4 pearlMat = RenderUtils.getMatrix((Matrix4)mat.copy(), (Vector3)new Vector3(0.0, 0.45 + (double)(RenderUtils.getPearlBob((double)time) * 2.0f), 0.0), (Rotation)new Rotation(time / 3.0, Vector3.Y_POS), (double)0.04);
        ccrs.brightness = 0xF000F0;
        ccrs.bind(pearlType, getter);
        CCModelLibrary.icosahedron4.render(ccrs, new IVertexOperation[]{pearlMat});
        ccrs.reset();
    }

    public static void renderFluid(CCRenderState ccrs, Matrix4 mat, IRenderTypeBuffer getter, FluidStack stack) {
        RenderUtils.renderFluidCuboid((CCRenderState)ccrs, (Matrix4)mat, (RenderType)RenderUtils.getFluidRenderType(), (IRenderTypeBuffer)getter, (FluidStack)stack, (Cuboid6)new Cuboid6(0.22, 0.12, 0.22, 0.78, 0.751, 0.78), (double)((double)stack.getAmount() / (16.0 * (double)FluidUtils.B)), (double)0.75);
    }

    static {
        renderEndPortal = new RenderCustomEndPortal(0.1205, 0.24, 0.76, 0.24, 0.76);
        Map models = OBJParser.parseModels((ResourceLocation)new ResourceLocation("enderstorage:models/endertank.obj"), (int)7, (Transformation)new SwapYZ());
        Translation fix = new Translation(-0.5099, 0.0, -0.5027);
        valveModel = ((CCModel)models.remove("Valve")).apply((Transformation)fix).computeNormals();
        tankModel = CCModel.combine(models.values()).apply((Transformation)fix).computeNormals().shrinkUVs(0.004);
        buttons = new CCModel[3];
        for (int i = 0; i < 3; ++i) {
            RenderTileEnderTank.buttons[i] = ButtonModelLibrary.button.copy().apply((Transformation)BlockEnderTank.buttonT[i].with((Transformation)new Translation(-0.5, 0.0, -0.5)));
        }
    }
}

