/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.renderer.block.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.stream.IntStream;
import me.paulf.fairylights.client.ClientProxy;
import me.paulf.fairylights.client.renderer.block.entity.ConnectionRenderer;
import me.paulf.fairylights.server.connection.GarlandVineConnection;
import me.paulf.fairylights.util.Catenary;
import me.paulf.fairylights.util.RandomArray;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.vector.Vector3f;

public class GarlandVineRenderer
extends ConnectionRenderer<GarlandVineConnection> {
    private static final int RING_COUNT = 7;
    private static final RandomArray RAND = new RandomArray(8411L, 28);
    private final RingModel[] rings = (RingModel[])IntStream.range(0, 7).mapToObj(i -> new RingModel(i * 8, 64)).toArray(RingModel[]::new);

    protected GarlandVineRenderer() {
        super(39, 0, 1.0f);
    }

    @Override
    protected void render(GarlandVineConnection conn, Catenary catenary, float delta, MatrixStack matrix, IRenderTypeBuffer source, int packedLight, int packedOverlay) {
        super.render(conn, catenary, delta, matrix, source, packedLight, packedOverlay);
        int hash = conn.getUUID().hashCode();
        IVertexBuilder buf = ClientProxy.SOLID_TEXTURE.func_229311_a_(source, RenderType::func_228638_b_);
        catenary.visitPoints(0.25f, false, (index, x, y, z, yaw, pitch) -> {
            matrix.func_227860_a_();
            matrix.func_227861_a_((double)x, (double)y, (double)z);
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(-yaw));
            matrix.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(pitch));
            matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(RAND.get(index + hash) * 45.0f));
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(RAND.get(index + 8 + hash) * 60.0f + 90.0f));
            this.rings[index % 7].func_225598_a_(matrix, buf, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            matrix.func_227865_b_();
        });
    }

    static class RingModel
    extends Model {
        final ModelRenderer root;

        RingModel(int u, int v) {
            super(RenderType::func_228638_b_);
            this.field_78090_t = 128;
            this.field_78089_u = 128;
            this.root = new ModelRenderer((Model)this, 14, 91);
            float size = 4.0f;
            this.root.func_228300_a_(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f);
            ModelRenderer cross = new ModelRenderer((Model)this, u, v);
            cross.field_78808_h = 1.5707964f;
            cross.func_228300_a_(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 0.0f);
            cross.func_228300_a_(-4.0f, 0.0f, -4.0f, 8.0f, 0.0f, 8.0f);
            this.root.func_78792_a(cross);
        }

        public void func_225598_a_(MatrixStack matrix, IVertexBuilder builder, int light, int overlay, float r, float g, float b, float a) {
            this.root.func_228309_a_(matrix, builder, light, overlay, r, g, b, a);
        }
    }
}

