/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.block;

import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.ServerEventHandler;
import me.paulf.fairylights.server.block.entity.FastenerBlockEntity;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.connection.HangingLightsConnection;
import me.paulf.fairylights.server.fastener.accessor.BlockFastenerAccessor;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public final class FastenerBlock
extends DirectionalBlock {
    public static final BooleanProperty TRIGGERED = BlockStateProperties.field_208197_x;
    private static final VoxelShape NORTH_AABB = Block.func_208617_a((double)6.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape SOUTH_AABB = Block.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)4.0);
    private static final VoxelShape WEST_AABB = Block.func_208617_a((double)12.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape EAST_AABB = Block.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)4.0, (double)10.0, (double)10.0);
    private static final VoxelShape DOWN_AABB = Block.func_208617_a((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape UP_AABB = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0);

    public FastenerBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176387_N, (Comparable)Direction.NORTH)).func_206870_a((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_176387_N, TRIGGERED});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)field_176387_N, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)field_176387_N)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.func_206870_a((Property)field_176387_N, (Comparable)mirrorIn.func_185803_b((Direction)state.func_177229_b((Property)field_176387_N)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)field_176387_N)) {
            case NORTH: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case DOWN: {
                return DOWN_AABB;
            }
        }
        return UP_AABB;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FastenerBlockEntity();
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity entity = world.func_175625_s(pos);
            if (entity instanceof FastenerBlockEntity) {
                entity.getCapability(CapabilityHandler.FASTENER_CAP).ifPresent(f -> f.dropItems(world, pos));
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Direction facing = (Direction)state.func_177229_b((Property)field_176387_N);
        BlockPos attachedPos = pos.func_177972_a(facing.func_176734_d());
        BlockState attachedState = world.func_180495_p(attachedPos);
        return attachedState.func_177230_c().func_203417_a((ITag)BlockTags.field_206952_E) || attachedState.func_224755_d((IBlockReader)world, attachedPos, facing) || facing == Direction.UP && attachedState.func_235714_a_((ITag)BlockTags.field_219757_z);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState result = this.func_176223_P();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        for (Direction dir : context.func_196009_e()) {
            if (!(result = (BlockState)result.func_206870_a((Property)field_176387_N, (Comparable)dir.func_176734_d())).func_196955_c((IWorldReader)world, pos)) continue;
            return result;
        }
        return null;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (facing.func_176734_d() == state.func_177229_b((Property)field_176387_N) && !state.func_196955_c((IWorldReader)world, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() != state.func_177230_c() && world.func_175640_z(pos.func_177972_a(((Direction)state.func_177229_b((Property)field_176387_N)).func_176734_d()))) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (state.func_196955_c((IWorldReader)world, pos)) {
            boolean receivingPower = world.func_175640_z(pos);
            boolean isPowered = (Boolean)state.func_177229_b((Property)TRIGGERED);
            if (receivingPower && !isPowered) {
                world.func_205220_G_().func_205360_a(pos, (Object)this, 2);
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
            } else if (!receivingPower && isPowered) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
            }
        } else {
            TileEntity entity = world.func_175625_s(pos);
            FastenerBlock.func_220059_a((BlockState)state, (IWorld)world, (BlockPos)pos, (TileEntity)entity);
            world.func_217377_a(pos, false);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity == null) {
            return super.func_180641_l(state, world, pos);
        }
        return entity.getCapability(CapabilityHandler.FASTENER_CAP).map(f -> f.getAllConnections().stream()).orElse(Stream.empty()).filter(HangingLightsConnection.class::isInstance).map(HangingLightsConnection.class::cast).mapToInt(c -> (int)Math.ceil(c.getJingleProgress() * 15.0f)).max().orElse(0);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        this.jingle((World)world, pos);
    }

    private void jingle(World world, BlockPos pos) {
        TileEntity entity = world.func_175625_s(pos);
        if (!(entity instanceof FastenerBlockEntity)) {
            return;
        }
        entity.getCapability(CapabilityHandler.FASTENER_CAP).ifPresent(fastener -> fastener.getAllConnections().stream().filter(HangingLightsConnection.class::isInstance).map(HangingLightsConnection.class::cast).filter(conn -> conn.canCurrentlyPlayAJingle() && conn.isDestination(new BlockFastenerAccessor(fastener.getPos())) && (Boolean)world.func_180495_p(fastener.getPos()).func_177229_b((Property)TRIGGERED) != false).findFirst().ifPresent(conn -> ServerEventHandler.tryJingle(world, conn, "")));
    }

    public Vector3d getOffset(Direction facing, float offset) {
        return FastenerBlock.getFastenerOffset(facing, offset);
    }

    public static Vector3d getFastenerOffset(Direction facing, float offset) {
        double x = offset;
        double y = offset;
        double z = offset;
        switch (facing) {
            case DOWN: {
                y += 0.75;
            }
            case UP: {
                x += 0.375;
                z += 0.375;
                break;
            }
            case WEST: {
                x += 0.75;
            }
            case EAST: {
                z += 0.375;
                y += 0.375;
                break;
            }
            case NORTH: {
                z += 0.75;
            }
            case SOUTH: {
                x += 0.375;
                y += 0.375;
            }
        }
        return new Vector3d(x, y, z);
    }
}

