/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.block;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.block.entity.LightBlockEntity;
import me.paulf.fairylights.server.item.DyeableItem;
import me.paulf.fairylights.server.item.LightVariant;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LightBlock
extends HorizontalFaceBlock {
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    private static final VoxelShape MIN_ANCHOR_SHAPE = Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private final VoxelShape floorShape;
    private final VoxelShape eastWallShape;
    private final VoxelShape westWallShape;
    private final VoxelShape northWallShape;
    private final VoxelShape southWallShape;
    private final VoxelShape ceilingShape;
    private final LightVariant<?> variant;

    public LightBlock(AbstractBlock.Properties properties, LightVariant<?> variant) {
        super(properties.func_222380_e());
        this.variant = variant;
        AxisAlignedBB bb = this.variant.getBounds();
        double w = Math.max(bb.func_216364_b(), bb.func_216362_d());
        double w0 = 0.5 - w * 0.5;
        double w1 = 0.5 + w * 0.5;
        if (variant.isOrientable()) {
            this.floorShape = VoxelShapes.func_197873_a((double)w0, (double)0.0, (double)w0, (double)w1, (double)(-bb.field_72338_b), (double)w1);
            this.eastWallShape = VoxelShapes.func_197873_a((double)0.0, (double)w0, (double)w0, (double)(-bb.field_72338_b), (double)w1, (double)w1);
            this.westWallShape = VoxelShapes.func_197873_a((double)(1.0 + bb.field_72338_b), (double)w0, (double)w0, (double)1.0, (double)w1, (double)w1);
            this.southWallShape = VoxelShapes.func_197873_a((double)w0, (double)w0, (double)0.0, (double)w1, (double)w1, (double)(-bb.field_72338_b));
            this.northWallShape = VoxelShapes.func_197873_a((double)w0, (double)w0, (double)(1.0 + bb.field_72338_b), (double)w1, (double)w1, (double)1.0);
            this.ceilingShape = VoxelShapes.func_197873_a((double)w0, (double)(1.0 + bb.field_72338_b), (double)w0, (double)w1, (double)1.0, (double)w1);
        } else {
            double t = 0.125;
            double u = 0.6875;
            this.floorShape = VoxelShapes.func_197873_a((double)w0, (double)0.0, (double)w0, (double)w1, (double)(bb.func_216360_c() - this.variant.getFloorOffset()), (double)w1);
            this.eastWallShape = VoxelShapes.func_197873_a((double)(w0 - 0.125), (double)(0.6875 + bb.field_72338_b), (double)w0, (double)(w1 - 0.125), (double)(0.6875 + bb.field_72337_e), (double)w1);
            this.westWallShape = VoxelShapes.func_197873_a((double)(w0 + 0.125), (double)(0.6875 + bb.field_72338_b), (double)w0, (double)(w1 + 0.125), (double)(0.6875 + bb.field_72337_e), (double)w1);
            this.southWallShape = VoxelShapes.func_197873_a((double)w0, (double)(0.6875 + bb.field_72338_b), (double)(w0 - 0.125), (double)w1, (double)(0.6875 + bb.field_72337_e), (double)(w1 - 0.125));
            this.northWallShape = VoxelShapes.func_197873_a((double)w0, (double)(0.6875 + bb.field_72338_b), (double)(w0 + 0.125), (double)w1, (double)(0.6875 + bb.field_72337_e), (double)(w1 + 0.125));
            this.ceilingShape = VoxelShapes.func_197873_a((double)w0, (double)(1.0 + bb.field_72338_b - 0.25), (double)w0, (double)w1, (double)1.0, (double)w1);
        }
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)field_196366_M, (Comparable)AttachFace.WALL)).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true)));
    }

    public LightVariant<?> getVariant() {
        return this.variant;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new LightBlockEntity();
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Direction facing = HorizontalFaceBlock.func_196365_i((BlockState)state);
        BlockPos anchorPos = pos.func_177972_a(facing.func_176734_d());
        VoxelShape shape = world.func_180495_p(anchorPos).func_196952_d((IBlockReader)world, anchorPos);
        if (state.func_177229_b((Property)field_196366_M) != AttachFace.WALL) {
            return !VoxelShapes.func_197879_c((VoxelShape)shape.func_212434_a(facing), (VoxelShape)MIN_ANCHOR_SHAPE, (IBooleanFunction)IBooleanFunction.field_223232_c_);
        }
        return Block.func_208061_a((VoxelShape)shape, (Direction)facing);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        for (Direction dir : context.func_196009_e()) {
            BlockState state = dir.func_176740_k() == Direction.Axis.Y ? (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_196366_M, (Comparable)(dir == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d()) : (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_196366_M, (Comparable)AttachFace.WALL)).func_206870_a((Property)field_185512_D, (Comparable)dir.func_176734_d());
            if (!state.func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) continue;
            return state;
        }
        return null;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof LightBlockEntity) {
            ItemStack lightItem = stack.func_77946_l();
            lightItem.func_190920_e(1);
            ((LightBlockEntity)entity).setItemStack(lightItem);
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity entity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (entity instanceof LightBlockEntity) {
            return Collections.singletonList(((LightBlockEntity)entity).getLight().getItem().func_77946_l());
        }
        return Collections.emptyList();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof LightBlockEntity) {
            ((LightBlockEntity)entity).interact(world, pos, state, player, hand, hit);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rng) {
        super.func_180655_c(state, world, pos, rng);
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof LightBlockEntity) {
            ((LightBlockEntity)entity).animateTick();
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        switch ((AttachFace)state.func_177229_b((Property)field_196366_M)) {
            default: {
                return this.floorShape;
            }
            case WALL: {
                switch ((Direction)state.func_177229_b((Property)field_185512_D)) {
                    default: {
                        return this.eastWallShape;
                    }
                    case WEST: {
                        return this.westWallShape;
                    }
                    case SOUTH: {
                        return this.southWallShape;
                    }
                    case NORTH: 
                }
                return this.northWallShape;
            }
            case CEILING: 
        }
        return this.ceilingShape;
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof LightBlockEntity) {
            return ((LightBlockEntity)entity).getLight().getItem().func_77946_l();
        }
        ItemStack stack = new ItemStack((IItemProvider)this);
        DyeableItem.setColor(stack, DyeColor.YELLOW);
        return stack;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_196366_M, field_185512_D, LIT});
    }
}

