/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.feature.light;

import com.google.common.collect.ImmutableList;
import java.util.function.Supplier;
import me.paulf.fairylights.server.feature.light.DefaultBehavior;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.feature.light.LightBehavior;
import me.paulf.fairylights.server.feature.light.StandardLightBehavior;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class MultiLightBehavior
implements LightBehavior {
    private final ImmutableList<StandardLightBehavior> lights;
    private final DefaultBehavior fallback;

    public MultiLightBehavior(ImmutableList<StandardLightBehavior> lights) {
        this.lights = lights;
        this.fallback = new DefaultBehavior(1.0f, 1.0f, 1.0f);
    }

    public StandardLightBehavior get(int index) {
        if (index >= 0 && index < this.lights.size()) {
            return (StandardLightBehavior)this.lights.get(index);
        }
        return this.fallback;
    }

    @Override
    public void power(boolean powered, boolean now, Light<?> light) {
        for (StandardLightBehavior behvior : this.lights) {
            behvior.power(powered, now, light);
        }
        this.fallback.power(powered, now, light);
    }

    @Override
    public void tick(World world, Vector3d origin, Light<?> light) {
        for (StandardLightBehavior behavior : this.lights) {
            behavior.tick(world, origin, light);
        }
        this.fallback.tick(world, origin, light);
    }

    public static MultiLightBehavior create(int count, Supplier<StandardLightBehavior> factory) {
        ImmutableList.Builder behaviors = new ImmutableList.Builder();
        for (int n = 0; n < count; ++n) {
            behaviors.add((Object)factory.get());
        }
        return new MultiLightBehavior((ImmutableList<StandardLightBehavior>)behaviors.build());
    }
}

