/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.feature.light;

import me.paulf.fairylights.server.feature.light.BrightnessLightBehavior;
import me.paulf.fairylights.server.feature.light.Light;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class TorchLightBehavior
implements BrightnessLightBehavior {
    private final double offset;
    private float value = 1.0f;
    private boolean powered = true;

    public TorchLightBehavior(double offset) {
        this.offset = offset;
    }

    @Override
    public float getBrightness(float delta) {
        return this.value;
    }

    @Override
    public void power(boolean powered, boolean now, Light<?> light) {
        this.powered = powered;
        this.value = this.powered ? 1.0f : 0.0f;
    }

    @Override
    public void tick(World world, Vector3d origin, Light<?> light) {
        if (world.field_73012_v.nextFloat() < 0.08f) {
            this.createParticles(world, origin, light);
        }
    }

    @Override
    public void animateTick(World world, Vector3d origin, Light<?> light) {
        this.createParticles(world, origin, light);
    }

    private void createParticles(World world, Vector3d origin, Light<?> light) {
        if (this.powered) {
            Vector3d p = light.getTransformedPoint(origin, new Vector3d(0.0, -this.offset, 0.0));
            double x = p.func_82615_a();
            double y = p.func_82617_b();
            double z = p.func_82616_c();
            world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x, y, z, 0.0, 0.0, 0.0);
            world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

