/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.integration.jei;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.paulf.fairylights.util.Mth;
import me.paulf.fairylights.util.crafting.GenericRecipe;
import me.paulf.fairylights.util.crafting.ingredient.AuxiliaryIngredient;
import me.paulf.fairylights.util.crafting.ingredient.GenericIngredient;
import me.paulf.fairylights.util.crafting.ingredient.RegularIngredient;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICustomCraftingCategoryExtension;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.util.Size2i;
import org.apache.logging.log4j.LogManager;

public final class GenericRecipeWrapper
implements ICustomCraftingCategoryExtension {
    private final GenericRecipe recipe;
    private final ImmutableList<ImmutableList<ItemStack>> allInputs;
    private final ImmutableList<ImmutableList<ItemStack>> minimalInputStacks;
    private final ImmutableList<ItemStack> outputs;
    private final GenericIngredient<?, ?>[] ingredientMatrix;
    private final int subtypeIndex;

    public GenericRecipeWrapper(GenericRecipe recipe) {
        this.recipe = recipe;
        ImmutableList.Builder allInputs = ImmutableList.builder();
        ImmutableList.Builder minimalInputStacks = ImmutableList.builder();
        RegularIngredient[] ingredients = recipe.getGenericIngredients();
        AuxiliaryIngredient<?>[] aux = recipe.getAuxiliaryIngredients();
        this.ingredientMatrix = new GenericIngredient[9];
        int subtypeIndex = -1;
        int auxIdx = 0;
        for (int i = 0; i < 9; ++i) {
            GenericIngredient<RegularIngredient, GenericRecipe.MatchResultRegular> ingredient;
            ImmutableList<ItemStack> ingInputs;
            int x = i % 3;
            int y = i / 3;
            boolean isEmpty = true;
            if (x < recipe.getWidth() && y < recipe.getHeight() && (ingInputs = (ingredient = ingredients[x + y * recipe.getWidth()]).getInputs()).size() > 0) {
                if (ingredient.dictatesOutputType()) {
                    minimalInputStacks.add(ingInputs);
                    subtypeIndex = i;
                } else {
                    minimalInputStacks.add((Object)ImmutableList.of((Object)ingInputs.get(0)));
                }
                this.ingredientMatrix[i] = ingredient;
                allInputs.add(ingInputs);
                isEmpty = false;
            }
            if (!isEmpty) continue;
            ingredient = null;
            ImmutableList<ItemStack> stacks = null;
            boolean dictator = false;
            while (auxIdx < aux.length) {
                ImmutableList<ItemStack> a;
                if ((a = (ingredient = aux[auxIdx++]).getInputs()).size() <= 0) continue;
                stacks = a;
                if (!ingredient.dictatesOutputType()) break;
                subtypeIndex = i;
                dictator = true;
                break;
            }
            if (stacks == null) {
                stacks = ImmutableList.of();
                ingredient = null;
            }
            minimalInputStacks.add(stacks.isEmpty() || dictator ? stacks : ImmutableList.of((Object)stacks.get(0)));
            this.ingredientMatrix[i] = ingredient;
            allInputs.add(stacks);
        }
        this.allInputs = allInputs.build();
        this.minimalInputStacks = minimalInputStacks.build();
        this.subtypeIndex = subtypeIndex;
        ImmutableList.Builder outputs = ImmutableList.builder();
        this.forOutputMatches((v, output) -> outputs.add(output));
        this.outputs = outputs.build();
    }

    private void forOutputMatches(BiConsumer<ItemStack, ItemStack> outputConsumer) {
        CraftingInventory crafting = new CraftingInventory(new Container(null, 0){

            public boolean func_75145_c(PlayerEntity player) {
                return false;
            }

            public void func_75130_a(IInventory inventory) {
            }
        }, this.getSize().width, this.getSize().height);
        if (this.subtypeIndex == -1) {
            for (int i = 0; i < this.minimalInputStacks.size(); ++i) {
                List stacks = (List)this.minimalInputStacks.get(i);
                crafting.func_70299_a(i, stacks.isEmpty() ? ItemStack.field_190927_a : (ItemStack)stacks.get(0));
            }
            if (this.recipe.matches(crafting, null)) {
                outputConsumer.accept(ItemStack.field_190927_a, this.recipe.getCraftingResult(crafting));
            }
        } else {
            List dictators = (List)this.minimalInputStacks.get(this.subtypeIndex);
            for (ItemStack subtype : dictators) {
                crafting.func_174888_l();
                for (int i = 0; i < this.minimalInputStacks.size(); ++i) {
                    if (i == this.subtypeIndex) {
                        crafting.func_70299_a(i, subtype);
                        continue;
                    }
                    List stacks = (List)this.minimalInputStacks.get(i);
                    crafting.func_70299_a(i, stacks.isEmpty() ? ItemStack.field_190927_a : (ItemStack)stacks.get(0));
                }
                if (!this.recipe.matches(crafting, null)) continue;
                outputConsumer.accept(subtype, this.recipe.getCraftingResult(crafting));
            }
        }
    }

    public Size2i getSize() {
        return new Size2i(3, 3);
    }

    public Input getInputsForOutput(ItemStack output) {
        RegularIngredient[] ingredients = this.recipe.getGenericIngredients();
        ArrayList<Object> inputs = new ArrayList<Object>(9);
        GenericIngredient[] ingredientMat = new GenericIngredient[9];
        AuxiliaryIngredient<?>[] aux = this.recipe.getAuxiliaryIngredients();
        int auxIngIdx = 0;
        int auxIdx = 0;
        for (int i = 0; i < 9; ++i) {
            ImmutableList<ImmutableList<ItemStack>> ingInputs;
            int x = i % 3;
            int y = i / 3;
            RegularIngredient ingredient = null;
            if (x < this.recipe.getWidth() && y < this.recipe.getHeight()) {
                ingredient = ingredients[x + y * this.recipe.getWidth()];
                ingInputs = ingredient.getInput(output);
            } else {
                ingInputs = null;
            }
            if (ingInputs == null || ingInputs.isEmpty()) {
                boolean isEmpty = true;
                if (auxIngIdx < aux.length) {
                    ImmutableList<ImmutableList<ItemStack>> auxInputs = null;
                    AuxiliaryIngredient<?> ingredientAux = null;
                    while (auxIngIdx < aux.length && (auxInputs = (ingredientAux = aux[auxIngIdx]).getInput(output)).size() <= 0) {
                        ++auxIngIdx;
                    }
                    if (auxInputs.size() > 0) {
                        inputs.add(auxInputs.get(auxIdx++));
                        ingredientMat[i] = ingredientAux;
                        if (auxIdx == auxInputs.size()) {
                            auxIdx = 0;
                            ++auxIngIdx;
                        }
                        isEmpty = false;
                    }
                }
                if (!isEmpty) continue;
                inputs.add(Collections.emptyList());
                continue;
            }
            inputs.add(ingInputs.get(0));
            ingredientMat[i] = ingredient;
        }
        return new Input(inputs, ingredientMat);
    }

    private Input getInputsForIngredient(ItemStack ingredient) {
        CraftingInventory crafting = new CraftingInventory(new Container(null, 0){

            public boolean func_75145_c(PlayerEntity player) {
                return false;
            }

            public void func_75130_a(IInventory inventory) {
            }
        }, this.getSize().width, this.getSize().height);
        for (int i = 0; i < this.allInputs.size(); ++i) {
            List options = (List)this.allInputs.get(i);
            ItemStack matched = null;
            for (ItemStack o : options) {
                if (ingredient.func_77973_b() != o.func_77973_b()) continue;
                matched = ingredient.func_77946_l();
                matched.func_190920_e(1);
                break;
            }
            if (matched == null) continue;
            crafting.func_174888_l();
            for (int n = 0; n < this.minimalInputStacks.size(); ++n) {
                List stacks = (List)this.minimalInputStacks.get(n);
                crafting.func_70299_a(n, i == n ? matched : (stacks.isEmpty() ? ItemStack.field_190927_a : (ItemStack)stacks.get(0)));
            }
            if (!this.recipe.matches(crafting, null)) continue;
            ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>(this.allInputs.size());
            for (int n = 0; n < this.allInputs.size(); ++n) {
                List<ItemStack> stacks = (List<ItemStack>)this.allInputs.get(n);
                inputs.add(i == n ? Collections.singletonList(matched) : stacks);
            }
            return new Input(inputs, this.ingredientMatrix);
        }
        return null;
    }

    public List<List<ItemStack>> getOutput(List<List<ItemStack>> inputs) {
        CraftingInventory crafting = new CraftingInventory(new Container(null, 0){

            public boolean func_75145_c(PlayerEntity player) {
                return false;
            }

            public void func_75130_a(IInventory inventory) {
            }
        }, this.getSize().width, this.getSize().height);
        int size = 1;
        for (List<ItemStack> stack : inputs) {
            if (stack.size() <= 0) continue;
            size = Mth.lcm(stack.size(), size);
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(size);
        for (int n = 0; n < size; ++n) {
            for (int i = 0; i < inputs.size(); ++i) {
                List<ItemStack> stacks = inputs.get(i);
                crafting.func_70299_a(i, stacks.isEmpty() ? ItemStack.field_190927_a : stacks.get(n % stacks.size()));
            }
            if (this.recipe.matches(crafting, null)) {
                outputs.add(this.recipe.getCraftingResult(crafting));
                continue;
            }
            LogManager.getLogger().debug("No recipe match for {} using inputs {}", (Object)this.recipe.func_77571_b().func_77973_b().getRegistryName(), (Object)IntStream.range(0, crafting.func_174922_i() * crafting.func_174923_h()).mapToObj(arg_0 -> ((CraftingInventory)crafting).func_70301_a(arg_0)).map(s -> Objects.toString(s.func_77973_b().getRegistryName())).collect(Collectors.joining(", ")));
        }
        return Collections.singletonList(outputs);
    }

    public void setIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.allInputs);
        ingredients.setOutputs(VanillaTypes.ITEM, this.outputs);
    }

    public void setRecipe(IRecipeLayout layout, IIngredients ingredients) {
        IFocus focus = layout.getFocus();
        IGuiItemStackGroup group = layout.getItemStacks();
        if (focus != null && focus.getValue() instanceof ItemStack) {
            ItemStack stack = (ItemStack)focus.getValue();
            Input input = focus.getMode() == IFocus.Mode.OUTPUT ? this.getInputsForOutput(stack) : this.getInputsForIngredient(stack);
            if (input != null) {
                ingredients.setInputLists(VanillaTypes.ITEM, input.inputs);
                ingredients.setOutputLists(VanillaTypes.ITEM, this.getOutput(input.inputs));
                group.addTooltipCallback((ITooltipCallback)new Tooltips(input.ingredients));
            }
        }
        group.set(ingredients);
    }

    private static final class Tooltips
    implements ITooltipCallback<ItemStack> {
        GenericIngredient<?, ?>[] ingredients;

        public Tooltips(GenericIngredient<?, ?>[] ingredients) {
            this.ingredients = ingredients;
        }

        public void onTooltip(int slot, boolean input, ItemStack ingredient, List<ITextComponent> tooltip) {
            GenericIngredient<?, ?> ing;
            if (input && (ing = this.ingredients[slot - 1]) != null) {
                ing.addTooltip(tooltip);
            }
        }
    }

    private static final class Input {
        List<List<ItemStack>> inputs;
        GenericIngredient<?, ?>[] ingredients;

        private Input(List<List<ItemStack>> inputs, GenericIngredient<?, ?>[] ingredients) {
            this.inputs = inputs;
            this.ingredients = ingredients;
        }
    }
}

