/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.util.crafting.ingredient;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import me.paulf.fairylights.util.Utils;
import me.paulf.fairylights.util.crafting.GenericRecipe;
import me.paulf.fairylights.util.crafting.ingredient.GenericIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;

public interface AuxiliaryIngredient<A>
extends GenericIngredient<AuxiliaryIngredient<?>, GenericRecipe.MatchResultAuxiliary> {
    public boolean isRequired();

    public int getLimit();

    @Nullable
    public A accumulator();

    public void consume(A var1, ItemStack var2);

    public boolean finish(A var1, CompoundNBT var2);

    default public boolean process(Multimap<AuxiliaryIngredient<?>, GenericRecipe.MatchResultAuxiliary> map, CompoundNBT nbt) {
        Collection results = map.get((Object)this);
        if (results.isEmpty() && this.isRequired()) {
            return true;
        }
        A ax = this.accumulator();
        for (GenericRecipe.MatchResultAuxiliary result : results) {
            this.consume(ax, result.getInput());
        }
        return this.finish(ax, nbt);
    }

    @Override
    default public void addTooltip(List<ITextComponent> tooltip) {
        if (!this.isRequired()) {
            tooltip.add(Utils.formatRecipeTooltip("recipe.fairylights.ingredient.auxiliary.optional"));
        }
    }
}

