/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.util.crafting.ingredient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Objects;
import me.paulf.fairylights.util.crafting.GenericRecipe;
import me.paulf.fairylights.util.crafting.ingredient.AuxiliaryIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public abstract class BasicAuxiliaryIngredient<A>
implements AuxiliaryIngredient<A> {
    protected final Ingredient ingredient;
    protected final boolean isRequired;
    protected final int limit;

    public BasicAuxiliaryIngredient(Ingredient ingredient, boolean isRequired, int limit) {
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (Object)"limit must be greater than zero");
        this.ingredient = Objects.requireNonNull(ingredient, "ingredient");
        this.isRequired = isRequired;
        this.limit = limit;
    }

    @Override
    public final GenericRecipe.MatchResultAuxiliary matches(ItemStack input) {
        return new GenericRecipe.MatchResultAuxiliary(this, input, this.ingredient.test(input), Collections.emptyList());
    }

    @Override
    public ImmutableList<ItemStack> getInputs() {
        return this.getMatchingSubtypes(this.ingredient);
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }
}

