/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.util.styledstring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import me.paulf.fairylights.util.styledstring.Style;
import me.paulf.fairylights.util.styledstring.StyledString;

public final class StyledStringBuilder
implements Appendable,
CharSequence {
    private final StringBuilder strBldr;
    private final List<Style> styling;
    private Style currentStyle;

    public StyledStringBuilder(String str) {
        this();
        this.append(str);
    }

    public StyledStringBuilder() {
        this(16);
    }

    public StyledStringBuilder(int capacity) {
        this(new StringBuilder(capacity), new ArrayList<Style>(capacity), new Style());
    }

    private StyledStringBuilder(StringBuilder strBldr, List<Style> styling, Style currentStyle) {
        this.strBldr = strBldr;
        this.styling = styling;
        this.currentStyle = currentStyle;
    }

    public StyledStringBuilder setStyle(Style style) {
        this.currentStyle = Objects.requireNonNull(style);
        return this;
    }

    @Override
    public int length() {
        return this.strBldr.length();
    }

    @Override
    public char charAt(int index) {
        return this.strBldr.charAt(index);
    }

    @Override
    public StyledStringBuilder subSequence(int start, int end) {
        return new StyledStringBuilder(new StringBuilder(this.strBldr.substring(start, end)), new ArrayList<Style>(this.styling).subList(start, end), this.styling.get(start));
    }

    public StyledStringBuilder insert(int index, String str) {
        this.strBldr.insert(0, str);
        for (int i = str.length(); i > 0; --i) {
            this.styling.add(index, this.currentStyle);
        }
        return this;
    }

    public StyledStringBuilder insert(int index, StyledString str) {
        this.strBldr.insert(0, str.toUnstyledString());
        Style[] styling = str.getStyling();
        for (int i = styling.length - 1; i >= 0; --i) {
            this.styling.add(index, styling[i]);
        }
        return this;
    }

    public StyledStringBuilder append(StyledString str) {
        this.strBldr.append(str.toUnstyledString());
        this.styling.addAll(Arrays.asList(str.getStyling()));
        return this;
    }

    public StyledStringBuilder append(CharSequence csq, Style style) {
        this.strBldr.append(csq);
        for (int i = 0; i < csq.length(); ++i) {
            this.styling.add(style);
        }
        return this;
    }

    @Override
    public StyledStringBuilder append(CharSequence csq) {
        this.strBldr.append(csq);
        for (int i = 0; i < csq.length(); ++i) {
            this.styling.add(this.currentStyle);
        }
        return this;
    }

    @Override
    public StyledStringBuilder append(CharSequence csq, int start, int end) {
        return this.append(csq.subSequence(start, end));
    }

    @Override
    public StyledStringBuilder append(char c) {
        return this.append(c, this.currentStyle);
    }

    public StyledStringBuilder append(char c, Style s) {
        this.strBldr.append(c);
        this.styling.add(s);
        return this;
    }

    @Override
    public String toString() {
        return this.strBldr.toString();
    }

    public StyledString toStyledString() {
        return new StyledString(this.strBldr.toString(), this.styling.toArray(new Style[0]));
    }
}

