/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.storage;

import appeng.block.AEBaseTileBlock;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.implementations.SkyChestContainer;
import appeng.tile.storage.SkyChestTileEntity;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class SkyChestBlock
extends AEBaseTileBlock<SkyChestTileEntity>
implements IWaterLoggable {
    private static final double AABB_OFFSET_BOTTOM = 0.0;
    private static final double AABB_OFFSET_SIDES = 0.06;
    private static final double AABB_OFFSET_TOP = 0.0625;
    private static final Map<Direction, VoxelShape> SHAPES = new EnumMap<Direction, VoxelShape>(Direction.class);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public final SkyChestType type;

    public SkyChestBlock(SkyChestType type, AbstractBlock.Properties props) {
        super(props);
        this.type = type;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    @Override
    public ActionResultType onActivated(World w, BlockPos pos, PlayerEntity player, Hand hand, @Nullable ItemStack heldItem, BlockRayTraceResult hit) {
        SkyChestTileEntity tile;
        if (!w.func_201670_d() && (tile = (SkyChestTileEntity)this.getTileEntity((IBlockReader)w, pos)) != null) {
            ContainerOpener.openContainer(SkyChestContainer.TYPE, player, ContainerLocator.forTileEntity(tile));
        }
        return ActionResultType.func_233537_a_((boolean)w.func_201670_d());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        SkyChestTileEntity sk = (SkyChestTileEntity)this.getTileEntity(worldIn, pos);
        Direction up = sk != null ? sk.getUp() : Direction.UP;
        return SHAPES.get(up);
    }

    private static AxisAlignedBB computeAABB(Direction up) {
        double offsetX = up.func_82601_c() == 0 ? 0.06 : 0.0;
        double offsetY = up.func_96559_d() == 0 ? 0.06 : 0.0;
        double offsetZ = up.func_82599_e() == 0 ? 0.06 : 0.0;
        double minX = Math.max(0.0, offsetX + (up.func_82601_c() < 0 ? 0.0 : (double)up.func_82601_c() * 0.0625));
        double minY = Math.max(0.0, offsetY + (up.func_96559_d() < 0 ? 0.0625 : (double)up.func_96559_d() * 0.0));
        double minZ = Math.max(0.0, offsetZ + (up.func_82599_e() < 0 ? 0.0 : (double)up.func_82599_e() * 0.0625));
        double maxX = Math.min(1.0, 1.0 - offsetX - (up.func_82601_c() < 0 ? 0.0625 : (double)up.func_82601_c() * 0.0));
        double maxY = Math.min(1.0, 1.0 - offsetY - (up.func_96559_d() < 0 ? 0.0 : (double)up.func_96559_d() * 0.0625));
        double maxZ = Math.min(1.0, 1.0 - offsetZ - (up.func_82599_e() < 0 ? 0.0625 : (double)up.func_82599_e() * 0.0));
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        FluidState fluidState = context.func_195991_k().func_204610_c(pos);
        BlockState blockState = (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
        return blockState;
    }

    public FluidState func_204507_t(BlockState blockState) {
        return (Boolean)blockState.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(blockState);
    }

    public BlockState func_196271_a(BlockState blockState, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)blockState.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(blockState, facing, facingState, world, currentPos, facingPos);
    }

    static {
        for (Direction up : Direction.values()) {
            AxisAlignedBB aabb = SkyChestBlock.computeAABB(up);
            SHAPES.put(up, VoxelShapes.func_197881_a((AxisAlignedBB)aabb));
        }
    }

    public static enum SkyChestType {
        STONE,
        BLOCK;

    }
}

